/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.border.Border;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy = 20;
    protected int hsbPolicy = 30;

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("VIEWPORT")) {
            this.viewport = (JViewport)this.addSingletonComponent(this.viewport, component);
        } else if (string.equals("VERTICAL_SCROLLBAR")) {
            this.vsb = (JScrollBar)this.addSingletonComponent(this.vsb, component);
        } else if (string.equals("HORIZONTAL_SCROLLBAR")) {
            this.hsb = (JScrollBar)this.addSingletonComponent(this.hsb, component);
        } else if (string.equals("ROW_HEADER")) {
            this.rowHead = (JViewport)this.addSingletonComponent(this.rowHead, component);
        } else if (string.equals("COLUMN_HEADER")) {
            this.colHead = (JViewport)this.addSingletonComponent(this.colHead, component);
        } else if (string.equals("LOWER_LEFT_CORNER")) {
            this.lowerLeft = this.addSingletonComponent(this.lowerLeft, component);
        } else if (string.equals("LOWER_RIGHT_CORNER")) {
            this.lowerRight = this.addSingletonComponent(this.lowerRight, component);
        } else if (string.equals("UPPER_LEFT_CORNER")) {
            this.upperLeft = this.addSingletonComponent(this.upperLeft, component);
        } else if (string.equals("UPPER_RIGHT_CORNER")) {
            this.upperRight = this.addSingletonComponent(this.upperRight, component);
        } else {
            throw new IllegalArgumentException("invalid layout key " + string);
        }
    }

    protected Component addSingletonComponent(Component component, Component component2) {
        if (component != null && component != component2) {
            component.getParent().remove(component);
        }
        return component2;
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public Component getCorner(String string) {
        if (string.equals("LOWER_LEFT_CORNER")) {
            return this.lowerLeft;
        }
        if (string.equals("LOWER_RIGHT_CORNER")) {
            return this.lowerRight;
        }
        if (string.equals("UPPER_LEFT_CORNER")) {
            return this.upperLeft;
        }
        if (string.equals("UPPER_RIGHT_CORNER")) {
            return this.upperRight;
        }
        return null;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Rectangle getViewportBorderBounds(JScrollPane jScrollPane) {
        return jScrollPane.getViewportBorderBounds();
    }

    public void layoutContainer(Container container) {
        boolean bl;
        boolean bl2;
        Object object;
        Insets insets;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Rectangle rectangle = new Rectangle(jScrollPane.getSize());
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Rectangle rectangle2 = new Rectangle(0, rectangle.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int n;
            rectangle2.height = n = this.colHead.getPreferredSize().height;
            rectangle.y += n;
            rectangle.height -= n;
        }
        Rectangle rectangle3 = new Rectangle(rectangle.x, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n;
            rectangle3.width = n = this.rowHead.getPreferredSize().width;
            rectangle.x += n;
            rectangle.width -= n;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        rectangle2.x = rectangle.x;
        rectangle3.y = rectangle.y;
        Component component = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl3 = false;
        boolean bl4 = false;
        if (component instanceof Scrollable) {
            object = (Scrollable)((Object)component);
            bl3 = object.getScrollableTracksViewportWidth();
            bl4 = object.getScrollableTracksViewportHeight();
        }
        object = new Rectangle(0, rectangle.y - insets.top, 0, 0);
        if (this.vsbPolicy == 22) {
            bl2 = true;
        } else if (this.vsbPolicy == 21) {
            bl2 = false;
        } else {
            boolean bl5 = bl2 = !bl4 && dimension.height > dimension2.height;
        }
        if (this.vsb != null && bl2) {
            int n = this.vsb.getPreferredSize().width;
            rectangle.width -= n;
            ((Rectangle)object).x = rectangle.x + rectangle.width + insets.right;
            ((Rectangle)object).width = n;
        }
        Rectangle rectangle4 = new Rectangle(rectangle.x - insets.left, 0, 0, 0);
        if (this.hsbPolicy == 32) {
            bl = true;
        } else if (this.hsbPolicy == 31) {
            bl = false;
        } else {
            boolean bl6 = bl = !bl3 && dimension.width > dimension2.width;
        }
        if (this.hsb != null && bl) {
            int n = this.hsb.getPreferredSize().height;
            rectangle.height -= n;
            rectangle4.y = rectangle.y + rectangle.height + insets.bottom;
            rectangle4.height = n;
            if (this.vsb != null && !bl2 && this.vsbPolicy != 21) {
                dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                boolean bl7 = bl2 = dimension.height > dimension2.height;
                if (bl2) {
                    int n2 = this.vsb.getPreferredSize().width;
                    rectangle.width -= n2;
                    ((Rectangle)object).x = rectangle.x + rectangle.width + insets.right;
                    ((Rectangle)object).width = n2;
                }
            }
        }
        ((Rectangle)object).height = rectangle.height + insets.top + insets.bottom;
        rectangle4.width = rectangle.width + insets.left + insets.right;
        rectangle3.height = rectangle.height;
        rectangle2.width = rectangle.width;
        if (this.viewport != null) {
            this.viewport.setBounds(rectangle);
        }
        if (this.rowHead != null) {
            this.rowHead.setBounds(rectangle3);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(rectangle2);
        }
        if (this.vsb != null) {
            if (bl2) {
                this.vsb.setVisible(true);
                this.vsb.setBounds((Rectangle)object);
            } else {
                this.vsb.setVisible(false);
            }
        }
        if (this.hsb != null) {
            if (bl) {
                this.hsb.setVisible(true);
                this.hsb.setBounds(rectangle4);
            } else {
                this.hsb.setVisible(false);
            }
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(rectangle3.x, rectangle4.y, rectangle3.width, rectangle4.height);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(((Rectangle)object).x, rectangle4.y, ((Rectangle)object).width, rectangle4.height);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(rectangle3.x, rectangle2.y, rectangle3.width, rectangle2.height);
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(((Rectangle)object).x, rectangle2.y, ((Rectangle)object).width, rectangle2.height);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Object object;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            n += ((Dimension)object).width;
            n2 += ((Dimension)object).height;
        }
        if ((object = jScrollPane.getViewportBorder()) != null) {
            cloneable = object.getBorderInsets(container);
            n += cloneable.left + cloneable.right;
            n2 += cloneable.top + cloneable.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            cloneable = this.rowHead.getMinimumSize();
            n += ((Dimension)cloneable).width;
            n2 = Math.max(n2, ((Dimension)cloneable).height);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            cloneable = this.colHead.getMinimumSize();
            n = Math.max(n, ((Dimension)cloneable).width);
            n2 += ((Dimension)cloneable).height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            cloneable = this.vsb.getMinimumSize();
            n += ((Dimension)cloneable).width;
            n2 = Math.max(n2, ((Dimension)cloneable).height);
        }
        if (this.hsb != null && this.hsbPolicy != 21) {
            cloneable = this.hsb.getMinimumSize();
            n = Math.max(n, ((Dimension)cloneable).width);
            n2 += ((Dimension)cloneable).height;
        }
        return new Dimension(n, n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
        }
        if (dimension != null) {
            n += dimension.width;
            n2 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n += insets2.left + insets2.right;
            n2 += insets2.top + insets2.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n2 += this.colHead.getPreferredSize().height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                n += this.vsb.getPreferredSize().width;
            } else if (dimension2 != null && dimension != null) {
                boolean bl = true;
                if (component instanceof Scrollable) {
                    bl = ((Scrollable)((Object)component)).getScrollableTracksViewportHeight() ^ true;
                }
                if (bl && dimension2.height > dimension.height) {
                    n += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                n2 += this.hsb.getPreferredSize().height;
            } else if (dimension2 != null && dimension != null) {
                boolean bl = true;
                if (component instanceof Scrollable) {
                    bl = ((Scrollable)((Object)component)).getScrollableTracksViewportWidth() ^ true;
                }
                if (bl && dimension2.width > dimension.width) {
                    n2 += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(n, n2);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
        } else if (component == this.vsb) {
            this.vsb = null;
        } else if (component == this.hsb) {
            this.hsb = null;
        } else if (component == this.rowHead) {
            this.rowHead = null;
        } else if (component == this.colHead) {
            this.colHead = null;
        } else if (component == this.lowerLeft) {
            this.lowerLeft = null;
        } else if (component == this.lowerRight) {
            this.lowerRight = null;
        } else if (component == this.upperLeft) {
            this.upperLeft = null;
        } else if (component == this.upperRight) {
            this.upperRight = null;
        }
    }

    public void setHorizontalScrollBarPolicy(int n) {
        switch (n) {
            case 30: 
            case 31: 
            case 32: {
                this.hsbPolicy = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid horizontalScrollBarPolicy");
            }
        }
    }

    public void setVerticalScrollBarPolicy(int n) {
        switch (n) {
            case 20: 
            case 21: 
            case 22: {
                this.vsbPolicy = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid verticalScrollBarPolicy");
            }
        }
    }

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        this.viewport = jScrollPane.getViewport();
        this.vsb = jScrollPane.getVerticalScrollBar();
        this.hsb = jScrollPane.getHorizontalScrollBar();
        this.rowHead = jScrollPane.getRowHeader();
        this.colHead = jScrollPane.getColumnHeader();
        this.lowerLeft = jScrollPane.getCorner("LOWER_LEFT_CORNER");
        this.lowerRight = jScrollPane.getCorner("LOWER_RIGHT_CORNER");
        this.upperLeft = jScrollPane.getCorner("UPPER_LEFT_CORNER");
        this.upperRight = jScrollPane.getCorner("UPPER_RIGHT_CORNER");
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
    }

    public static class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

