/*
 * Decompiled with CFR 0.152.
 */
package platform;

import anon.util.ClassUtil;
import anon.util.Util;
import gui.dialog.JAPDialog;
import gui.help.JAPHelp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import platform.VMPerfDataFile;

public abstract class AbstractOS
implements JAPHelp.IExternalURLCaller,
JAPHelp.IExternalEMailCaller {
    public static final String URL_MAIL_TO = "mailto:";
    private static Class[] REGISTERED_PLATFORM_CLASSES = new Class[]{class$platform$LinuxOS == null ? (class$platform$LinuxOS = AbstractOS.class$("platform.LinuxOS")) : class$platform$LinuxOS, class$platform$WindowsOS == null ? (class$platform$WindowsOS = AbstractOS.class$("platform.WindowsOS")) : class$platform$WindowsOS, class$platform$MacOS == null ? (class$platform$MacOS = AbstractOS.class$("platform.MacOS")) : class$platform$MacOS, class$platform$UnknownOS == null ? (class$platform$UnknownOS = AbstractOS.class$("platform.UnknownOS")) : class$platform$UnknownOS};
    private static final String[] BROWSERLIST = new String[]{"firefox", "iexplore", "explorer", "mozilla", "konqueror", "mozilla-firefox", "opera"};
    private static final String WHITESPACE_ENCODED = "%20";
    private static AbstractOS ms_operatingSystem;
    private IURLErrorNotifier m_notifier;
    private AbstractURLOpener m_URLOpener;
    private Properties m_envVars;
    private static File ms_tmpDir;
    static /* synthetic */ Class class$platform$LinuxOS;
    static /* synthetic */ Class class$platform$WindowsOS;
    static /* synthetic */ Class class$platform$MacOS;
    static /* synthetic */ Class class$platform$UnknownOS;

    public static final AbstractOS getInstance() {
        for (int i = 0; ms_operatingSystem == null && i < REGISTERED_PLATFORM_CLASSES.length; ++i) {
            try {
                ms_operatingSystem = (AbstractOS)REGISTERED_PLATFORM_CLASSES[i].newInstance();
            }
            catch (Exception exception) {
                LogHolder.log((int)7, (int)LogType.MISC, (String)("Cannot instantiate class " + REGISTERED_PLATFORM_CLASSES[i] + ". Trying to instanciate another platform class."));
            }
            if (ms_operatingSystem == null) continue;
            AbstractOS.ms_operatingSystem.m_notifier = new IURLErrorNotifier(){

                public void checkNotify(URL uRL) {
                }
            };
        }
        return ms_operatingSystem;
    }

    public static String createBrowserCommand(String string) {
        string = Util.replaceAll((String)string, (String)"/", (String)File.separator);
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.indexOf(WHITESPACE_ENCODED, 0);
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(" ");
            n2 = n + WHITESPACE_ENCODED.length();
            n = string.indexOf(WHITESPACE_ENCODED, n + 1);
        }
        stringBuffer.append(string.substring(n2));
        string = AbstractOS.toAbsolutePath(stringBuffer.toString());
        return string;
    }

    public static String toRelativePath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = System.getProperty("user.dir");
        String string3 = "";
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.lastIndexOf(File.separator));
        }
        while (true) {
            if (string2.length() == 0 || string.indexOf(string2) == 0) {
                if ((string = string.substring(string2.length(), string.length())).startsWith(File.separator)) {
                    string = string.substring(string.indexOf(File.separator) + 1, string.length());
                }
                break;
            }
            int n = string2.lastIndexOf(File.separator);
            if (n >= 0) {
                string2 = string2.substring(0, n);
                string3 = string3 + ".." + File.separator;
                continue;
            }
            string2 = "";
        }
        string = string3 + string;
        return string;
    }

    public static String toAbsolutePath(String string) {
        if (string != null) {
            if (File.separator.equals("\\") && !string.startsWith(File.separator) && string.length() >= 3 && !string.substring(1, 3).equals(":" + File.separator) || File.separator.equals("/") && !string.startsWith(File.separator)) {
                return System.getProperty("user.dir") + File.separator + string;
            }
            return string;
        }
        return null;
    }

    public void init(IURLErrorNotifier iURLErrorNotifier, AbstractURLOpener abstractURLOpener) {
        if (iURLErrorNotifier != null) {
            this.m_notifier = iURLErrorNotifier;
        }
        if (abstractURLOpener != null) {
            this.m_URLOpener = abstractURLOpener;
        }
    }

    public JAPDialog.ILinkedInformation createURLLink(URL uRL, String string) {
        return this.createURLLink(uRL, string, null);
    }

    public JAPDialog.ILinkedInformation createURLLink(final URL uRL, final String string, String string2) {
        if (uRL == null) {
            return null;
        }
        JAPDialog.LinkedHelpContext linkedHelpContext = new JAPDialog.LinkedHelpContext(string2){

            public int getType() {
                return 1;
            }

            public void clicked(boolean bl) {
                AbstractOS.this.openURL(uRL);
            }

            public String getMessage() {
                if (string == null || string.trim().length() == 0) {
                    return uRL.toString();
                }
                return string;
            }
        };
        return linkedHelpContext;
    }

    public final boolean openEMail(String string) {
        if (string == null) {
            return false;
        }
        if (!string.startsWith(URL_MAIL_TO)) {
            return this.openLink(URL_MAIL_TO + string);
        }
        return this.openLink(string);
    }

    public final String getDefaultBrowserPath() {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.getBrowserPath();
        }
        return null;
    }

    public final boolean isDefaultURLAvailable() {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.getDefaultURL() != null && this.m_URLOpener.getBrowserCommand() != null;
        }
        return false;
    }

    public final boolean openBrowser() {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.openBrowser();
        }
        return false;
    }

    public final boolean openBrowser(String string) {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.openBrowser(string);
        }
        return false;
    }

    public final boolean openURL(URL uRL) {
        boolean bl = false;
        if (uRL == null) {
            return false;
        }
        String[] stringArray = BROWSERLIST;
        String string = this.getAsString(uRL);
        this.m_notifier.checkNotify(uRL);
        if (this.m_URLOpener != null) {
            bl = this.m_URLOpener.openURL(uRL);
        }
        if (!bl) {
            bl = this.openLink(string);
        }
        if (!bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Runtime.getRuntime().exec(new String[]{stringArray[i], string});
                    bl = true;
                    break;
                }
                catch (SecurityException securityException) {
                    LogHolder.log((int)3, (int)LogType.MISC, (Throwable)securityException);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        if (!bl) {
            LogHolder.log((int)3, (int)LogType.MISC, (String)"Cannot open URL in browser");
        }
        return bl;
    }

    public abstract String getConfigPath(String var1);

    protected abstract boolean openLink(String var1);

    protected String getAsString(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return uRL.toString();
    }

    public boolean isHelpAutoInstalled() {
        return false;
    }

    public String getDefaultHelpPath(String string) {
        File file = ClassUtil.getClassDirectory(this.getClass());
        if (file != null) {
            return file.getParent();
        }
        return System.getProperty("user.dir");
    }

    public String getAppdataDefaultDirectory(String string) {
        return null;
    }

    public Vector getActiveVMs() {
        Vector<VMPerfDataFile> vector = new Vector<VMPerfDataFile>();
        int n = 0;
        if (!ms_tmpDir.isDirectory()) {
            return vector;
        }
        String[] stringArray = ms_tmpDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("hsperfdata_");
            }
        });
        if (stringArray == null) {
            return vector;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            File file = new File(ms_tmpDir + File.separator + stringArray[i]);
            if (!file.isDirectory() || (stringArray2 = file.list()) == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                File file2 = new File(file + File.separator + stringArray2[j]);
                if (!file2.isFile() || !file2.canRead()) continue;
                try {
                    n = Integer.parseInt(file2.getName());
                    if (n == 0) continue;
                    vector.addElement(new VMPerfDataFile(n));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return vector;
    }

    public boolean copyAsRoot(File file, File file2, AbstractRetryCopyProcess abstractRetryCopyProcess) {
        return false;
    }

    public String getTempPath() {
        return AbstractOS.getDefaultTempPath();
    }

    public static String getDefaultTempPath() {
        String string = null;
        try {
            string = System.getProperty("java.io.tmpdir", null);
            if (string != null && !string.endsWith(File.separator)) {
                string = string + File.separator;
            }
        }
        catch (Throwable throwable) {
            LogHolder.log((int)3, (int)LogType.MISC, (Throwable)throwable);
        }
        return string;
    }

    public String getProperty(String string) {
        String string2 = null;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            string2 = System.getProperty(string, null);
        }
        catch (Throwable throwable) {
            LogHolder.log((int)3, (int)LogType.MISC, (String)("Could not get system property " + string));
        }
        return string2;
    }

    public String getenv(String string) {
        String string2 = null;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            string2 = System.getenv(string);
        }
        catch (SecurityException securityException) {
            LogHolder.log((int)3, (int)LogType.MISC, (Throwable)securityException);
        }
        catch (Error error) {
            // empty catch block
        }
        if (string2 == null && this.m_envVars != null) {
            string2 = this.m_envVars.getProperty(string);
        }
        if (string2 == null) {
            try {
                string2 = System.getProperty(string);
            }
            catch (Throwable throwable) {
                LogHolder.log((int)3, (int)LogType.MISC, (Throwable)throwable);
            }
        }
        return string2;
    }

    protected void initEnv(String string) {
        try {
            this.m_envVars = new Properties();
            InitEnvRunner initEnvRunner = new InitEnvRunner();
            initEnvRunner.m_envCommand = string;
            Thread thread = new Thread(initEnvRunner);
            thread.setDaemon(true);
            thread.start();
            LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv -  killing the environment process starts sleeping");
            thread.join(5000L);
            LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv -  killing the environment process ends sleeping");
            if (initEnvRunner.envProcess != null) {
                initEnvRunner.envProcess.destroy();
            }
            LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv -  killing the environment process -- killed.");
            thread.interrupt();
            LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv -  killing the environment process ended.");
        }
        catch (Throwable throwable) {
            LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv - excpetion while killing the environment process");
            LogHolder.log((int)7, (int)LogType.MISC, (Throwable)throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            if (string.compareTo("/var/tmp/") == 0) {
                string = "/tmp/";
            }
            if (string.lastIndexOf(File.pathSeparator) != string.length() - 1) {
                string = string + File.separator;
            }
        } else {
            string = "." + File.separator;
        }
        ms_tmpDir = new File(string);
    }

    private class InitEnvRunner
    implements Runnable {
        public Process envProcess;
        public BufferedReader br;
        public InputStream inProcess;
        public String m_envCommand;

        private InitEnvRunner() {
        }

        public void run() {
            try {
                this.envProcess = Runtime.getRuntime().exec(this.m_envCommand);
                this.inProcess = this.envProcess.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.inProcess));
                String string = null;
                while ((string = this.br.readLine()) != null) {
                    LogHolder.log((int)7, (int)LogType.MISC, (String)("initEnv - read evironment line: " + string));
                    int n = string.indexOf(61);
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    ((Hashtable)AbstractOS.this.m_envVars).put(string2, string3);
                }
                LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv - read evironment lines finished.");
            }
            catch (IOException iOException) {
                LogHolder.log((int)2, (int)LogType.MISC, (String)"Could not parse environment variables.", (Throwable)iOException);
            }
            catch (SecurityException securityException) {
                LogHolder.log((int)3, (int)LogType.MISC, (String)"Could not parse environment variables.", (Throwable)securityException);
            }
            catch (Throwable throwable) {
                LogHolder.log((int)7, (int)LogType.MISC, (String)"initEnv - excpetion");
                LogHolder.log((int)7, (int)LogType.MISC, (Throwable)throwable);
            }
        }
    }

    public static abstract class AbstractRetryCopyProcess {
        private int m_maxSteps;
        private int m_currentStep;

        public AbstractRetryCopyProcess(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Max steps <=0! Value: " + n);
            }
            this.m_maxSteps = n;
            this.m_currentStep = 0;
        }

        public abstract boolean checkRetry();

        public final int getMaxProgressSteps() {
            return this.m_maxSteps;
        }

        public final long getProgressLoopWaitMilliseconds() {
            return 500L;
        }

        public final int getCurrentStep() {
            return this.m_currentStep;
        }

        public void reset() {
            this.m_currentStep = 0;
        }

        public boolean incrementProgress() {
            if (this.m_currentStep < this.m_maxSteps) {
                ++this.m_currentStep;
                return true;
            }
            return false;
        }
    }

    public static interface IURLErrorNotifier {
        public void checkNotify(URL var1);
    }

    public static abstract class AbstractURLOpener {
        private Process m_portableFirefoxProcess = null;
        private boolean m_bOneSessionOnly = false;

        public final synchronized boolean openURL(URL uRL) {
            return this.openURL(uRL, this.getBrowserCommand());
        }

        public synchronized boolean openURL(URL uRL, String string) {
            if (string == null || uRL == null) {
                return false;
            }
            if (this.m_portableFirefoxProcess != null && this.m_bOneSessionOnly) {
                try {
                    int n = this.m_portableFirefoxProcess.exitValue();
                    LogHolder.log((int)6, (int)LogType.MISC, (String)("previous portable firefox process exited " + (n == 0 ? "normally " : "anormally ") + "(exit value " + n + ")."));
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    LogHolder.log((int)4, (int)LogType.MISC, (String)"Portable Firefox process is still running!");
                    return true;
                }
            }
            String[] stringArray = new String[]{string, uRL.toString()};
            try {
                this.m_portableFirefoxProcess = Runtime.getRuntime().exec(stringArray);
                return true;
            }
            catch (SecurityException securityException) {
                LogHolder.log((int)4, (int)LogType.MISC, (String)"You are not allowed to launch portable firefox: ", (Throwable)securityException);
            }
            catch (IOException iOException) {
                LogHolder.log((int)4, (int)LogType.MISC, (String)("Error occured while launching portable browser with command '" + stringArray[0] + " " + stringArray[1] + "'"), (Throwable)iOException);
            }
            return false;
        }

        public abstract String getBrowserCommand();

        public abstract String getBrowserPath();

        public abstract URL getDefaultURL();

        public final synchronized boolean openBrowser() {
            return this.openBrowser(this.getBrowserCommand());
        }

        public final synchronized boolean openBrowser(String string) {
            this.m_bOneSessionOnly = true;
            boolean bl = this.openURL(this.getDefaultURL(), string);
            this.m_bOneSessionOnly = false;
            return bl;
        }
    }
}

