/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLEasyCC;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLAccountInfo
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME_COST_CONFIRMATIONS = "CostConfirmations";
    private XMLBalance m_balance = null;
    private Hashtable m_costConfirmations = new Hashtable();

    public XMLAccountInfo(XMLBalance xMLBalance) {
        this.m_balance = xMLBalance;
    }

    public XMLAccountInfo(String string) throws Exception {
        Document document = XMLUtil.toXMLDocument(string);
        this.setValues(document.getDocumentElement());
    }

    public XMLAccountInfo() {
    }

    public XMLAccountInfo(Element element) throws Exception {
        this.setValues(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document document) {
        Element element = document.createElement("AccountInfo");
        element.setAttribute("version", "1.1");
        Element element2 = this.m_balance.toXmlElement(document);
        element.appendChild(element2);
        Element element3 = document.createElement(XML_ELEMENT_NAME_COST_CONFIRMATIONS);
        element.appendChild(element3);
        Hashtable hashtable = this.m_costConfirmations;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_costConfirmations.elements();
            while (enumeration.hasMoreElements()) {
                XMLEasyCC xMLEasyCC = (XMLEasyCC)enumeration.nextElement();
                element2 = xMLEasyCC.toXmlElement(document);
                element3.appendChild(element2);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addCC(XMLEasyCC xMLEasyCC) throws Exception {
        long l = 0L;
        Hashtable hashtable = this.m_costConfirmations;
        synchronized (hashtable) {
            XMLEasyCC xMLEasyCC2 = (XMLEasyCC)this.m_costConfirmations.get(xMLEasyCC.getConcatenatedPriceCertHashes());
            if (xMLEasyCC2 != null) {
                l = xMLEasyCC2.getTransferredBytes();
            }
            if (xMLEasyCC.getTransferredBytes() >= l) {
                this.m_costConfirmations.put(xMLEasyCC.getConcatenatedPriceCertHashes(), xMLEasyCC);
            }
        }
        return xMLEasyCC.getTransferredBytes() - l;
    }

    private void setValues(Element element) throws Exception {
        if (!element.getTagName().equals("AccountInfo")) {
            LogHolder.log(2, LogType.PAY, "invalid XML structure: " + XMLUtil.toString(element));
            throw new Exception("XMLAccountInfo wrong XML structure");
        }
        Element element2 = (Element)XMLUtil.getFirstChildByName(element, "Balance");
        this.m_balance = new XMLBalance(element2);
        Element element3 = (Element)XMLUtil.getFirstChildByName(element, XML_ELEMENT_NAME_COST_CONFIRMATIONS);
        Element element4 = (Element)XMLUtil.getFirstChildByName(element3, "CC");
        XMLEasyCC xMLEasyCC = null;
        while (element4 != null) {
            xMLEasyCC = new XMLEasyCC(element4);
            this.m_costConfirmations.put(xMLEasyCC.getConcatenatedPriceCertHashes(), xMLEasyCC);
            element4 = (Element)XMLUtil.getNextSiblingByName(element4, "CC");
        }
    }

    public XMLBalance getBalance() {
        return this.m_balance;
    }

    public XMLEasyCC getCC(String string) {
        return (XMLEasyCC)this.m_costConfirmations.get(string);
    }

    public Enumeration getCCs() {
        return ((Hashtable)this.m_costConfirmations.clone()).elements();
    }

    public long getAllCCsTransferredBytes() {
        long l = 0L;
        Enumeration enumeration = this.m_costConfirmations.elements();
        while (enumeration.hasMoreElements()) {
            l += ((XMLEasyCC)enumeration.nextElement()).getTransferredBytes();
        }
        return l;
    }

    public void setBalance(XMLBalance xMLBalance) {
        this.m_balance = xMLBalance;
    }

    public XMLAccountInfo(Document document) throws Exception {
        this.setValues(document.getDocumentElement());
    }
}

