/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.crypto.ICertificate;
import anon.crypto.PKCS12;
import anon.crypto.SignatureCreator;
import anon.infoservice.Database;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import gui.TitledGridBagPanel;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.MixConfig;
import mixconfig.panels.CertPanel;
import org.w3c.dom.Document;

public class TemplateSigningTool
extends JAPDialog
implements ActionListener,
ChangeListener {
    private CertPanel certPanel = null;
    private TitledGridBagPanel templatePanel = null;
    private JComboBox templatesBox = null;
    private JButton loadTemplateButton = null;
    private JButton signButton = null;
    private JButton closeButton = null;
    private Frame parent = null;
    private PKCS12 signingKey = null;
    private SignatureCreator signer = SignatureCreator.getInstance();

    public TemplateSigningTool(Frame parent) {
        super(parent, "Sign the templates");
        this.parent = parent;
        this.setDefaultCloseOperation(2);
        this.certPanel = new CertPanel("Signing certificate (PKCS #12)", "Hint: Private Certificate to sign a Public Certificate", (PKCS12)null, 3, 0);
        this.certPanel.addChangeListener(this);
        this.loadTemplateButton = new JButton("Load");
        this.loadTemplateButton.addActionListener(this);
        this.signButton = new JButton("Sign");
        this.closeButton = new JButton("Close");
        this.signButton.setEnabled(false);
        this.signButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        JPanel loadTemplateTemplate = new JPanel();
        loadTemplateTemplate.add(this.loadTemplateButton);
        this.templatesBox = new JComboBox();
        this.templatePanel = new TitledGridBagPanel("Available templates");
        this.templatePanel.addRow(new JLabel("Template"), this.templatesBox);
        this.templatePanel.addRow(loadTemplateTemplate);
        for (TermsAndConditionsTemplate template : this.getAllTemplates()) {
            this.templatesBox.addItem(template.getId());
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.signButton);
        Container contentPane = this.getContentPane();
        GridBagLayout dialogLayout = new GridBagLayout();
        GridBagConstraints dialogConstraints = new GridBagConstraints();
        contentPane.setLayout(dialogLayout);
        dialogConstraints.anchor = 17;
        dialogConstraints.gridx = 0;
        dialogConstraints.gridy = 0;
        dialogConstraints.insets = new Insets(5, 5, 5, 5);
        dialogConstraints.fill = 1;
        dialogConstraints.gridheight = 1;
        dialogConstraints.gridy = 0;
        contentPane.add((Component)this.certPanel, dialogConstraints);
        ++dialogConstraints.gridy;
        contentPane.add((Component)this.templatePanel, dialogConstraints);
        ++dialogConstraints.gridy;
        contentPane.add((Component)buttonPanel, dialogConstraints);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.dispose();
        } else if (e.getSource() == this.signButton) {
            TermsAndConditionsTemplate selectedTemplate = this.getSelectedTemplate();
            if (selectedTemplate != null && this.signingKey != null) {
                Document docToSign = selectedTemplate.getDocument();
                this.signer.signXml(5, docToSign);
                selectedTemplate.setSignedDocument(docToSign);
                this.exportFile(selectedTemplate);
            }
        } else if (e.getSource() == this.loadTemplateButton) {
            this.loadTemplateFromFile();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ICertificate cert = this.certPanel.getCert();
        this.signingKey = (PKCS12)(cert instanceof PKCS12 ? cert : null);
        boolean signingKeyAvaliable = this.signingKey != null;
        this.signButton.setEnabled(signingKeyAvaliable);
        if (signingKeyAvaliable) {
            this.signer.setSigningKey(5, this.signingKey);
        }
    }

    private void loadTemplateFromFile() {
        JFileChooser fc = MixConfig.showFileDialog(this.parent, 4, 2);
        if (fc != null) {
            File[] fs;
            TermsAndConditionsTemplate currentTemplate = null;
            for (File file : fs = fc.getSelectedFiles()) {
                try {
                    currentTemplate = new TermsAndConditionsTemplate(file);
                    Database.getInstance(TermsAndConditionsTemplate.class).update(currentTemplate);
                    this.removeOldItem(currentTemplate.getId());
                    this.templatesBox.addItem(currentTemplate.getId());
                }
                catch (XMLParseException e) {
                    JAPDialog.showErrorDialog((JAPDialog)this, "Cannot load template", (Throwable)e);
                }
                catch (IOException e) {
                    JAPDialog.showErrorDialog((JAPDialog)this, "Cannot load template", (Throwable)e);
                }
            }
        }
    }

    private void exportFile(TermsAndConditionsTemplate template) {
        JFileChooser fc = new JFileChooser();
        File suggestedFile = new File(fc.getCurrentDirectory() + File.separator + template.getId() + ".xml");
        fc.setSelectedFile(suggestedFile);
        int clicked = fc.showSaveDialog(this.parent);
        switch (clicked) {
            case 0: {
                File selectedFile = fc.getSelectedFile();
                boolean confirmed = true;
                if (selectedFile.exists()) {
                    boolean bl = confirmed = JAPDialog.showConfirmDialog(this, "File already exists. Overwrite?", 0, 3) == 0;
                }
                if (!confirmed) break;
                try {
                    OutputStreamWriter exportWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), "UTF-8");
                    XMLUtil.write(template.getDocument(), exportWriter);
                    exportWriter.flush();
                    exportWriter.close();
                }
                catch (IOException e) {
                    JAPDialog.showErrorDialog((JAPDialog)this, "IOException occured.", (Throwable)e);
                }
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private TermsAndConditionsTemplate getSelectedTemplate() {
        Object item = this.templatesBox.getSelectedItem();
        return (TermsAndConditionsTemplate)(item != null ? Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(item.toString()) : null);
    }

    private Iterable<TermsAndConditionsTemplate> getAllTemplates() {
        return Database.getInstance(TermsAndConditionsTemplate.class).getEntryList();
    }

    private void removeOldItem(String id) {
        Object currentItem = null;
        for (int i = 0; i < this.templatesBox.getItemCount(); ++i) {
            currentItem = this.templatesBox.getItemAt(i);
            if (currentItem == null || !(currentItem instanceof String) || !((String)currentItem).equals(id)) continue;
            this.templatesBox.removeItemAt(i);
            return;
        }
    }
}

