/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.DSAKeyPair;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS12;
import anon.crypto.RSAKeyPair;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectKeyIdentifier;
import gui.dialog.DialogContentPane;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import java.awt.Component;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import mixconfig.MixConfig;

public class CertificateGenerator
implements Runnable {
    private Validity m_validity;
    private X509DistinguishedName m_name;
    private MyX509Extensions m_extensions;
    private boolean m_bDSA;
    private int m_nKeySize = 1024;
    private PKCS12 m_cert;

    public CertificateGenerator(X509DistinguishedName a_name, MyX509Extensions a_extensions, boolean a_bDSA) {
        this.m_name = a_name;
        this.m_extensions = a_extensions;
        this.m_bDSA = a_bDSA;
        this.m_nKeySize = 1024;
    }

    public CertificateGenerator(X509DistinguishedName a_name, MyX509Extensions a_extensions, boolean a_bDSA, int keysize) {
        this.m_name = a_name;
        this.m_extensions = a_extensions;
        this.m_bDSA = a_bDSA;
        this.m_nKeySize = keysize;
    }

    public PKCS12 getCertificate() {
        return this.m_cert;
    }

    @Override
    public void run() {
        Vector extensions = new Vector();
        if (this.m_validity == null) {
            Calendar cal = Calendar.getInstance();
            this.m_validity = new Validity(cal, 1);
            LogHolder.log(7, LogType.CRYPTO, "Setting default validity: " + this.m_validity.getValidFrom() + " -- " + this.m_validity.getValidTo());
        }
        try {
            AsymmetricCryptoKeyPair keyPair = this.m_bDSA ? DSAKeyPair.getInstance(new SecureRandom(), this.m_nKeySize, 80) : RSAKeyPair.getInstance(new SecureRandom(), this.m_nKeySize, 80);
            X509SubjectKeyIdentifier ski = new X509SubjectKeyIdentifier(keyPair.getPublic());
            if (this.m_extensions != null && this.m_extensions.getSize() > 0) {
                extensions = this.m_extensions.getExtensions();
            }
            extensions.addElement(ski);
            this.m_cert = new PKCS12(this.m_name, keyPair, this.m_validity, new MyX509Extensions(extensions));
        }
        catch (Exception e) {
            if (!Thread.currentThread().isInterrupted()) {
                JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), "Threading error!", (Throwable)e);
            }
            this.m_cert = null;
        }
    }

    public static CertificateWorker createWorker(JAPDialog a_parentDialog, DialogContentPane a_previousContentPane, X509DistinguishedName a_name, MyX509Extensions a_extensions, boolean a_bDSA, int keysize) {
        CertificateWorker worker = new CertificateWorker(a_parentDialog, a_previousContentPane, new CertificateGenerator(a_name, a_extensions, a_bDSA, keysize));
        return worker;
    }

    public static class CertificateWorker
    extends WorkerContentPane {
        private CertificateGenerator m_generator;

        private CertificateWorker(JAPDialog a_parentDialog, DialogContentPane a_previousContentPane, CertificateGenerator a_generator) {
            super(a_parentDialog, "Generating key pair ..", a_previousContentPane, (Runnable)a_generator);
            this.getButtonCancel().setEnabled(false);
            this.m_generator = a_generator;
        }

        public CertificateGenerator getCertificateGenerator() {
            return this.m_generator;
        }
    }
}

