/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.DESCrypt;
import anon.crypto.MD5Crypt;
import anon.util.JAPMessages;
import gui.IPTextField;
import gui.MixConfigTextField;
import gui.TitledGridBagPanel;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.panels.MixConfigPanel;

public class MixOnCDPanel
extends MixConfigPanel
implements ActionListener {
    public static final String XMLPATH_MIXONCD = "MixOnCD";
    public static final String XMLPATH_MIXONCD_NETWORK = "MixOnCD/Network";
    public static final String XMLPATH_MIXONCD_LOGIN_PASSWORD = "MixOnCD/Login/Password";
    public static final String XMLATTRIBUTE_DHCP = "dhcp";
    public static final String XMLATTRIBUTE_USER = "user";
    public static final String XMLVALUE_NETWORKINTERFACE = "NetworkInterface";
    public static final String MSG_TITLE = MixOnCDPanel.class.getName() + "_title";
    public static final String MSG_TITLE_NETWORK = MixOnCDPanel.class.getName() + "_titleNetwork";
    public static final String MSG_TITLE_PASSWORDS = MixOnCDPanel.class.getName() + "_titlePasswords";
    public static final String MSG_CLEAR_USER = MixOnCDPanel.class.getName() + "_clearUser";
    public static final String MSG_USE_BOOTABLE_CD = MixOnCDPanel.class.getName() + "_useBootableCD";
    public static final String MSG_DHCP_AUTO_CONF = MixOnCDPanel.class.getName() + "_DHCPAutoConf";
    public static final String MSG_TITLE_DOWNLOAD_HINT = MixOnCDPanel.class.getName() + "_titleDownloadHint";
    public static final String MSG_DOWNLOAD_HINT = MixOnCDPanel.class.getName() + "_downloadHint";
    public static final String MSG_SUBNET_MASK = MixOnCDPanel.class.getName() + "_subnetMask";
    public static final String MSG_DNS_SERVERS = MixOnCDPanel.class.getName() + "_DNSServers";
    public static final String MSG_DEFAULT_GATEWAY = MixOnCDPanel.class.getName() + "_defaultGateway";
    public static final String MSG_INVALID_LOCAL_IP = MixOnCDPanel.class.getName() + "_invalidLocalIP";
    public static final String MSG_INVALID_SUBNET_MASK = MixOnCDPanel.class.getName() + "_invalidSubnetMask";
    public static final String MSG_NO_VALID_DNS = MixOnCDPanel.class.getName() + "_noValidDNS";
    public static final String MSG_INVALID_DEFAULT_GATEWAY = MixOnCDPanel.class.getName() + "_invalidDefaultGateway";
    public static final String MSG_OPTIONAL = MixOnCDPanel.class.getName() + "_optional";
    public static final String MSG_CONFIGURED_BY_MIXONCD = MixOnCDPanel.class.getName() + "_configuredByMixOnCD";
    private static final int VISIBLE_PASSWORD_LENGTH = 15;
    private JCheckBox m_cbxMixOnCD;
    private JCheckBox m_cbDHCP;
    private JTextField m_txtHostname;
    private JTextField m_txtNetworkInterface;
    private IPTextField m_txtIP;
    private IPTextField m_txtSubnetMask;
    private IPTextField m_txtDefaultGateway;
    private IPTextField[] m_txtDNSServers;
    private JLabel m_lblDNSServersHeadline;
    private JLabel[] m_lblDNSServersOptional;
    private JLabel[] m_lblDNSServersMandatory;
    private JLabel[] m_lblsPW;
    private JButton[] m_btnsRemovePW;
    private JPasswordField[] m_pwds;
    private JTextField[] m_txtHashedPasswords;
    private TitledGridBagPanel m_panelLocalNetworkSettings;
    private TitledGridBagPanel m_panelPasswords;
    private String[] m_users = new String[]{"root", "mix"};
    private String[] m_passwordHashes;

    public MixOnCDPanel() {
        super(JAPMessages.getString(MSG_TITLE));
        int i;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.insets = this.getDefaultInsets();
        constraints.fill = 2;
        this.m_cbxMixOnCD = new JCheckBox(JAPMessages.getString(MSG_USE_BOOTABLE_CD));
        this.m_cbxMixOnCD.setName("MixOnCD/Network/dhcp");
        this.m_cbxMixOnCD.addActionListener(this);
        this.m_cbxMixOnCD.addItemListener(this);
        constraints.gridwidth = 2;
        this.add((Component)this.m_cbxMixOnCD, constraints);
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        this.m_panelLocalNetworkSettings = new TitledGridBagPanel(JAPMessages.getString(MSG_TITLE_NETWORK));
        this.add((Component)this.m_panelLocalNetworkSettings, constraints);
        this.m_cbDHCP = new JCheckBox(JAPMessages.getString(MSG_DHCP_AUTO_CONF));
        this.m_cbDHCP.setName("MixOnCD/Network/dhcp");
        this.m_cbDHCP.addItemListener(this);
        this.m_panelLocalNetworkSettings.addRow(this.m_cbDHCP, (Component)null);
        this.m_txtIP = new IPTextField();
        this.m_txtIP.setName("MixOnCD/Network/IP");
        this.m_txtIP.addFocusListener(this);
        this.m_panelLocalNetworkSettings.addRow(new JLabel("IP"), this.m_txtIP);
        this.m_txtSubnetMask = new IPTextField();
        this.m_txtSubnetMask.setName("MixOnCD/Network/SubnetMask");
        this.m_txtSubnetMask.addFocusListener(this);
        this.m_panelLocalNetworkSettings.addRow(new JLabel(JAPMessages.getString(MSG_SUBNET_MASK)), this.m_txtSubnetMask);
        this.m_txtDefaultGateway = new IPTextField();
        this.m_txtDefaultGateway.setName("MixOnCD/Network/DefaultGateway");
        this.m_txtDefaultGateway.addFocusListener(this);
        this.m_panelLocalNetworkSettings.addRow(new JLabel(JAPMessages.getString(MSG_DEFAULT_GATEWAY)), this.m_txtDefaultGateway);
        this.m_txtNetworkInterface = new MixConfigTextField(4);
        this.m_txtNetworkInterface.setName("MixOnCD/Network/NetworkInterface");
        this.m_txtNetworkInterface.addFocusListener(this);
        this.m_txtNetworkInterface.setToolTipText("The network interface, for example eth0, eth1. (" + JAPMessages.getString(MSG_OPTIONAL) + ")");
        this.m_panelLocalNetworkSettings.addRow(new JLabel("Interface (" + JAPMessages.getString(MSG_OPTIONAL) + ")"), this.m_txtNetworkInterface);
        this.m_txtHostname = new MixConfigTextField(15);
        this.m_txtHostname.setName("MixOnCD/Network/Hostname");
        this.m_txtHostname.addFocusListener(this);
        this.m_panelLocalNetworkSettings.addRow(new JLabel("Hostname (" + JAPMessages.getString(MSG_OPTIONAL) + ")"), this.m_txtHostname);
        this.m_panelLocalNetworkSettings.addRow(new JLabel(), (Component)null);
        this.m_lblDNSServersHeadline = new JLabel(JAPMessages.getString(MSG_DNS_SERVERS));
        this.m_panelLocalNetworkSettings.addRow(this.m_lblDNSServersHeadline, (Component)null);
        this.m_txtDNSServers = new IPTextField[2];
        this.m_lblDNSServersOptional = new JLabel[this.m_txtDNSServers.length];
        this.m_lblDNSServersMandatory = new JLabel[this.m_txtDNSServers.length];
        for (i = 0; i < this.m_txtDNSServers.length; ++i) {
            this.m_txtDNSServers[i] = new IPTextField();
            this.m_txtDNSServers[i].setName("MixOnCD/Network/DNSServers/IP");
            this.m_txtDNSServers[i].addFocusListener(this);
            this.m_lblDNSServersOptional[i] = new JLabel("DNS " + (i + 1) + " (" + JAPMessages.getString(MSG_OPTIONAL) + ")");
            this.m_lblDNSServersMandatory[i] = new JLabel("DNS " + (i + 1));
            this.m_panelLocalNetworkSettings.addRow(this.m_lblDNSServersOptional[i], this.m_txtDNSServers[i]);
        }
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.m_panelPasswords = new TitledGridBagPanel(JAPMessages.getString(MSG_TITLE_PASSWORDS));
        this.add((Component)this.m_panelPasswords, constraints);
        this.m_pwds = new JPasswordField[this.m_users.length];
        this.m_lblsPW = new JLabel[this.m_users.length];
        this.m_btnsRemovePW = new JButton[this.m_users.length];
        this.m_passwordHashes = new String[this.m_users.length];
        this.m_txtHashedPasswords = new JTextField[this.m_users.length];
        for (i = 0; i < this.m_users.length; ++i) {
            this.m_txtHashedPasswords[i] = new JTextField(15);
            this.m_txtHashedPasswords[i].setEditable(false);
            this.m_pwds[i] = new JPasswordField(15);
            this.m_pwds[i].setName("MixOnCD/Login/Password/" + this.m_users[i]);
            this.m_pwds[i].addFocusListener(this);
            this.m_btnsRemovePW[i] = new JButton(JAPMessages.getString(MSG_CLEAR_USER));
            this.m_btnsRemovePW[i].addActionListener(this);
            this.m_btnsRemovePW[i].addFocusListener(this);
            this.m_lblsPW[i] = new JLabel(this.m_users[i]);
            this.m_panelPasswords.addRow((Component)this.m_lblsPW[i], (Component)this.m_btnsRemovePW[i], this.m_pwds[i]);
        }
        ++constraints.gridx;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)new JLabel(), constraints);
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        this.setActivated(this.getConfiguration().isMixOnCDEnabled());
        this.enableComponents();
    }

    @Override
    public Vector<String> check() {
        Vector<String> errors = new Vector<String>();
        boolean bValidDNS = false;
        if (this.m_cbxMixOnCD.isSelected() && !this.checkDHCPEnabled()) {
            if (!this.m_txtIP.isCorrect()) {
                errors.addElement(JAPMessages.getString(MSG_INVALID_LOCAL_IP));
            }
            if (!this.m_txtSubnetMask.isCorrect()) {
                errors.addElement(JAPMessages.getString(MSG_INVALID_SUBNET_MASK));
            }
            if (!this.m_txtDefaultGateway.isCorrect()) {
                errors.addElement(JAPMessages.getString(MSG_INVALID_DEFAULT_GATEWAY));
            }
            for (int i = 0; i < this.m_txtDNSServers.length; ++i) {
                if (!this.m_txtDNSServers[i].isCorrect()) continue;
                bValidDNS = true;
            }
            if (!bValidDNS) {
                errors.addElement(MSG_NO_VALID_DNS);
            }
        }
        return errors;
    }

    @Override
    protected void save(IPTextField a_ipTextField) {
        for (int i = 0; i < this.m_txtDNSServers.length; ++i) {
            if (a_ipTextField != this.m_txtDNSServers[i]) continue;
            String[] values = new String[this.m_txtDNSServers.length];
            for (int j = 0; j < values.length; ++j) {
                if (!this.m_txtDNSServers[j].isEnabled() || !this.m_txtDNSServers[j].isCorrect()) continue;
                values[j] = this.m_txtDNSServers[j].getText().trim();
            }
            this.getConfiguration().setValues(a_ipTextField.getName(), values);
            return;
        }
        super.save(a_ipTextField);
    }

    @Override
    protected void load(JCheckBox a_checkbox) {
        if (a_checkbox == this.m_cbxMixOnCD) {
            this.m_cbxMixOnCD.setSelected(this.getConfiguration().isMixOnCDEnabled());
            return;
        }
        super.load(a_checkbox);
    }

    @Override
    protected void save(JCheckBox a_checkBox) {
        if (a_checkBox == this.m_cbDHCP) {
            this.getConfiguration().setAttribute(XMLPATH_MIXONCD_NETWORK, XMLATTRIBUTE_DHCP, this.m_cbDHCP.isSelected());
        } else if (a_checkBox == this.m_cbxMixOnCD) {
            if (this.m_cbxMixOnCD.isSelected()) {
                if (!this.getConfiguration().isMixOnCDEnabled()) {
                    this.getConfiguration().setAttribute(XMLPATH_MIXONCD_NETWORK, XMLATTRIBUTE_DHCP, true);
                }
            } else {
                this.getConfiguration().removeNode(XMLPATH_MIXONCD);
            }
            this.enableComponents();
        } else {
            super.save(a_checkBox);
        }
    }

    @Override
    protected void load(IPTextField a_ipTextField) {
        for (int i = 0; i < this.m_txtDNSServers.length; ++i) {
            if (a_ipTextField != this.m_txtDNSServers[i]) continue;
            String[] values = this.getConfiguration().getValues(a_ipTextField.getName());
            for (int j = 0; j < this.m_txtDNSServers.length; ++j) {
                if (j < values.length && values[j] != null && values[j].trim().length() > 0) {
                    this.m_txtDNSServers[j].setText(values[j]);
                    continue;
                }
                this.m_txtDNSServers[j].setText(null);
            }
            return;
        }
        super.load(a_ipTextField);
    }

    @Override
    protected void enableComponents() {
        this.m_panelLocalNetworkSettings.setEnabled(this.m_cbxMixOnCD.isSelected());
        this.m_panelPasswords.setEnabled(this.m_cbxMixOnCD.isSelected());
        if (this.m_cbxMixOnCD.isSelected()) {
            int i;
            boolean bNoDHCP = !this.m_cbDHCP.isSelected();
            Component[] components = this.m_panelLocalNetworkSettings.getComponents();
            for (i = 0; i < components.length; ++i) {
                if (components[i] == this.m_cbDHCP) continue;
                components[i].setEnabled(bNoDHCP);
            }
            for (i = 0; i < this.m_txtDNSServers.length; ++i) {
                this.m_txtDNSServers[i].setEnabled(true);
                this.m_lblDNSServersOptional[i].setEnabled(true);
                this.m_lblDNSServersMandatory[i].setEnabled(true);
                this.m_lblDNSServersHeadline.setEnabled(true);
                if (bNoDHCP) {
                    this.m_lblDNSServersMandatory[i].setVisible(true);
                    this.m_lblDNSServersOptional[i].setVisible(false);
                    this.m_panelLocalNetworkSettings.replaceRow(this.m_lblDNSServersMandatory[i], this.m_txtDNSServers[i], 8 + i);
                    continue;
                }
                this.m_lblDNSServersMandatory[i].setVisible(false);
                this.m_lblDNSServersOptional[i].setVisible(true);
                this.m_panelLocalNetworkSettings.replaceRow(this.m_lblDNSServersOptional[i], this.m_txtDNSServers[i], 8 + i);
            }
            this.m_panelLocalNetworkSettings.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent a_event) {
        for (int i = 0; i < this.m_btnsRemovePW.length; ++i) {
            if (a_event.getSource() != this.m_btnsRemovePW[i]) continue;
            this.m_passwordHashes[i] = null;
            this.savePasswords();
            this.loadPasswords();
            this.m_pwds[i].requestFocus();
        }
        if (a_event.getSource() == this.m_cbxMixOnCD && this.m_cbxMixOnCD.isSelected()) {
            JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_DOWNLOAD_HINT), JAPMessages.getString(MSG_TITLE_DOWNLOAD_HINT), (JAPDialog.ILinkedInformation)new JAPDialog.LinkedHelpContext("mixsetupLiveCD_deployment"));
        }
    }

    @Override
    public String getHelpContext() {
        return MixOnCDPanel.class.getName();
    }

    @Override
    public void focusGained(FocusEvent a_event) {
        for (int index = 0; index < this.m_btnsRemovePW.length; ++index) {
            if (a_event.getSource() != this.m_btnsRemovePW[index] || this.m_btnsRemovePW[index].isEnabled()) continue;
            this.m_btnsRemovePW[index].transferFocus();
        }
        super.focusGained(a_event);
    }

    @Override
    public void focusLost(FocusEvent a_event) {
        for (int i = 0; i < this.m_users.length; ++i) {
            if (a_event.getSource() != this.m_pwds[i]) continue;
            char[] password = this.m_pwds[i].getPassword();
            if (password == null || password.length == 0) {
                this.m_passwordHashes[i] = null;
            } else {
                try {
                    this.m_passwordHashes[i] = new MD5Crypt().crypt(new String(password));
                }
                catch (NoSuchAlgorithmException a_e) {
                    this.m_passwordHashes[i] = new DESCrypt().crypt(new String(password));
                }
            }
            this.savePasswords();
            this.loadPasswords();
            return;
        }
        super.focusLost(a_event);
    }

    @Override
    public void itemStateChanged(ItemEvent a_event) {
        super.itemStateChanged(a_event);
        if (a_event.getSource() == this.m_cbxMixOnCD) {
            this.m_panelLocalNetworkSettings.setEnabled(this.m_cbxMixOnCD.isSelected());
            this.m_panelPasswords.setEnabled(this.m_cbxMixOnCD.isSelected());
            if (this.m_cbxMixOnCD.isSelected()) {
                boolean bDHCPEnabled = this.checkDHCPEnabled();
                if (this.m_cbDHCP.isSelected() != bDHCPEnabled) {
                    this.m_cbDHCP.setSelected(bDHCPEnabled);
                }
            } else {
                this.getConfiguration().removeNode(XMLPATH_MIXONCD);
            }
        } else if (a_event.getSource() == this.m_cbDHCP && !this.m_cbDHCP.isSelected()) {
            this.save(this.m_txtHostname);
            this.save(this.m_txtNetworkInterface);
            this.save(this.m_txtIP);
            this.save(this.m_txtSubnetMask);
            this.save(this.m_txtDefaultGateway);
            for (int i = 0; i < this.m_txtDNSServers.length; ++i) {
                this.save(this.m_txtDNSServers[i]);
            }
        }
    }

    @Override
    public void load() throws IOException {
        this.loadPasswords();
        super.load();
    }

    @Override
    public void save() throws IOException {
        super.save();
        this.savePasswords();
    }

    private void setActivated(boolean a_bActivate) {
        if (this.m_cbxMixOnCD.isSelected() != a_bActivate) {
            this.m_cbxMixOnCD.setSelected(a_bActivate);
        }
    }

    private boolean checkDHCPEnabled() {
        String strEnabled = this.getConfiguration().getValue("MixOnCD/Network/dhcp");
        if (strEnabled == null) {
            this.getConfiguration().setAttribute(XMLPATH_MIXONCD_NETWORK, XMLATTRIBUTE_DHCP, true);
            return true;
        }
        return Boolean.valueOf(strEnabled);
    }

    private void savePasswords() {
        this.getConfiguration().setValues(XMLPATH_MIXONCD_LOGIN_PASSWORD, this.m_passwordHashes, XMLATTRIBUTE_USER, this.m_users);
    }

    private void loadPasswords() {
        for (int i = 0; i < this.m_users.length; ++i) {
            String[] password = this.getConfiguration().getValues(XMLPATH_MIXONCD_LOGIN_PASSWORD, XMLATTRIBUTE_USER, this.m_users[i]);
            if (password.length == 0 || password[0] == null || password[0].trim().length() == 0) {
                this.m_passwordHashes[i] = null;
                this.m_btnsRemovePW[i].setEnabled(false);
                this.m_btnsRemovePW[i].invalidate();
                this.m_pwds[i].setText(null);
                this.m_pwds[i].setVisible(true);
                this.m_pwds[i].setEnabled(true);
                this.m_pwds[i].invalidate();
                this.m_txtHashedPasswords[i].setVisible(false);
                this.m_txtHashedPasswords[i].invalidate();
                this.m_panelPasswords.replaceRow((Component)this.m_lblsPW[i], (Component)this.m_btnsRemovePW[i], this.m_pwds[i], i);
            } else {
                this.m_passwordHashes[i] = password[0];
                this.m_btnsRemovePW[i].setEnabled(true);
                this.m_btnsRemovePW[i].invalidate();
                this.m_pwds[i].setVisible(false);
                this.m_pwds[i].invalidate();
                this.m_txtHashedPasswords[i] = new JTextField(password[0], 15);
                this.m_txtHashedPasswords[i].setEditable(false);
                this.m_txtHashedPasswords[i].setCaretPosition(0);
                this.m_txtHashedPasswords[i].invalidate();
                this.m_panelPasswords.replaceRow((Component)this.m_lblsPW[i], (Component)this.m_btnsRemovePW[i], this.m_txtHashedPasswords[i], i);
            }
            this.m_panelPasswords.revalidate();
        }
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

