/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.pay.xml.XMLPriceCertificate;
import anon.util.Base64;
import anon.util.ResourceLoader;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;
import mixconfig.infoservice.InfoServiceData;
import mixconfig.infoservice.InfoServiceTableModel;
import mixconfig.network.IncomingConnectionTableModel;
import mixconfig.network.OutgoingConnectionTableModel;
import mixconfig.network.ProxyTableModel;
import mixconfig.panels.CascadePanel;
import mixconfig.panels.CertPanel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class MixConfiguration {
    public static final int MIXTYPE_FIRST = 1;
    public static final int MIXTYPE_MIDDLE = 2;
    public static final int MIXTYPE_LAST = 4;
    public static final int LOG_NONE = 0;
    public static final int LOG_CONSOLE = 1;
    public static final int LOG_SYSLOG = 2;
    public static final int LOG_DIRECTORY = 3;
    public static final String XML_PATH_INFO_SERVICE = "InfoService";
    private static final String[] MIXTYPE_NAME = new String[]{"FirstMix", "MiddleMix", "LastMix"};
    private static final String VERSION = "0.61";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private Document m_configuration = null;
    private boolean m_bSavedToFile = true;
    private Vector<ChangeListener> m_changeListeners = new Vector();

    public MixConfiguration() throws XMLParseException {
        String mixConfigXML = "<?xml version=\"1.0\"?><MixConfiguration version=\"0.61\"></MixConfiguration>";
        this.m_configuration = XMLUtil.toXMLDocument(mixConfigXML);
        this.setDefaults();
        this.setSavedToFile();
    }

    public MixConfiguration(Reader r) throws XMLParseException, IOException {
        if (!this.setMixConfiguration(r)) {
            throw new IOException("Error while loading configuration!");
        }
        this.setSavedToFile();
    }

    public boolean setMixConfiguration(Reader r) throws XMLParseException, IOException {
        Document configuration = MixConfiguration.open(new InputSource(r));
        if (configuration == null) {
            return false;
        }
        this.m_configuration = configuration;
        this.initCheck();
        this.setSavedToFile();
        return true;
    }

    public static String getMixTypeAsString(int a_mixType) {
        String strMixType = "";
        if ((a_mixType & 1) > 0) {
            strMixType = strMixType + MIXTYPE_NAME[0];
        }
        if ((a_mixType & 2) > 0) {
            strMixType = strMixType + MIXTYPE_NAME[1];
        }
        if ((a_mixType & 4) > 0) {
            strMixType = strMixType + MIXTYPE_NAME[2];
        }
        return strMixType;
    }

    public Document getDocument() {
        return this.m_configuration;
    }

    public void addChangeListener(ChangeListener a_changeListener) {
        this.removeChangeListener(a_changeListener);
        this.m_changeListeners.addElement(a_changeListener);
    }

    public void removeChangeListener(ChangeListener a_changeListener) {
        this.m_changeListeners.removeElement(a_changeListener);
    }

    public void save(Writer a_writer, boolean a_bIsFile) throws IOException {
        LogHolder.log(7, LogType.MISC, "Writing configuration ..");
        XMLUtil.write(this.m_configuration, a_writer);
        if (a_bIsFile) {
            this.m_bSavedToFile = true;
        }
    }

    public boolean isSavedToFile() {
        return this.m_bSavedToFile;
    }

    public void setSavedToFile() {
        this.m_bSavedToFile = true;
    }

    public File saveToFile() throws IOException {
        JFileChooser fileChooser;
        String fileName = MixConfig.getCurrentFileName();
        Object file = fileName != null ? new File(fileName) : ((fileChooser = MixConfig.showFileDialog(MixConfig.getMainWindow(), 1, 2)) == null ? null : fileChooser.getSelectedFile());
        if (file != null) {
            String fname = ((File)file).getName();
            if (!fname.toLowerCase().endsWith(".xml")) {
                file = new File(((File)file).getParent(), fname + ".xml");
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(((File)file).getCanonicalPath()), "UTF-8");
            this.save(writer, true);
        }
        return file;
    }

    public String[] getValues(String a_xmlPath) {
        return this.getValues(a_xmlPath, null, null);
    }

    public String[] getValues(String a_xmlPath, String a_attribute, String a_attributeValue) {
        int i;
        Vector<String> values = new Vector<String>();
        String strParentNode = a_xmlPath.substring(0, a_xmlPath.lastIndexOf("/"));
        String strNodeName = a_xmlPath.substring(a_xmlPath.lastIndexOf("/") + 1, a_xmlPath.length());
        Node n = this.getNode(strParentNode, false);
        if (n == null) {
            return new String[0];
        }
        NodeList nl = n.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(strNodeName)) continue;
            String temp = XMLUtil.parseAttribute(nl.item(i), a_attribute, null);
            if (a_attribute != null && a_attribute.trim().length() != 0 && a_attributeValue != temp && (temp == null || !temp.equals(a_attributeValue)) || (temp = XMLUtil.parseValue(nl.item(i), null)) == null || temp.trim().length() <= 0) continue;
            values.addElement(temp);
        }
        String[] strValues = new String[values.size()];
        for (i = 0; i < strValues.length; ++i) {
            strValues[i] = (String)values.elementAt(i);
        }
        return strValues;
    }

    public boolean isRootPathVerificationEnabled() {
        try {
            return Boolean.valueOf(this.getValue("Certificates/MixCertificateVerification"));
        }
        catch (Exception a_e) {
            return false;
        }
    }

    public boolean isMixOnCDEnabled() {
        return this.getValue("MixOnCD/Network/dhcp") != null;
    }

    public boolean isAutoConfigurationAllowed() {
        return Boolean.valueOf(this.getValue("Network/InfoService/AllowAutoConfiguration"));
    }

    public boolean isFallbackEnabled() {
        return Boolean.valueOf(this.getValue("Network/InfoService/AllowAutoConfiguration/fallback"));
    }

    public boolean isAccountingNodePresent() {
        NodeList list = this.m_configuration.getElementsByTagName("Accounting");
        return list.getLength() > 0;
    }

    public void addAccounting() {
        LogHolder.log(7, LogType.MISC, "Adding 'Accounting' to the configuration");
        this.setValue("Accounting/SoftLimit", "1200000");
        this.setValue("Accounting/HardLimit", "500000");
        this.setValue("Accounting/PrepaidInterval", "3000000");
        this.setValue("Accounting/SettleInterval", "20");
        try {
            byte[] cert = ResourceLoader.loadResource("certificates/Payment_Instance.cer");
            this.setValue("Accounting/PaymentInstance/Certificate/X509Certificate", cert);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.PAY, "Error while loading default JPI-certificate: " + e.getMessage());
        }
        this.setValue("Accounting/PaymentInstance/Network/ListenerInterfaces/ListenerInterface/Port", "3018");
        this.setValue("Accounting/PaymentInstance/Network/ListenerInterfaces/ListenerInterface/Host", "pi.jondopay.de");
        this.setValue("Accounting/Database/Host", "localhost");
        this.setValue("Accounting/Database/Port", "5432");
        this.setValue("Accounting/Database/DBName", "aidb");
        this.setValue("Accounting/Database/Username", "aiuser");
    }

    public int getMixType() {
        int mixtype;
        try {
            mixtype = Integer.valueOf(this.getValue("General/MixType"));
            if (mixtype < 1) {
                mixtype = 1;
            } else if (mixtype > 4) {
                mixtype = 4;
            }
        }
        catch (NumberFormatException a_e) {
            mixtype = 1;
        }
        return mixtype;
    }

    public String getValue(String a_xmlPath) {
        Node n = this.getNode(a_xmlPath, false);
        if (n == null) {
            return null;
        }
        if (n instanceof Attr) {
            return ((Attr)n).getValue();
        }
        NodeList nl = n.getChildNodes();
        if (nl.getLength() == 0) {
            return null;
        }
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            if (!(n instanceof Text)) continue;
            value.append(' ');
            value.append(n.getNodeValue());
        }
        String v = value.toString().trim();
        if (a_xmlPath.indexOf("MixType") >= 0) {
            v = Integer.toString(this.getMixTypeAsInt(v));
        }
        return v;
    }

    public void setValue(String a_xmlPath, String a_value) {
        LogHolder.log(7, LogType.MISC, "Setting value: " + a_xmlPath + ":" + a_value);
        this.setValue(a_xmlPath, a_value, null, a_xmlPath.endsWith("MixID"));
    }

    public void setValue(String a_xmlPath, String a_value, Attr a_attribute, boolean urlEncode) {
        Node n = this.getNode(a_xmlPath, true);
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            n.removeChild(nl.item(i));
            --i;
        }
        if (urlEncode) {
            try {
                a_value = URLEncoder.encode(a_value, "UTF-8");
                LogHolder.log(7, LogType.MISC, "Encoded in UTF-8: " + a_value);
            }
            catch (UnsupportedEncodingException uee) {
                LogHolder.log(2, LogType.MISC, "Error while encoding URL: " + uee.getMessage());
            }
        }
        if (a_value != null && a_value.trim().length() > 0) {
            n.appendChild(this.m_configuration.createTextNode(a_value));
        }
        if (n instanceof Element && a_attribute != null) {
            ((Element)n).setAttributeNode(a_attribute);
        }
        this.fireStateChanged(a_xmlPath, a_value);
    }

    public void setValue(String a_xmlPath, boolean a_value) {
        if (a_value) {
            this.setValue(a_xmlPath, "True");
        } else {
            this.setValue(a_xmlPath, "False");
        }
    }

    public void setValue(String a_xmlPath, int a_value) {
        if (a_xmlPath.indexOf("General/MixType") >= 0) {
            this.setValue(a_xmlPath, MixConfiguration.getMixTypeAsString(a_value));
        } else {
            this.setValue(a_xmlPath, Integer.toString(a_value));
        }
    }

    public void setValue(String a_xmlPath, byte[] a_value) {
        Attr attr = this.m_configuration.createAttribute("xml:space");
        attr.setNodeValue("preserve");
        String s = null;
        if (a_value != null) {
            s = Base64.encode(a_value, true);
        }
        this.setValue(a_xmlPath, s, attr, false);
    }

    public void setValue(String a_xmlPath, CascadePanel.MixListTableModel a_mixListModel) {
        Node f = a_mixListModel.toXmlElement(this.m_configuration);
        Node n = this.getNode(a_xmlPath, true);
        while (n.hasChildNodes()) {
            n.removeChild(n.getFirstChild());
        }
        n.insertBefore(f, null);
        this.fireStateChanged(a_xmlPath + "/" + f.getNodeName(), a_mixListModel);
    }

    public void setValues(String a_xmlPath, String[] a_values) {
        this.setValues(a_xmlPath, a_values, null, null);
    }

    public void setValues(String a_xmlPath, String[] a_values, String a_attribute, String[] a_attrValues) {
        int i;
        String strParentNode = a_xmlPath.substring(0, a_xmlPath.lastIndexOf("/"));
        String strNodeName = a_xmlPath.substring(a_xmlPath.lastIndexOf("/") + 1, a_xmlPath.length());
        Node n = this.getNode(strParentNode, true);
        NodeList nl = n.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            Node o = nl.item(i);
            if (!o.getNodeName().equals(strNodeName)) continue;
            n.removeChild(o);
            --i;
        }
        for (i = 0; i < a_values.length; ++i) {
            if (a_values[i] == null || a_values[i].trim().length() == 0) continue;
            Element valueNode = this.m_configuration.createElement(strNodeName);
            XMLUtil.setValue((Node)valueNode, a_values[i]);
            if (a_attribute != null && a_attrValues != null && a_attrValues.length > i) {
                XMLUtil.setAttribute(valueNode, a_attribute, a_attrValues[i]);
            }
            n.appendChild(valueNode);
        }
        this.fireStateChanged(a_xmlPath, a_values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String a_xmlPath, InfoServiceTableModel a_infoServiceModel) {
        Element elem = a_infoServiceModel.createAsElement(this.m_configuration);
        Node n = this.getNode(a_xmlPath, true);
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node o = nl.item(i);
            if (!o.getNodeName().equals(elem.getNodeName())) continue;
            n.removeChild(o);
            --i;
        }
        Database.getInstance(InfoServiceDBEntry.class).removeAll();
        InfoServiceTableModel infoServiceTableModel = a_infoServiceModel;
        synchronized (infoServiceTableModel) {
            for (int i = 0; i < a_infoServiceModel.getRowCount(); ++i) {
                Database.getInstance(InfoServiceDBEntry.class).update(new InfoServiceDBEntry(a_infoServiceModel.getData(i).getListenerInterfaces()));
            }
            n.insertBefore(elem, n.getFirstChild());
        }
        this.fireStateChanged(a_xmlPath + "/" + elem.getNodeName(), a_infoServiceModel);
    }

    public void setValue(String a_xmlPath, IncomingConnectionTableModel a_inConnModel) {
        Element elem = a_inConnModel.createAsElement(this.m_configuration);
        Node n = this.getNode(a_xmlPath, true);
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node o = nl.item(i);
            if (!o.getNodeName().equals(elem.getNodeName())) continue;
            n.removeChild(o);
            --i;
        }
        n.insertBefore(elem, null);
        this.fireStateChanged(a_xmlPath + "/" + elem.getNodeName(), a_inConnModel);
    }

    public void setValue(String a_xmlPath, OutgoingConnectionTableModel a_outConnModel) {
        Element elementNextMix = a_outConnModel.createMixAsElement(this.m_configuration);
        this.removeNode("Network/NextMix");
        this.removeNode("Network/Proxies");
        Node parent = this.getNode(a_xmlPath, true);
        NodeList nl = parent.getChildNodes();
        if (elementNextMix != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!n.getNodeName().equals(elementNextMix.getNodeName())) continue;
                parent.removeChild(n);
                --i;
            }
            parent.insertBefore(elementNextMix, null);
            this.fireStateChanged(a_xmlPath + "/" + elementNextMix.getNodeName(), a_outConnModel);
        }
    }

    public void setValue(String a_xmlPath, ProxyTableModel a_proxyTableModel) {
        Element elementProxies = a_proxyTableModel.createProxiesAsElement(this.m_configuration);
        this.removeNode("Network/NextMix");
        this.removeNode("Network/Proxies");
        Node parent = this.getNode(a_xmlPath, true);
        NodeList nl = parent.getChildNodes();
        if (elementProxies != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!n.getNodeName().equals(elementProxies.getNodeName())) continue;
                parent.removeChild(n);
                --i;
            }
            parent.insertBefore(elementProxies, null);
            this.fireStateChanged(a_xmlPath + "/" + elementProxies.getNodeName(), a_proxyTableModel);
        }
    }

    public void setValue(String a_xmlPath, XMLPriceCertificate a_cert) {
        this.removeNode("Accounting/PriceCertificate");
        Element priceCertElement = a_cert.toXmlElement(this.m_configuration);
        Node accountingNode = this.getNode("Accounting", true);
        accountingNode.appendChild(priceCertElement);
        this.fireStateChanged(a_xmlPath, a_cert);
    }

    public void setValue(String a_xmlPath, Element a_elem) {
        this.removeNode(a_xmlPath + "/" + a_elem.getNodeName());
        Node n = this.getNode(a_xmlPath + "/" + a_elem.getNodeName(), true);
        for (int i = 0; i < a_elem.getChildNodes().getLength(); ++i) {
            n.appendChild(a_elem.getChildNodes().item(i));
        }
        this.fireStateChanged(a_xmlPath + "/" + a_elem.getNodeName(), a_elem);
    }

    public void setAttribute(String a_xmlPath, String a_attribute, boolean a_Boolean) {
        String s = new Boolean(a_Boolean).toString();
        s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        this.setAttribute(a_xmlPath, a_attribute, s);
    }

    public void setAttribute(String a_xmlPath, String a_attribute, String a_value) {
        LogHolder.log(7, LogType.MISC, "Setting attribute: " + a_attribute + "@" + a_xmlPath + ":" + a_value);
        Attr attr = this.getDocument().createAttribute(a_attribute);
        attr.setNodeValue(a_value);
        Node n = this.getNode(a_xmlPath, true);
        if (n instanceof Element) {
            ((Element)n).setAttributeNode(attr);
            this.fireStateChanged(a_xmlPath, a_value);
        }
    }

    public boolean hasAttribute(String a_xmlPath, String a_attribute) {
        NamedNodeMap attributes;
        Node attributeNode;
        boolean ret = false;
        Node targetNode = this.getNode(a_xmlPath, false);
        if (targetNode != null && (attributeNode = (attributes = targetNode.getAttributes()).getNamedItem(a_attribute)) != null) {
            ret = true;
        }
        LogHolder.log(7, LogType.MISC, "Checking for attribute " + a_attribute + "@" + a_xmlPath + ": " + ret);
        return ret;
    }

    public String getAttributeValue(String a_xmlPath, String a_attribute) {
        NamedNodeMap attributes;
        Node attributeNode;
        String ret = null;
        Node targetNode = this.getNode(a_xmlPath, false);
        if (targetNode != null && (attributeNode = (attributes = targetNode.getAttributes()).getNamedItem(a_attribute)) != null) {
            ret = attributeNode.getNodeValue();
        }
        LogHolder.log(7, LogType.MISC, "Getting value of " + a_attribute + "@" + a_xmlPath + ": " + ret);
        return ret;
    }

    public boolean hasAttributes(String a_xmlPath) {
        Node n = this.getNode(a_xmlPath, false);
        return n != null && n.getAttributes() != null && n.getAttributes().getLength() > 0;
    }

    public void removeNode(String a_xmlPath) {
        Node n = this.getNode(a_xmlPath, false);
        if (n != null) {
            LogHolder.log(7, LogType.MISC, "Removing node: " + a_xmlPath);
            n.getParentNode().removeChild(n);
            this.fireStateChanged(a_xmlPath, null);
        }
    }

    public void removeAttribute(String a_xmlPath, String a_attribute) {
        LogHolder.log(7, LogType.MISC, "Removing attribute: " + a_attribute + "@" + a_xmlPath);
        Node n = this.getNode(a_xmlPath, false);
        if (n != null && n instanceof Element) {
            ((Element)n).removeAttribute(a_attribute);
            this.fireStateChanged(a_xmlPath, null);
        }
    }

    protected void fireStateChanged(String a_name, Object a_value) {
        this.m_bSavedToFile = false;
        if (a_name.indexOf("MixType") >= 0) {
            a_value = Integer.toString(this.getMixTypeAsInt(a_value.toString()));
        }
        ConfigurationEvent c = new ConfigurationEvent(this, a_name, a_value);
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            this.m_changeListeners.elementAt(i).stateChanged(c);
        }
    }

    private void setDefaults() {
        this.setValue("General/MixType", "FirstMix");
        this.setAttribute("General/MixName", "forCascade", "Mix");
        this.setAttribute("General/MixType", "payment", true);
        this.setValue("Certificates/MixCertificateVerification", true);
        CertPanel.resetRootCertificates(this);
        InfoServiceTableModel dummyTableModel = new InfoServiceTableModel();
        dummyTableModel.addData(new InfoServiceData(XML_PATH_INFO_SERVICE, "infoservice.inf.tu-dresden.de", 80));
        dummyTableModel.addData(new InfoServiceData(XML_PATH_INFO_SERVICE, "72.55.137.241", 80));
        dummyTableModel.addData(new InfoServiceData(XML_PATH_INFO_SERVICE, "is.beneficium.de", 80));
        dummyTableModel.addData(new InfoServiceData(XML_PATH_INFO_SERVICE, "78.129.146.44", 80));
        this.setValue("Network", dummyTableModel);
        this.setValue("Network/ListenerInterfaces/ListenerInterface/NetworkProtocol", "RAW/TCP");
        this.setValue("Network/ListenerInterfaces/ListenerInterface/Port", "6544");
        this.setValue("Network/ServerMonitoring/Port", "8080");
        this.setValue("Network/ServerMonitoring/Host", "0.0.0.0");
        this.addAccounting();
    }

    private void initCheck() {
        LogHolder.log(7, LogType.MISC, "Performing compatibility check");
        if (!this.hasAttribute("General/MixType", "payment")) {
            if (this.isAccountingNodePresent()) {
                this.setAttribute("General/MixType", "payment", true);
            } else {
                this.setAttribute("General/MixType", "payment", false);
            }
        }
    }

    public boolean performReloadCheck() {
        LogHolder.log(7, LogType.MISC, "Performing 'save-and-reload' check ..");
        boolean ret = false;
        StringWriter sw = new StringWriter();
        try {
            LogHolder.log(7, LogType.MISC, "Writing document to string");
            XMLUtil.write(this.m_configuration, sw);
        }
        catch (IOException e) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), e.getMessage());
        }
        String xmlString = sw.toString();
        StringReader sr = new StringReader(xmlString);
        try {
            LogHolder.log(7, LogType.MISC, "Reading document from string");
            Document doc = XMLUtil.readXMLDocument(sr);
            if (doc != null) {
                ret = true;
                doc = null;
            }
        }
        catch (XMLParseException e) {
            LogHolder.log(4, LogType.MISC, e.getMessage());
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), "This configuration contains invalid characters! Once saved it cannot be loaded again by the mix software or this tool. Please re-check this configuration!!");
        }
        catch (IOException ioe) {
            LogHolder.log(4, LogType.MISC, ioe.getMessage());
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), ioe.getMessage());
        }
        if (ret) {
            LogHolder.log(7, LogType.MISC, "Reload-check successful :-)");
        } else {
            LogHolder.log(3, LogType.MISC, "Reload-check NOT successful :-(");
        }
        return ret;
    }

    private int getMixTypeAsInt(String a_s) {
        int mixType = 0;
        if (a_s != null) {
            for (int i = 0; i < MIXTYPE_NAME.length; ++i) {
                if (a_s.indexOf(MIXTYPE_NAME[i]) < 0) continue;
                mixType = (int)((double)mixType + Math.pow(2.0, i));
            }
        }
        return mixType;
    }

    private Node getAttributeNode(Node n, String a_namedItem) {
        if (n instanceof Element) {
            Node m = n.getAttributes().getNamedItem(a_namedItem);
            return m;
        }
        return null;
    }

    private Node getNode(String a_xmlPath, boolean create) {
        Node n;
        String headPart;
        String tailPart = a_xmlPath;
        Node p = this.m_configuration.getDocumentElement();
        NodeList nl = p.getChildNodes();
        do {
            n = null;
            headPart = tailPart;
            int i = tailPart.indexOf(47);
            if (i > 0) {
                headPart = tailPart.substring(0, i);
                tailPart = tailPart.substring(i + 1);
            }
            for (int j = 0; j < nl.getLength() && !(n = nl.item(j)).getNodeName().equals(headPart); ++j) {
                if ((n = this.getAttributeNode(n, headPart)) == null) continue;
                return n;
            }
            if (n == null) {
                if (!create) {
                    return null;
                }
                n = this.m_configuration.createElement(headPart);
                p.appendChild(n);
            } else {
                Node m = this.getAttributeNode(n, tailPart);
                if (m != null) {
                    return m;
                }
            }
            nl = n.getChildNodes();
            p = n;
        } while (headPart != tailPart);
        return n;
    }

    private static Document open(InputSource r) throws XMLParseException, IOException {
        Node root;
        Document doc;
        block4: {
            LogHolder.log(7, LogType.MISC, "Reading configuration ..");
            doc = XMLUtil.readXMLDocument(r);
            root = XMLUtil.assertNodeName(doc, "MixConfiguration");
            String ver = XMLUtil.parseAttribute(root, XML_ATTRIBUTE_VERSION, null);
            if (!(ver != null && ver.length() != 0 || JAPDialog.showYesNoDialog((Component)MixConfig.getMainWindow(), "This file does not contain any version information,\nthus information might be lost.\nDo you want to continue?", "XML file version unknown"))) {
                return null;
            }
            try {
                if (Float.valueOf(ver).floatValue() > Float.valueOf(VERSION).floatValue() && !JAPDialog.showYesNoDialog((Component)MixConfig.getMainWindow(), "The version of this file is newer than this utility,\nthus information may not be read properly.\nDo you want to continue?", "XML file version mismatch")) {
                    return null;
                }
            }
            catch (NumberFormatException a_e) {
                if (JAPDialog.showYesNoDialog((Component)MixConfig.getMainWindow(), "This file contains an invalid version information,\nthus information may not be read properly.\nDo you want to continue?", "Invalid XML file version")) break block4;
                return null;
            }
        }
        XMLUtil.setAttribute((Element)root, XML_ATTRIBUTE_VERSION, VERSION);
        return doc;
    }
}

