/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.pay.PayAccountsFile;
import anon.util.JAPMessages;
import gui.GUIUtils;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JapCouponField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final int NR_OF_CHARACTERS = 4;
    private static final char[] ACCEPTED_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private JapCouponField m_nextCouponField;
    private boolean m_bFirstField = false;
    private static final String MSG_INSERT_FROM_CLIP = (class$gui$JapCouponField == null ? (class$gui$JapCouponField = JapCouponField.class$("gui.JapCouponField")) : class$gui$JapCouponField).getName() + "_insertFromClip";
    static /* synthetic */ Class class$gui$JapCouponField;

    public JapCouponField(boolean a_bFirstField) {
        super(4);
        this.m_bFirstField = a_bFirstField;
        final JPopupMenu m_popup = new JPopupMenu();
        JMenuItem itemInsertCoupon = new JMenuItem(JAPMessages.getString(MSG_INSERT_FROM_CLIP));
        MouseAdapter popupListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent a_event) {
                if (SwingUtilities.isRightMouseButton(a_event) || a_event.isPopupTrigger()) {
                    m_popup.show(JapCouponField.this, a_event.getX(), a_event.getY());
                }
            }
        };
        this.addMouseListener(popupListener);
        itemInsertCoupon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                Clipboard clip = GUIUtils.getSystemClipboard();
                Transferable data = clip.getContents(this);
                if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        JapCouponField.this.setText((String)data.getTransferData(DataFlavor.stringFlavor));
                    }
                    catch (Exception a_e) {
                        // empty catch block
                    }
                }
            }
        });
        m_popup.add(itemInsertCoupon);
    }

    public void setNextCouponField(JapCouponField a_nextCouponField) {
        this.m_nextCouponField = a_nextCouponField;
    }

    protected final Document createDefaultModel() {
        return new CouponDocument();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class CouponDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private CouponDocument() {
        }

        public void insertString(int offset, String string, AttributeSet attributeSet) throws BadLocationException {
            string = string.toUpperCase();
            char[] originalString = string.toCharArray();
            char[] modifiedString = new char[originalString.length];
            int nrOfOkayChars = 0;
            for (int i = 0; i < originalString.length; ++i) {
                if ((!JapCouponField.this.m_bFirstField || offset != 0 || i != 0 || !PayAccountsFile.isNewUserLetter(originalString[i]) && !PayAccountsFile.isPromotionLetter(originalString[i])) && !this.isCharacterAccepted(originalString[i])) continue;
                modifiedString[nrOfOkayChars] = originalString[i];
                ++nrOfOkayChars;
            }
            string = new String(modifiedString, 0, nrOfOkayChars);
            if (string.length() + this.getLength() > 4) {
                if (4 <= string.length()) {
                    if (JapCouponField.this.m_nextCouponField != null && 4 < string.length()) {
                        JapCouponField.this.m_nextCouponField.setText(string.substring(4, string.length()));
                    }
                    string = string.substring(0, 4);
                    super.insertString(0, string, attributeSet);
                } else if (offset + string.length() <= 4) {
                    super.writeLock();
                    super.remove(offset, string.length());
                    super.insertString(offset, string, attributeSet);
                    super.writeUnlock();
                } else if (offset < 4) {
                    super.writeLock();
                    super.remove(offset, 4 - offset);
                    super.insertString(offset, string.substring(0, 4 - offset), attributeSet);
                    super.writeUnlock();
                }
            } else {
                super.insertString(offset, string, attributeSet);
            }
            if (this.getLength() >= 4) {
                if (this.getLength() > 4) {
                    super.remove(4, this.getLength() - 4);
                }
                if (JapCouponField.this.getCaretPosition() >= 4) {
                    JapCouponField.this.setCaretPosition(0);
                    JapCouponField.this.transferFocus();
                }
            }
        }

        private boolean isCharacterAccepted(char charToCheck) {
            for (int i = 0; i < ACCEPTED_CHARS.length; ++i) {
                if (charToCheck != ACCEPTED_CHARS[i]) continue;
                return true;
            }
            return false;
        }
    }
}

