/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.ResourceLoader;
import anon.util.Util;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import logging.LogHolder;
import logging.LogType;

public final class JAPMessages {
    private static ResourceBundle ms_resourceBundle = null;
    private static ResourceBundle ms_defaultResourceBundle = null;
    private static Locale ms_locale;
    private static final Locale SYSTEM_LOCALE;
    private static Hashtable ms_cachedMessages;
    static /* synthetic */ Class class$java$util$PropertyResourceBundle;

    private JAPMessages() {
    }

    public static Locale getSystemLocale() {
        return SYSTEM_LOCALE;
    }

    public static boolean init(String a_resourceBundleFilename) {
        return JAPMessages.init(Locale.getDefault(), a_resourceBundleFilename);
    }

    private static String getBundleLocalisedFilename(String a_resourceBundleFilename, Locale a_locale) {
        String strLocale = "_";
        if (a_resourceBundleFilename == null) {
            return null;
        }
        if (a_locale == null) {
            a_locale = Locale.getDefault();
        }
        strLocale = a_locale == null || a_locale.getLanguage().trim().length() == 0 ? strLocale + "en" : strLocale + a_locale.getLanguage();
        strLocale = strLocale + ".properties";
        return a_resourceBundleFilename + strLocale;
    }

    public static synchronized boolean init(Locale locale, String a_resourceBundleFilename) {
        Exception ex = null;
        if (ms_locale != null) {
            Locale.setDefault(Locale.ENGLISH);
        }
        try {
            if (ms_defaultResourceBundle == null) {
                ms_defaultResourceBundle = ResourceBundle.getBundle(a_resourceBundleFilename, Locale.ENGLISH);
            }
        }
        catch (Exception a_e) {
            LogHolder.log(0, LogType.GUI, a_e);
            return false;
        }
        ms_resourceBundle = ms_defaultResourceBundle;
        InputStream stream = null;
        try {
            stream = ResourceLoader.loadResourceAsStream(JAPMessages.getBundleLocalisedFilename(a_resourceBundleFilename, locale), true);
            if (stream != null) {
                ms_resourceBundle = new PropertyResourceBundle(stream);
            }
        }
        catch (Exception a_e) {
            ex = a_e;
        }
        Util.closeStream(stream);
        if (stream == null) {
            try {
                ms_resourceBundle = ResourceBundle.getBundle(a_resourceBundleFilename, locale);
            }
            catch (Exception a_e2) {
                try {
                    if (locale != null && locale.equals(Locale.getDefault())) {
                        if (ex != null) {
                            throw ex;
                        }
                        throw a_e2;
                    }
                    locale = Locale.getDefault();
                    ms_resourceBundle = ResourceBundle.getBundle(a_resourceBundleFilename, locale);
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, e);
                }
            }
        }
        ms_cachedMessages = new Hashtable();
        ms_locale = locale;
        return true;
    }

    public static boolean isInitialised() {
        return ms_locale != null;
    }

    public static Locale getLocale() {
        if (ms_locale == null) {
            return Locale.getDefault();
        }
        return ms_locale;
    }

    public static void setLocale(Locale a_locale) {
        if (a_locale != null) {
            ms_locale = a_locale;
        }
    }

    public static String getString(String a_key) {
        String string;
        block8: {
            if (ms_cachedMessages == null) {
                return a_key;
            }
            string = (String)ms_cachedMessages.get(a_key);
            if (string != null) {
                return string;
            }
            try {
                string = ms_resourceBundle.getString(a_key);
                if (string == null || string.trim().length() == 0) {
                    throw new MissingResourceException("Resource is empty", (class$java$util$PropertyResourceBundle == null ? (class$java$util$PropertyResourceBundle = JAPMessages.class$("java.util.PropertyResourceBundle")) : class$java$util$PropertyResourceBundle).getName(), a_key);
                }
            }
            catch (Exception e) {
                try {
                    if (ms_resourceBundle != ms_defaultResourceBundle) {
                        string = ms_defaultResourceBundle.getString(a_key);
                        LogHolder.log(7, LogType.GUI, "Could not load message string '" + a_key + "' for the locale '" + ms_locale.getLanguage() + "'. Using default resource bundle.", 1);
                    }
                }
                catch (Exception a_e) {
                    string = null;
                }
                if (string != null && string.trim().length() != 0) break block8;
                LogHolder.log(7, LogType.GUI, "Could not load messsage string: " + a_key, 1);
                string = a_key;
            }
        }
        ms_cachedMessages.put(a_key, string);
        return string;
    }

    public static String getString(String a_key, Object[] a_arguments) {
        return MessageFormat.format(JAPMessages.getString(a_key), a_arguments);
    }

    public static String getString(String a_key, Object a_argument) {
        return JAPMessages.getString(a_key, Util.toArray(a_argument));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SYSTEM_LOCALE = Locale.getDefault();
    }
}

