/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractPublicKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureVerificationAlgorithm;
import anon.crypto.MyRSASignature;
import anon.util.Base64;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MyRSAPublicKey
extends AbstractPublicKey
implements IMyPublicKey {
    private static final long serialVersionUID = 1L;
    private MyRSASignature m_algorithm = new MyRSASignature();
    private BigInteger m_n;
    private BigInteger m_e;
    private long m_hashValue = 0L;
    private int m_keyLength = 0;

    public MyRSAPublicKey(BigInteger modulus, BigInteger exponent) {
        this.m_n = modulus;
        this.m_e = exponent;
    }

    public MyRSAPublicKey(CipherParameters cipherparams) throws Exception {
        RSAKeyParameters p = (RSAKeyParameters)cipherparams;
        this.m_n = p.getModulus();
        this.m_e = p.getExponent();
    }

    public MyRSAPublicKey(RSAPublicKeyStructure en) throws IllegalArgumentException {
        try {
            this.m_n = en.getModulus();
            this.m_e = en.getPublicExponent();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid info structure in RSA public key");
        }
    }

    public MyRSAPublicKey(SubjectPublicKeyInfo info) throws IllegalArgumentException {
        try {
            RSAPublicKeyStructure en = RSAPublicKeyStructure.getInstance(info.getPublicKey());
            this.m_n = en.getModulus();
            this.m_e = en.getPublicExponent();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid info structure in RSA public key");
        }
    }

    public static MyRSAPublicKey getInstance(byte[] encoded) {
        try {
            return new MyRSAPublicKey(new RSAPublicKeyStructure((ASN1Sequence)new ASN1InputStream(new ByteArrayInputStream(encoded)).readObject()));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ISignatureVerificationAlgorithm getSignatureAlgorithm() {
        try {
            this.m_algorithm.initVerify(this);
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return this.m_algorithm;
    }

    public BigInteger getModulus() {
        return this.m_n;
    }

    public BigInteger getPublicExponent() {
        return this.m_e;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public int getKeyLength() {
        return this.getModulus().bitLength();
    }

    public SubjectPublicKeyInfo getAsSubjectPublicKeyInfo() {
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"));
        try {
            return new SubjectPublicKeyInfo(algID, new RSAPublicKeyStructure(this.m_n, this.m_e).toASN1Primitive());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public CipherParameters getParams() {
        return new RSAKeyParameters(false, this.m_n, this.m_e);
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("RSAKeyValue");
        Element elemModulus = a_doc.createElement("Modulus");
        elemRoot.appendChild(elemModulus);
        byte[] b = this.m_n.toByteArray();
        XMLUtil.setValue((Node)elemModulus, Base64.encodeBytes(b));
        Element elemExponent = a_doc.createElement("Exponent");
        elemRoot.appendChild(elemExponent);
        b = this.m_e.toByteArray();
        XMLUtil.setValue((Node)elemExponent, Base64.encodeBytes(b));
        return elemRoot;
    }

    public boolean equals(Object a_publicKey) {
        if (a_publicKey == null) {
            return false;
        }
        if (!(a_publicKey instanceof PublicKey)) {
            return false;
        }
        if (!(a_publicKey instanceof MyRSAPublicKey)) {
            return false;
        }
        MyRSAPublicKey r = (MyRSAPublicKey)a_publicKey;
        return r.getModulus().equals(this.m_n) && r.getPublicExponent().equals(this.m_e);
    }

    public int hashCode() {
        if (this.m_hashValue == 0L) {
            this.m_hashValue = this.m_n.longValue() + this.m_e.longValue();
        }
        return (int)this.m_hashValue;
    }

    public String toString() {
        String e = this.m_e == null ? "(not set)" : this.m_e.toString();
        String n = this.m_n == null ? "(not set)" : this.m_n.toString();
        return "e=" + e + " ; n=" + n;
    }
}

