/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.ITrustModel;
import anon.crypto.SignatureVerifier;
import anon.error.ServiceSignatureException;
import anon.error.ServiceUnreachableException;
import anon.error.TrustException;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.util.JAPMessages;
import java.util.Date;

public class BasicTrustModel
implements ITrustModel {
    public final void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
        this.checkTrust(a_cascade, false);
    }

    public void checkTrust(MixCascade a_cascade, boolean a_bCheckUserDefined) throws TrustException, ServiceSignatureException {
        int i;
        int countUnverified = 0;
        ServiceSignatureException exception = null;
        if (a_cascade == null || SignatureVerifier.getInstance().isCheckSignatures() && !a_cascade.isUserDefined() && !a_cascade.isVerified()) {
            throw new ServiceSignatureException(a_cascade, JAPMessages.getString("invalidSignature"), 0);
        }
        if (SignatureVerifier.getInstance().isCheckSignatures()) {
            exception = new ServiceSignatureException(a_cascade, JAPMessages.getString("invalidSignature"), 0);
            if (a_cascade.isValid() && a_cascade.isVerified()) {
                exception = null;
            } else {
                for (i = 0; i < a_cascade.getNumberOfMixes(); ++i) {
                    if (a_cascade.getMixInfo(i) == null || a_cascade.getMixInfo(i).getCertPath() == null || !a_cascade.getMixInfo(i).getCertPath().isValid(new Date()) || i != 0 && i != a_cascade.getNumberOfMixes() - 1) continue;
                    exception = null;
                    break;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (a_cascade.areListenerInterfacesBlocked()) {
            throw new ServiceUnreachableException(a_cascade);
        }
        for (i = 0; i < a_cascade.getNumberOfMixes(); ++i) {
            MixInfo info = a_cascade.getMixInfo(i);
            if ((info != null || !SignatureVerifier.getInstance().isCheckSignatures()) && (info == null || !SignatureVerifier.getInstance().isCheckSignatures() || info.isVerified())) continue;
            ++countUnverified;
            if (exception != null) continue;
            exception = new ServiceSignatureException(a_cascade, JAPMessages.getString("invalidSignature") + " (Mix " + (i + 1) + ")", i);
        }
        if (exception != null) {
            if (countUnverified > 1 || a_cascade.getNumberOfOperatorsShown() == 1 || a_cascade.getNumberOfMixes() <= 1) {
                exception = new ServiceSignatureException(a_cascade, JAPMessages.getString("invalidSignature"));
            }
            throw exception;
        }
    }

    public final boolean isTrusted(MixCascade a_cascade) {
        if (a_cascade == null) {
            return false;
        }
        if (a_cascade != null && a_cascade.isShownAsTrusted()) {
            return true;
        }
        try {
            this.checkTrust(a_cascade);
            return true;
        }
        catch (TrustException a_e) {
            return false;
        }
        catch (ServiceSignatureException a_e) {
            return false;
        }
    }

    public final boolean isTrusted(MixCascade a_cascade, StringBuffer buff) {
        if (a_cascade != null && a_cascade.isShownAsTrusted()) {
            return true;
        }
        try {
            this.checkTrust(a_cascade);
            return true;
        }
        catch (TrustException a_e) {
            buff.append(a_e.getMessage());
            return false;
        }
        catch (ServiceSignatureException a_e) {
            buff.append(a_e.getMessage());
            return false;
        }
    }
}

