/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.io.IOException;
import org.apache.oro.text.awk.AwkMatchResult;
import org.apache.oro.text.awk.AwkPattern;
import org.apache.oro.text.awk.AwkStreamInput;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;

public final class AwkMatcher
implements PatternMatcher {
    private int __lastMatchedBufferOffset;
    private AwkMatchResult __lastMatchResult = null;
    private AwkStreamInput __scratchBuffer;
    private AwkStreamInput __streamSearchBuffer;
    private AwkPattern __awkPattern;
    private int[] __offsets = new int[2];
    private int __beginOffset;

    public AwkMatcher() {
        this.__scratchBuffer = new AwkStreamInput();
        this.__scratchBuffer._endOfStreamReached = true;
    }

    public boolean matchesPrefix(char[] input, Pattern pattern, int offset) {
        int result = -1;
        this.__awkPattern = (AwkPattern)pattern;
        this.__scratchBuffer._buffer = input;
        this.__scratchBuffer._bufferSize = input.length;
        this.__beginOffset = 0;
        this.__scratchBuffer._bufferOffset = 0;
        this.__scratchBuffer._endOfStreamReached = true;
        this.__streamSearchBuffer = this.__scratchBuffer;
        this.__offsets[0] = offset;
        try {
            result = this.__streamMatchPrefix();
        }
        catch (IOException e) {
            result = -1;
        }
        if (result < 0) {
            this.__lastMatchResult = null;
            return false;
        }
        this.__lastMatchResult = new AwkMatchResult(new String(input, 0, result), offset);
        return true;
    }

    public boolean matchesPrefix(char[] input, Pattern pattern) {
        return this.matchesPrefix(input, pattern, 0);
    }

    public boolean matchesPrefix(String input, Pattern pattern) {
        return this.matchesPrefix(input.toCharArray(), pattern, 0);
    }

    public boolean matchesPrefix(PatternMatcherInput input, Pattern pattern) {
        int result = -1;
        this.__awkPattern = (AwkPattern)pattern;
        this.__scratchBuffer._buffer = input.getBuffer();
        this.__scratchBuffer._bufferOffset = this.__beginOffset = input.getBeginOffset();
        this.__offsets[0] = input.getCurrentOffset();
        this.__scratchBuffer._bufferSize = input.length();
        this.__scratchBuffer._endOfStreamReached = true;
        this.__streamSearchBuffer = this.__scratchBuffer;
        try {
            result = this.__streamMatchPrefix();
        }
        catch (IOException e) {
            result = -1;
        }
        if (result < 0) {
            this.__lastMatchResult = null;
            return false;
        }
        this.__lastMatchResult = new AwkMatchResult(new String(this.__scratchBuffer._buffer, this.__offsets[0], result), this.__offsets[0]);
        return true;
    }

    public boolean matches(char[] input, Pattern pattern) {
        int result = -1;
        this.__awkPattern = (AwkPattern)pattern;
        this.__scratchBuffer._buffer = input;
        this.__scratchBuffer._bufferSize = input.length;
        this.__beginOffset = 0;
        this.__scratchBuffer._bufferOffset = 0;
        this.__scratchBuffer._endOfStreamReached = true;
        this.__streamSearchBuffer = this.__scratchBuffer;
        this.__offsets[0] = 0;
        try {
            result = this.__streamMatchPrefix();
        }
        catch (IOException e) {
            result = -1;
        }
        if (result != input.length) {
            this.__lastMatchResult = null;
            return false;
        }
        this.__lastMatchResult = new AwkMatchResult(new String(input, 0, result), 0);
        return true;
    }

    public boolean matches(String input, Pattern pattern) {
        return this.matches(input.toCharArray(), pattern);
    }

    public boolean matches(PatternMatcherInput input, Pattern pattern) {
        int result = -1;
        this.__awkPattern = (AwkPattern)pattern;
        this.__scratchBuffer._buffer = input.getBuffer();
        this.__scratchBuffer._bufferSize = input.length();
        this.__scratchBuffer._bufferOffset = this.__beginOffset = input.getBeginOffset();
        this.__offsets[0] = input.getBeginOffset();
        this.__scratchBuffer._endOfStreamReached = true;
        this.__streamSearchBuffer = this.__scratchBuffer;
        try {
            result = this.__streamMatchPrefix();
        }
        catch (IOException e) {
            result = -1;
        }
        if (result != this.__scratchBuffer._bufferSize) {
            this.__lastMatchResult = null;
            return false;
        }
        this.__lastMatchResult = new AwkMatchResult(new String(this.__scratchBuffer._buffer, this.__offsets[0], this.__scratchBuffer._bufferSize), this.__offsets[0]);
        return true;
    }

    public boolean contains(char[] input, Pattern pattern) {
        this.__awkPattern = (AwkPattern)pattern;
        if (this.__awkPattern._hasBeginAnchor && !this.__awkPattern._fastMap[input[0]]) {
            this.__lastMatchResult = null;
            return false;
        }
        this.__scratchBuffer._buffer = input;
        this.__scratchBuffer._bufferSize = input.length;
        this.__beginOffset = 0;
        this.__scratchBuffer._bufferOffset = 0;
        this.__scratchBuffer._endOfStreamReached = true;
        this.__streamSearchBuffer = this.__scratchBuffer;
        this.__lastMatchedBufferOffset = 0;
        try {
            this._search();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.__lastMatchResult != null;
    }

    public boolean contains(String input, Pattern pattern) {
        return this.contains(input.toCharArray(), pattern);
    }

    public boolean contains(PatternMatcherInput input, Pattern pattern) {
        this.__awkPattern = (AwkPattern)pattern;
        this.__scratchBuffer._buffer = input.getBuffer();
        this.__scratchBuffer._bufferOffset = this.__beginOffset = input.getBeginOffset();
        this.__lastMatchedBufferOffset = input.getCurrentOffset();
        if (this.__awkPattern._hasBeginAnchor && (this.__beginOffset != this.__lastMatchedBufferOffset || !this.__awkPattern._fastMap[this.__scratchBuffer._buffer[this.__beginOffset]])) {
            this.__lastMatchResult = null;
            return false;
        }
        this.__scratchBuffer._bufferSize = input.length();
        this.__scratchBuffer._endOfStreamReached = true;
        this.__streamSearchBuffer = this.__scratchBuffer;
        try {
            this._search();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        input.setCurrentOffset(this.__lastMatchedBufferOffset);
        if (this.__lastMatchResult == null) {
            return false;
        }
        input.setMatchOffsets(this.__lastMatchResult.beginOffset(0), this.__lastMatchResult.endOffset(0));
        return true;
    }

    public boolean contains(AwkStreamInput input, Pattern pattern) throws IOException {
        this.__awkPattern = (AwkPattern)pattern;
        if (this.__awkPattern._hasBeginAnchor) {
            if (input._bufferOffset == 0) {
                if (input.read() && !this.__awkPattern._fastMap[input._buffer[0]]) {
                    this.__lastMatchResult = null;
                    return false;
                }
            } else {
                this.__lastMatchResult = null;
                return false;
            }
        }
        this.__lastMatchedBufferOffset = input._currentOffset;
        this.__streamSearchBuffer = input;
        this.__beginOffset = 0;
        this._search();
        input._currentOffset = this.__lastMatchedBufferOffset;
        if (this.__lastMatchResult != null) {
            this.__lastMatchResult._incrementMatchBeginOffset(input._bufferOffset);
            return true;
        }
        return false;
    }

    private int __streamMatchPrefix() throws IOException {
        int initialOffset;
        int current = 1;
        int lastMatchedOffset = -1;
        int offset = initialOffset = this.__offsets[0];
        int maxOffset = this.__streamSearchBuffer._bufferSize + this.__beginOffset;
        while (offset < maxOffset) {
            char token = this.__streamSearchBuffer._buffer[offset++];
            if (current >= this.__awkPattern._numStates) break;
            int lastState = current;
            int[] tstateArray = this.__awkPattern._getStateArray(current);
            if ((current = tstateArray[token]) == 0) {
                this.__awkPattern._createNewState(lastState, token, tstateArray);
                current = tstateArray[token];
            }
            if (current == -1) break;
            if (this.__awkPattern._endStates.get(current)) {
                lastMatchedOffset = offset;
            }
            if (offset != maxOffset || (offset = this.__streamSearchBuffer._reallocate(initialOffset) + this.__beginOffset) == (maxOffset = this.__streamSearchBuffer._bufferSize + this.__beginOffset)) continue;
            if (lastMatchedOffset != -1) {
                lastMatchedOffset -= initialOffset;
            }
            initialOffset = 0;
        }
        this.__offsets[0] = initialOffset;
        this.__offsets[1] = lastMatchedOffset - 1;
        if (lastMatchedOffset == -1 && this.__awkPattern._matchesNullString) {
            return 0;
        }
        if (this.__awkPattern._hasEndAnchor && (!this.__streamSearchBuffer._endOfStreamReached || lastMatchedOffset < this.__streamSearchBuffer._bufferSize + this.__beginOffset)) {
            return -1;
        }
        return lastMatchedOffset - initialOffset;
    }

    void _search() throws IOException {
        this.__lastMatchResult = null;
        while (true) {
            if (this.__lastMatchedBufferOffset >= this.__streamSearchBuffer._bufferSize + this.__beginOffset) {
                if (this.__streamSearchBuffer._endOfStreamReached) {
                    this.__streamSearchBuffer = null;
                    return;
                }
                if (!this.__streamSearchBuffer.read()) {
                    return;
                }
                this.__lastMatchedBufferOffset = 0;
            }
            int position = this.__lastMatchedBufferOffset;
            while (position < this.__streamSearchBuffer._bufferSize + this.__beginOffset) {
                int tokensMatched;
                this.__offsets[0] = position;
                if (this.__awkPattern._fastMap[this.__streamSearchBuffer._buffer[position]] && (tokensMatched = this.__streamMatchPrefix()) > -1) {
                    this.__lastMatchResult = new AwkMatchResult(new String(this.__streamSearchBuffer._buffer, this.__offsets[0], tokensMatched), this.__offsets[0]);
                    this.__lastMatchedBufferOffset = tokensMatched > 0 ? this.__offsets[1] + 1 : this.__offsets[0] + 1;
                    return;
                }
                if (this.__awkPattern._matchesNullString) {
                    this.__lastMatchResult = new AwkMatchResult(new String(), position);
                    this.__lastMatchedBufferOffset = position + 1;
                    return;
                }
                position = this.__offsets[0] + 1;
            }
            this.__lastMatchedBufferOffset = position;
        }
    }

    public MatchResult getMatch() {
        return this.__lastMatchResult;
    }
}

