/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.HttpRequestStructure;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.ListenerInterface;
import anon.util.Base64;
import anon.util.IProgressCallback;
import anon.util.JAPMessages;
import anon.util.ZLibTools;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class Util {
    public static final String VERSION_FORMAT = "00.00.000";
    private static final String WHITESPACE_ENCODED = "%20";
    private static final String WHITESPACE = " ";
    public static final int MAX_FORMAT_BYTES = 0;
    public static final int MAX_FORMAT_KBYTES = 1;
    public static final int MAX_FORMAT_MBYTES = 2;
    public static final int MAX_FORMAT_GBYTES = 3;
    public static final int MAX_FORMAT_KBIT_PER_SEC = 0;
    public static final int MAX_FORMAT_MBIT_PER_SEC = 1;
    public static final int MAX_FORMAT_GBIT_PER_SEC = 2;
    public static final int MAX_FORMAT_ALL = 4;

    private Util() {
    }

    public static boolean assertNotNull(Object a_oneObject, Object a_otherObject) {
        return a_oneObject != null && a_otherObject != null;
    }

    public static boolean equals(Object a_oneObject, Object a_otherObject) {
        return a_oneObject == a_otherObject || a_oneObject != null && a_otherObject != null && a_oneObject.equals(a_otherObject);
    }

    public static String cutString(String a_string, int a_maxLength) {
        if (a_string != null && a_string.length() > a_maxLength) {
            a_string = a_string.substring(0, a_maxLength).trim();
        }
        return a_string;
    }

    public static String stripString(String a_string, String a_charactersToStrip) {
        if (a_string == null || a_charactersToStrip == null) {
            return null;
        }
        String stripped = "";
        StringTokenizer tokenizer = new StringTokenizer(a_string, a_charactersToStrip);
        while (tokenizer.hasMoreTokens()) {
            stripped = stripped + tokenizer.nextToken().trim();
        }
        return stripped;
    }

    public static String decodeString(String a_compressed) {
        String decodedString = a_compressed;
        try {
            byte[] decodedBytes = Base64.decode(a_compressed);
            if (decodedBytes != null) {
                decodedString = new String(ZLibTools.decompress(decodedBytes));
            }
        }
        catch (Exception a_e) {
            LogHolder.log(1, LogType.MISC, a_e);
        }
        return decodedString;
    }

    public static boolean arraysEqual(byte[] arrayOne, byte[] arrayTwo) {
        if (arrayOne == null && arrayTwo == null) {
            return true;
        }
        if (arrayOne == null || arrayTwo == null) {
            return false;
        }
        if (arrayOne.length != arrayTwo.length) {
            return false;
        }
        for (int i = 0; i < arrayOne.length; ++i) {
            if (arrayOne[i] == arrayTwo[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(char[] arrayOne, char[] arrayTwo) {
        if (arrayOne == null && arrayTwo == null) {
            return true;
        }
        if (arrayOne == null || arrayTwo == null) {
            return false;
        }
        if (arrayOne.length != arrayTwo.length) {
            return false;
        }
        for (int i = 0; i < arrayOne.length; ++i) {
            if (arrayOne[i] == arrayTwo[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arraysEqual(byte[] a_arrayA, int a_Aoff, byte[] a_arrayB, int a_Boff, int a_length) {
        if (a_length <= 0) {
            return true;
        }
        if (a_arrayA == null || a_arrayB == null || a_Aoff < 0 || a_Boff < 0) {
            return false;
        }
        if (a_Aoff + a_length > a_arrayA.length || a_Boff + a_length > a_arrayB.length) {
            return false;
        }
        for (int i = 0; i < a_length; ++i) {
            if (a_arrayA[a_Aoff + i] == a_arrayB[a_Boff + i]) continue;
            return false;
        }
        return true;
    }

    public static Vector toVector(Object a_object) {
        Vector<Object> value = new Vector<Object>();
        if (a_object != null) {
            value.addElement(a_object);
        }
        return value;
    }

    public static Object[] toArray(Object a_object) {
        Object[] value = a_object != null ? new Object[]{a_object} : new Object[]{};
        return value;
    }

    private static void swap(String[] a_IDs, String[] a_values, int a, int b) {
        String temp = a_IDs[a];
        a_IDs[a] = a_IDs[b];
        a_IDs[b] = temp;
        temp = a_values[a];
        a_values[a] = a_values[b];
        a_values[b] = temp;
    }

    public static Vector sortStrings(Vector a_vector) {
        int i;
        Vector sortedVector = new Vector();
        String[] buffer = new String[a_vector.size()];
        int[] bufferIndices = new int[a_vector.size()];
        String[] umlauts = new String[2];
        for (i = 0; i < buffer.length; ++i) {
            int j;
            buffer[i] = a_vector.elementAt(i).toString().toLowerCase();
            bufferIndices[i] = i;
            boolean bUmlauts = false;
            for (j = 0; j < umlauts.length && j < buffer[i].length(); ++j) {
                if (!Util.isUmlaut(buffer[i].charAt(j), umlauts, j)) continue;
                bUmlauts = true;
            }
            if (!bUmlauts) continue;
            String temp = "";
            for (j = 0; j < umlauts.length && j < buffer[i].length(); ++j) {
                temp = umlauts[j] == null ? temp + buffer[i].charAt(j) : temp + umlauts[j];
            }
            if (j < buffer[i].length()) {
                temp = temp + buffer[i].substring(j, buffer[i].length());
            }
            buffer[i] = temp;
        }
        Util.bubbleSortStrings(a_vector, buffer, bufferIndices);
        for (i = 0; i < buffer.length; ++i) {
            sortedVector.addElement(a_vector.elementAt(bufferIndices[i]));
        }
        return sortedVector;
    }

    public static double parseDouble(String a_string) throws NumberFormatException {
        int integerPart = 0;
        int mantissaPart = 0;
        int afterCommaDigits = 1;
        boolean preComma = true;
        int sign = 1;
        if (a_string == null) {
            throw new NumberFormatException("NULL cannot be parsed as float!");
        }
        for (int i = 0; i < a_string.length(); ++i) {
            char c = a_string.charAt(i);
            if (Character.isDigit(c)) {
                if (preComma) {
                    integerPart = integerPart * 10 + (c - 48);
                    continue;
                }
                afterCommaDigits *= 10;
                mantissaPart = mantissaPart * 10 + (c - 48);
                continue;
            }
            if (preComma && (c == '.' || c == ',') && a_string.length() > 1) {
                preComma = false;
                continue;
            }
            if (c == '+') continue;
            if (c == '-' && i == 0) {
                sign = -1;
                continue;
            }
            throw new NumberFormatException("No valid float value '" + a_string + "'!");
        }
        double d = ((double)integerPart + (double)mantissaPart / (double)afterCommaDigits) * (double)sign;
        return d;
    }

    public static void sort(String[] a_ids, String[] a_values) {
        Util.quicksort(a_ids, a_values, 0, a_ids.length - 1);
    }

    private static int divide(String[] a_IDs, String[] a_values, int a_left, int a_right) {
        int index = a_left;
        for (int pointer = a_left; pointer < a_right; ++pointer) {
            if (a_IDs[pointer].compareTo(a_IDs[a_right]) > 0) continue;
            Util.swap(a_IDs, a_values, index, pointer);
            ++index;
        }
        Util.swap(a_IDs, a_values, index, a_right);
        return index;
    }

    private static void quicksort(String[] a_IDs, String[] a_values, int a_left, int a_right) {
        if (a_right > a_left) {
            int divisor = Util.divide(a_IDs, a_values, a_left, a_right);
            Util.quicksort(a_IDs, a_values, a_left, divisor - 1);
            Util.quicksort(a_IDs, a_values, divisor + 1, a_right);
        }
    }

    public static void sort(Vector a_vec, Comparable c) {
        if (a_vec != null) {
            Util.quicksort(a_vec, 0, a_vec.size() - 1, c);
        }
    }

    private static int divide(Vector a_vec, int a_left, int a_right, Comparable c) {
        int index = a_left;
        for (int pointer = a_left; pointer < a_right; ++pointer) {
            if (c.compare(a_vec.elementAt(pointer), a_vec.elementAt(a_right)) > 0) continue;
            Util.swap(a_vec, index, pointer);
            ++index;
        }
        Util.swap(a_vec, index, a_right);
        return index;
    }

    private static void quicksort(Vector a_vec, int a_left, int a_right, Comparable c) {
        if (a_right > a_left) {
            int divisor = Util.divide(a_vec, a_left, a_right, c);
            Util.quicksort(a_vec, a_left, divisor - 1, c);
            Util.quicksort(a_vec, divisor + 1, a_right, c);
        }
    }

    private static void swap(Vector a_vec, int a, int b) {
        Object temp = a_vec.elementAt(a);
        a_vec.setElementAt(a_vec.elementAt(b), a);
        a_vec.setElementAt(temp, b);
    }

    private static void bubbleSortStrings(Vector a_vector, String[] buffer, int[] bufferIndices) {
        for (int i = 1; i <= a_vector.size(); ++i) {
            for (int j = a_vector.size() - 1; j > i; --j) {
                if (buffer[j].compareTo(buffer[j - 1]) >= 0) continue;
                String temp = buffer[j];
                int tempIndex = bufferIndices[j];
                buffer[j] = buffer[j - 1];
                bufferIndices[j] = bufferIndices[j - 1];
                buffer[j - 1] = temp;
                bufferIndices[j - 1] = tempIndex;
            }
        }
    }

    public static void interrupt(Thread a_thread, long a_timeout) {
        if (a_thread == null) {
            return;
        }
        try {
            a_thread.join(a_timeout);
        }
        catch (InterruptedException e) {
            LogHolder.log(1, LogType.MISC, e);
        }
        Util.interrupt(a_thread);
    }

    public static void interrupt(Thread a_thread) {
        if (a_thread != null) {
            int i = 0;
            while (a_thread.isAlive()) {
                if (i > 10) {
                    LogHolder.log(1, LogType.MISC, "Thread " + a_thread.getName() + " cannot get interrupted!");
                }
                a_thread.interrupt();
                Thread.yield();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    LogHolder.log(4, LogType.MISC, e);
                }
                ++i;
            }
        }
    }

    private static boolean isUmlaut(char a_character, String[] a_transformedUmlauts, int a_position) {
        switch (a_character) {
            case '\u00e4': {
                a_transformedUmlauts[a_position] = "ae";
                return true;
            }
            case '\u00f6': {
                a_transformedUmlauts[a_position] = "oe";
                return true;
            }
            case '\u00fc': {
                a_transformedUmlauts[a_position] = "ue";
                return true;
            }
        }
        a_transformedUmlauts[a_position] = null;
        return false;
    }

    public static long convertVersionStringToNumber(String a_version) throws NumberFormatException {
        if (a_version == null) {
            throw new NumberFormatException("Version string is null!");
        }
        long version = 0L;
        StringTokenizer st = new StringTokenizer(a_version, ".");
        try {
            version = Long.parseLong(st.nextToken()) * 100000L + Long.parseLong(st.nextToken()) * 1000L + Long.parseLong(st.nextToken());
        }
        catch (NoSuchElementException a_e) {
            throw new NumberFormatException("Version string is too short!");
        }
        return version;
    }

    public static String replaceAll(String a_source, String a_toReplace, String a_replaceWith) {
        return Util.replaceAll(a_source, a_toReplace, a_replaceWith, null);
    }

    public static String replaceAll(String a_source, String a_toReplace, String a_replaceWith, String[] omit) {
        StringBuffer buf = new StringBuffer("");
        int index = a_source.indexOf(a_toReplace, 0);
        int lastIndex = 0;
        boolean replace = true;
        String omitTemp = null;
        while (index != -1) {
            replace = true;
            if (omit != null) {
                omitTemp = a_source.substring(index);
                for (int i = 0; i < omit.length; ++i) {
                    if (!omitTemp.startsWith(omit[i])) continue;
                    replace = false;
                    break;
                }
            }
            if (replace) {
                buf.append(a_source.substring(lastIndex, index));
                buf.append(a_replaceWith);
                lastIndex = index + a_toReplace.length();
            }
            index = a_source.indexOf(a_toReplace, replace ? lastIndex : index + a_toReplace.length());
        }
        buf.append(a_source.substring(lastIndex));
        return buf.toString();
    }

    public static String encodeWhiteSpaces(String stringWithWhitespaces) {
        StringBuffer encodeBuffer = new StringBuffer("");
        int whiteSpIndex = stringWithWhitespaces.indexOf(WHITESPACE, 0);
        int lastIx = 0;
        while (whiteSpIndex != -1) {
            encodeBuffer.append(stringWithWhitespaces.substring(lastIx, whiteSpIndex));
            encodeBuffer.append(WHITESPACE_ENCODED);
            lastIx = whiteSpIndex + WHITESPACE.length();
            whiteSpIndex = stringWithWhitespaces.indexOf(WHITESPACE, whiteSpIndex + 1);
        }
        encodeBuffer.append(stringWithWhitespaces.substring(lastIx));
        return encodeBuffer.toString();
    }

    public static void closeStream(InputStream a_input) {
        if (a_input != null) {
            try {
                a_input.close();
            }
            catch (Throwable a_e) {
                LogHolder.log(3, LogType.MISC, a_e);
            }
        }
    }

    public static void closeStream(OutputStream a_input) {
        if (a_input != null) {
            try {
                a_input.close();
            }
            catch (Exception a_e) {
                LogHolder.log(3, LogType.MISC, a_e);
            }
        }
    }

    public static void copyStream(InputStream a_input, OutputStream a_output) throws IOException {
        Util.copyStream(a_input, a_output, null);
    }

    public static void copyStream(InputStream a_input, OutputStream a_output, IProgressCallback a_callback) throws IOException {
        if (a_input == null) {
            throw new IOException("Input stream is null!");
        }
        if (a_output == null) {
            throw new IOException("Output stream is null!");
        }
        int iMax = 0;
        long lSize = 0L;
        long lStepSize = 0L;
        long lLastSize = 0L;
        if (a_callback != null) {
            iMax = a_callback.getCurrentMaximum();
            lSize = a_callback.getCurrentSize();
            lStepSize = lSize / (long)iMax;
        }
        byte[] buffer = new byte[2048];
        int len = -1;
        while ((len = a_input.read(buffer)) != -1) {
            a_output.write(buffer, 0, len);
            if (iMax <= 0 || (lLastSize += (long)len) < lStepSize) continue;
            lLastSize -= lStepSize;
            --iMax;
            a_callback.setValue(a_callback.getValue() + 1);
        }
        a_input.close();
        a_output.flush();
        a_output.close();
    }

    public static String getStaticFieldValue(Class a_class, String a_fieldName) {
        String fieldValue = null;
        try {
            Field field = a_class.getField(a_fieldName);
            fieldValue = (String)field.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldValue;
    }

    public static String colonizeSKI(String a_ski) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < a_ski.length(); ++i) {
            buff.append(a_ski.charAt(i));
            if ((i + 1) % 2 != 0 || i == a_ski.length() - 1) continue;
            buff.append(":");
        }
        return buff.toString();
    }

    public static InfoServiceDBEntry[] createDefaultInfoServices(String[] a_defaultNames, String[] a_defaultHostNames, int[][] a_defaultPortNumbers) throws Exception {
        InfoServiceDBEntry[] entries = new InfoServiceDBEntry[a_defaultNames.length];
        for (int i = 0; i < entries.length; ++i) {
            Vector<ListenerInterface> listeners = new Vector<ListenerInterface>(a_defaultPortNumbers[i].length);
            for (int j = 0; j < a_defaultPortNumbers[i].length; ++j) {
                listeners.addElement(new ListenerInterface(a_defaultHostNames[i], a_defaultPortNumbers[i][j]));
            }
            entries[i] = new InfoServiceDBEntry(a_defaultNames[i], a_defaultNames[i], listeners, true, true, 0L, 0L, false, null);
            entries[i].markAsBootstrap();
        }
        return entries;
    }

    public static String formatKbitPerSecValueWithUnit(long c) {
        return Util.formatKbitPerSecValueWithUnit(c, 4);
    }

    public static String formatKbitPerSecValueWithUnit(long c, int a_maxFormat) {
        return Util.formatKbitPerSecValueWithoutUnit(c, a_maxFormat) + WHITESPACE + Util.formatKbitPerSecValueOnlyUnit(c, a_maxFormat);
    }

    public static String formatKbitPerSecValueOnlyUnit(long c) {
        return Util.formatKbitPerSecValueOnlyUnit(c, 4);
    }

    public static String formatKbitPerSecValueOnlyUnit(long c, int a_maxFormat) {
        if (c < 1000L || a_maxFormat < 1) {
            return JAPMessages.getString("kbit/s");
        }
        if (c < 1000000L || a_maxFormat < 2) {
            return JAPMessages.getString("Mbit/s");
        }
        return JAPMessages.getString("Gbit/s");
    }

    public static String formatKbitPerSecValueWithoutUnit(long c) {
        return Util.formatKbitPerSecValueWithoutUnit(c, 4);
    }

    public static String formatKbitPerSecValueWithoutUnit(long c, int a_maxFormat) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(JAPMessages.getLocale());
        double d = c;
        if (c < 1000L || a_maxFormat < 1) {
            df.applyPattern("#,####");
        } else if (c < 1000000L || a_maxFormat < 2) {
            d /= 1000.0;
            df.applyPattern("#,##0.0");
        } else {
            d /= 1000000.0;
            df.applyPattern("#,##0.0");
        }
        return df.format(d);
    }

    public static String formatBytesValueWithUnit(long c) {
        return Util.formatBytesValueWithUnit(c, 4);
    }

    public static String formatBytesValueWithUnit(long c, int a_maxFormat) {
        return Util.formatBytesValueWithoutUnit(c, a_maxFormat) + WHITESPACE + Util.formatBytesValueOnlyUnit(c, a_maxFormat);
    }

    public static String formatBytesValueOnlyUnit(long c) {
        return Util.formatBytesValueOnlyUnit(c, 4);
    }

    public static String formatBytesValueOnlyUnit(long c, int a_maxFormat) {
        if (c < 1000L || a_maxFormat < 1) {
            return JAPMessages.getString("Byte");
        }
        if (c < 1000000L || a_maxFormat < 2) {
            return JAPMessages.getString("kByte");
        }
        if (c < 1000000000L || a_maxFormat < 3) {
            return JAPMessages.getString("MByte");
        }
        return JAPMessages.getString("GByte");
    }

    public static String formatBytesValueWithoutUnit(long c) {
        return Util.formatBytesValueWithoutUnit(c, 4);
    }

    public static String formatBytesValueWithoutUnit(long c, int a_maxFormat) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(JAPMessages.getLocale());
        double d = c;
        if (c < 1000L || a_maxFormat < 1) {
            df.applyPattern("#");
        } else if (c < 1000000L || a_maxFormat < 2) {
            d /= 1000.0;
            df.applyPattern("#,###,##0.0");
        } else if (c < 1000000000L || a_maxFormat < 3) {
            d /= 1000000.0;
            df.applyPattern("#,###,##0.0");
        } else {
            d /= 1.0E9;
            df.applyPattern("#,###,##0.0");
        }
        return df.format(d);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress host;
        try {
            host = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            try {
                InetAddress[] hosts = InetAddress.getAllByName("localhost");
                if (hosts == null || hosts.length == 0) {
                    throw new UnknownHostException("localhost");
                }
                host = hosts[0];
            }
            catch (UnknownHostException e1) {
                host = InetAddress.getByName(null);
            }
        }
        return host;
    }

    public static String toHTMLEntities(String buf) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (ch < '\u0000' || ch > '\u007f') {
                b.append("&#").append(Integer.toString(ch)).append(";");
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static String formatTimestamp(Date date, boolean withTime) {
        return Util.formatTimestamp(date, withTime, JAPMessages.getLocale().getLanguage());
    }

    public static String formatTimestamp(Date date, boolean withTime, String a_language) {
        String country = JAPMessages.getLocale().getCountry();
        if (a_language.equalsIgnoreCase("en") && country.equals(Locale.US)) {
            SimpleDateFormat sdf = withTime ? new SimpleDateFormat("MM/dd/yyyy - HH:mm") : new SimpleDateFormat("MM/dd/yyyy");
            return sdf.format(date);
        }
        if (a_language.equalsIgnoreCase("en")) {
            SimpleDateFormat sdf = withTime ? new SimpleDateFormat("dd/MM/yyyy - HH:mm") : new SimpleDateFormat("dd/MM/yyyy");
            return sdf.format(date);
        }
        SimpleDateFormat sdf = a_language.equalsIgnoreCase("de") ? (withTime ? new SimpleDateFormat("dd.MM.yyyy - HH:mm") : new SimpleDateFormat("dd.MM.yyyy")) : (withTime ? new SimpleDateFormat("yyyy-MM-dd  HH:mm") : new SimpleDateFormat("yyyy-MM-dd"));
        return sdf.format(date);
    }

    public static HTTPResponse doHttpGetRequest(ListenerInterface a_targetInterface, ImmutableProxyInterface a_proxyInterface, String a_file) throws IOException, ModuleException {
        if (a_targetInterface == null) {
            return null;
        }
        HTTPConnection connection = HTTPConnectionFactory.getInstance().createHTTPConnection(a_targetInterface, a_proxyInterface, 0, true, null);
        HttpRequestStructure requestStructure = HttpRequestStructure.createGetRequest(a_file);
        LogHolder.log(6, LogType.NET, "Get: " + connection.getHost() + ":" + Integer.toString(connection.getPort()) + requestStructure.getRequestFileName());
        return connection.Get(requestStructure.getRequestFileName());
    }

    public static int readUnsignedShort(InputStream a_inputStream) throws EOFException, IOException {
        int result = a_inputStream.read();
        if (result < 0) {
            throw new EOFException();
        }
        int b = a_inputStream.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (result << 8 | b & 0xFF) & 0xFFFF;
    }

    public static int readInt(InputStream a_inputStream) throws EOFException, IOException {
        int s1 = Util.readUnsignedShort(a_inputStream);
        int s2 = Util.readUnsignedShort(a_inputStream);
        return s1 << 16 | s2 & 0xFFFF;
    }

    public static class StringSortAsc
    implements Comparable {
        public int compare(Object a_obj1, Object a_obj2) {
            if (a_obj1 == null && a_obj2 == null) {
                return 0;
            }
            if (a_obj1 == null) {
                return -1;
            }
            if (a_obj2 == null) {
                return 1;
            }
            return ((String)a_obj1).compareTo((String)a_obj2);
        }
    }

    public static class IntegerSortDesc
    implements Comparable {
        public int compare(Object a_obj1, Object a_obj2) {
            if (a_obj1 == null && a_obj2 == null) {
                return 0;
            }
            if (a_obj1 == null) {
                return 1;
            }
            if (a_obj2 == null) {
                return -1;
            }
            if ((Integer)a_obj1 == Integer.MAX_VALUE) {
                return -1;
            }
            if ((Integer)a_obj2 == Integer.MAX_VALUE) {
                return 1;
            }
            return (Integer)a_obj2 - (Integer)a_obj1;
        }
    }

    public static class IntegerSortAsc
    implements Comparable {
        public int compare(Object a_obj1, Object a_obj2) {
            if (a_obj1 == null && a_obj2 == null) {
                return 0;
            }
            if (a_obj1 == null) {
                return -1;
            }
            if (a_obj2 == null) {
                return 1;
            }
            if ((Integer)a_obj1 == Integer.MAX_VALUE) {
                return 1;
            }
            if ((Integer)a_obj2 == Integer.MAX_VALUE) {
                return -1;
            }
            return (Integer)a_obj1 - (Integer)a_obj2;
        }
    }

    public static class LongSortDesc
    implements Comparable {
        public int compare(Object a_obj1, Object a_obj2) {
            if (a_obj1 == null && a_obj2 == null) {
                return 0;
            }
            if (a_obj1 == null) {
                return 1;
            }
            if (a_obj2 == null) {
                return -1;
            }
            if ((long)((Long)a_obj1).intValue() == Long.MAX_VALUE) {
                return -1;
            }
            if ((long)((Long)a_obj2).intValue() == Long.MAX_VALUE) {
                return 1;
            }
            return (int)((Long)a_obj2 - (Long)a_obj1);
        }
    }

    public static class LongSortAsc
    implements Comparable {
        public int compare(Object a_obj1, Object a_obj2) {
            if (a_obj1 == null && a_obj2 == null) {
                return 0;
            }
            if (a_obj1 == null) {
                return -1;
            }
            if (a_obj2 == null) {
                return 1;
            }
            if ((long)((Long)a_obj1).intValue() == Long.MAX_VALUE) {
                return 1;
            }
            if ((long)((Long)a_obj2).intValue() == Long.MAX_VALUE) {
                return -1;
            }
            return (int)((Long)a_obj1 - (Long)a_obj2);
        }
    }

    public static interface Comparable {
        public int compare(Object var1, Object var2);
    }
}

