/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.address;

import anon.transport.address.AddressMappingException;
import anon.transport.address.AddressParameter;
import anon.transport.address.Endpoint;
import anon.transport.address.IAddress;

public class SkypeAddress
implements IAddress {
    public static final String TRANSPORT_IDENTIFIER = "skype";
    private static final String USER_PARAMETER = "user";
    private static final String APP_PARAMETER = "application";
    protected String m_user;
    protected String m_app;

    public SkypeAddress(String a_userID, String a_applicationName) {
        this.m_user = a_userID;
        this.m_app = a_applicationName;
    }

    public SkypeAddress(Endpoint a_baseAddress) throws AddressMappingException {
        this.m_user = a_baseAddress.getParameter(USER_PARAMETER);
        if (this.m_user == null) {
            throw new AddressMappingException("User-ID Parameter is missing");
        }
        this.m_app = a_baseAddress.getParameter(APP_PARAMETER);
        if (this.m_app == null) {
            throw new AddressMappingException("Applicationname Parameter is missing");
        }
    }

    public String getUserID() {
        return this.m_user;
    }

    public String getApplicationName() {
        return this.m_app;
    }

    public String getTransportIdentifier() {
        return TRANSPORT_IDENTIFIER;
    }

    public AddressParameter[] getAllParameters() {
        AddressParameter[] result = new AddressParameter[]{new AddressParameter(USER_PARAMETER, this.m_user), new AddressParameter(APP_PARAMETER, this.m_app)};
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SkypeAddress)) {
            return false;
        }
        SkypeAddress s = (SkypeAddress)o;
        boolean b = true;
        b = this.m_user != null ? (b &= this.m_user.equals(s.getUserID())) : (b &= s.getUserID() == null);
        b = this.m_app != null ? (b &= this.m_app.equals(s.getUserID())) : (b &= s.getApplicationName() == null);
        return b;
    }
}

