/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.pay.Transaction;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTransactionOverview
implements IXMLEncodable {
    public static final Object XML_ELEMENT_NAME = "TransactionOverview";
    private Vector m_transactions = new Vector();
    private String m_language;
    public static final String KEY_ACCOUNTNUMBER = "accountnumber";
    public static final String KEY_TAN = "tan";
    public static final String KEY_DATE = "date";
    public static final String KEY_CREATIONDATE = "created_on";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_VOLUMEPLAN = "volumeplan";
    public static final String KEY_PAYMENTMETHOD = "paymentmethod";
    public static final String KEY_USED = "used";

    public XMLTransactionOverview(String a_language) {
        this.m_language = a_language;
    }

    public XMLTransactionOverview(char[] xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
    }

    public XMLTransactionOverview(byte[] xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
    }

    public XMLTransactionOverview(Document doc) throws Exception {
        this.setValues(doc.getDocumentElement());
    }

    public XMLTransactionOverview(Element element) throws Exception {
        this.setValues(element);
    }

    public int size() {
        return this.m_transactions.size();
    }

    private void setValues(Element elemRoot) throws Exception {
        this.m_transactions = new Vector();
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME) || !elemRoot.getAttribute("version").equals("1.1")) {
            throw new Exception("TransactionOverview wrong format or wrong version number");
        }
        this.m_language = elemRoot.getAttribute("language");
        NodeList nodesTans = elemRoot.getElementsByTagName("TransferNumber");
        for (int i = 0; i < nodesTans.getLength(); ++i) {
            Hashtable<String, String> transactionData = new Hashtable<String, String>();
            Element curTanElem = (Element)nodesTans.item(i);
            String tan = curTanElem.getFirstChild().getNodeValue();
            tan = XMLUtil.parseValue((Node)curTanElem, "");
            transactionData.put(KEY_TAN, tan);
            String used = curTanElem.getAttribute(KEY_USED) != null ? curTanElem.getAttribute(KEY_USED) : "false";
            transactionData.put(KEY_USED, used);
            String creationDate = curTanElem.getAttribute(KEY_CREATIONDATE) != null ? curTanElem.getAttribute(KEY_CREATIONDATE) : "0";
            transactionData.put(KEY_CREATIONDATE, creationDate);
            String date = curTanElem.getAttribute(KEY_DATE) != null ? curTanElem.getAttribute(KEY_DATE) : "0";
            transactionData.put(KEY_DATE, date);
            String amount = curTanElem.getAttribute(KEY_AMOUNT) != null ? curTanElem.getAttribute(KEY_AMOUNT) : "0";
            transactionData.put(KEY_AMOUNT, amount);
            String accountnumber = curTanElem.getAttribute(KEY_ACCOUNTNUMBER) != null ? curTanElem.getAttribute(KEY_ACCOUNTNUMBER) : "";
            transactionData.put(KEY_ACCOUNTNUMBER, accountnumber);
            String volumeplan = curTanElem.getAttribute(KEY_VOLUMEPLAN) != null ? curTanElem.getAttribute(KEY_VOLUMEPLAN) : "";
            transactionData.put(KEY_VOLUMEPLAN, volumeplan);
            String paymentmethod = curTanElem.getAttribute(KEY_PAYMENTMETHOD) != null ? curTanElem.getAttribute(KEY_PAYMENTMETHOD) : "";
            transactionData.put(KEY_PAYMENTMETHOD, paymentmethod);
            this.m_transactions.addElement(transactionData);
        }
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("TransactionOverview");
        elemRoot.setAttribute("version", "1.1");
        elemRoot.setAttribute("language", this.m_language);
        Enumeration tans = this.m_transactions.elements();
        while (tans.hasMoreElements()) {
            Hashtable curTransaction = (Hashtable)tans.nextElement();
            Element elem = a_doc.createElement("TransferNumber");
            String creationDate = (String)curTransaction.get(KEY_CREATIONDATE);
            creationDate = creationDate == null ? "" : creationDate;
            elem.setAttribute(KEY_CREATIONDATE, creationDate);
            String accountNumber = (String)curTransaction.get(KEY_ACCOUNTNUMBER);
            accountNumber = accountNumber == null ? "" : accountNumber;
            elem.setAttribute(KEY_ACCOUNTNUMBER, accountNumber);
            String date = (String)curTransaction.get(KEY_DATE);
            date = date == null ? "" : date;
            elem.setAttribute(KEY_DATE, date);
            String amount = (String)curTransaction.get(KEY_AMOUNT);
            amount = amount == null ? "" : amount;
            elem.setAttribute(KEY_AMOUNT, amount);
            String volumePlan = (String)curTransaction.get(KEY_VOLUMEPLAN);
            volumePlan = volumePlan == null ? "" : volumePlan;
            elem.setAttribute(KEY_VOLUMEPLAN, volumePlan);
            String paymentMethod = (String)curTransaction.get(KEY_PAYMENTMETHOD);
            paymentMethod = paymentMethod == null ? "" : paymentMethod;
            elem.setAttribute(KEY_PAYMENTMETHOD, paymentMethod);
            String used = (String)curTransaction.get(KEY_USED);
            used = used == null ? "" : used;
            elem.setAttribute(KEY_USED, used);
            String transferNumber = (String)curTransaction.get(KEY_TAN);
            elem.appendChild(a_doc.createTextNode(transferNumber));
            elemRoot.appendChild(elem);
        }
        return elemRoot;
    }

    public Vector getTans() {
        return this.m_transactions;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public boolean isUsed(long a_tan) {
        boolean used = false;
        Hashtable theTransaction = this.getDataForTransaction(a_tan);
        if (theTransaction != null) {
            String usedString = (String)theTransaction.get(KEY_USED);
            used = Boolean.valueOf(usedString);
        }
        return used;
    }

    public Hashtable getDataForTransaction(long a_transactionNumber) {
        Hashtable matchingTransaction = null;
        Enumeration allTans = this.m_transactions.elements();
        while (allTans.hasMoreElements()) {
            Hashtable transactionData = (Hashtable)allTans.nextElement();
            String tan = (String)transactionData.get(KEY_TAN);
            try {
                long curTan = Long.parseLong(tan);
                if (curTan != a_transactionNumber) continue;
                matchingTransaction = transactionData;
                break;
            }
            catch (NumberFormatException a_e) {
                LogHolder.log(3, LogType.PAY, a_e);
            }
        }
        return matchingTransaction;
    }

    public void setTransactionData(long a_tan, long a_creationDate, boolean a_used, long a_usedDate, long amount, long accountnumber, String volumePlan, String paymentMethod) {
        String strAccountNumber = accountnumber == 0L ? new String("") : new Long(accountnumber).toString();
        String strAmount = amount == 0L ? new String("") : new Long(amount).toString();
        String strCreationDate = a_creationDate == 0L ? new String("") : new Long(a_creationDate).toString();
        String strUsedDate = a_usedDate == 0L ? new String("") : new Long(a_usedDate).toString();
        if (volumePlan == null) {
            volumePlan = new String("");
        }
        if (paymentMethod == null) {
            paymentMethod = new String("");
        }
        Hashtable affectedTransaction = this.getDataForTransaction(a_tan);
        affectedTransaction.put(KEY_USED, new Boolean(a_used).toString());
        affectedTransaction.put(KEY_DATE, strUsedDate);
        affectedTransaction.put(KEY_CREATIONDATE, strCreationDate);
        affectedTransaction.put(KEY_ACCOUNTNUMBER, strAccountNumber);
        affectedTransaction.put(KEY_AMOUNT, strAmount);
        affectedTransaction.put(KEY_VOLUMEPLAN, volumePlan);
        affectedTransaction.put(KEY_PAYMENTMETHOD, paymentMethod);
    }

    public void addTan(Transaction a_transaction) {
        Hashtable<String, String> newTransaction = new Hashtable<String, String>();
        newTransaction.put(KEY_TAN, new Long(a_transaction.getID()).toString());
        newTransaction.put(KEY_USED, new Boolean(a_transaction.isUsed()).toString());
        if (a_transaction.getUsedTime() != null) {
            newTransaction.put(KEY_DATE, new Long(a_transaction.getUsedTime().getTime()).toString());
        }
        newTransaction.put(KEY_CREATIONDATE, new Long(a_transaction.getCreationTime().getTime()).toString());
        newTransaction.put(KEY_ACCOUNTNUMBER, new Long(a_transaction.getAccountNumber()).toString());
        newTransaction.put(KEY_AMOUNT, new Integer(a_transaction.getAmountEuroCent()).toString());
        newTransaction.put(KEY_VOLUMEPLAN, a_transaction.getRateName() == null ? "" : a_transaction.getRateName());
        newTransaction.put(KEY_PAYMENTMETHOD, a_transaction.getPaymentMethod());
        this.m_transactions.addElement(newTransaction);
    }
}

