/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice.update;

import anon.client.TrustModel;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.StatusInfo;
import anon.infoservice.update.AbstractDatabaseUpdater;
import anon.util.Updater;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractMixCascadeUpdater
extends AbstractDatabaseUpdater {
    private static final long UPDATE_INTERVAL_MS = 600000L;
    private static final long MIN_UPDATE_INTERVAL_MS = 300000L;
    private boolean m_bDoMixInfoCleanup = true;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$infoservice$MixInfo;
    static /* synthetic */ Class class$anon$infoservice$StatusInfo;

    public AbstractMixCascadeUpdater(Updater.ObservableInfo a_observableInfo) {
        super(new Updater.DynamicUpdateInterval(600000L), a_observableInfo);
    }

    public AbstractMixCascadeUpdater(long interval, boolean a_bDoMixInfoCleanup, Updater.ObservableInfo a_observableInfo) {
        super(interval, a_observableInfo);
        this.m_bDoMixInfoCleanup = a_bDoMixInfoCleanup;
    }

    protected abstract AbstractDatabaseEntry getPreferredEntry();

    protected abstract void setPreferredEntry(AbstractDatabaseEntry var1);

    public final Class getUpdatedClass() {
        return class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractMixCascadeUpdater.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade;
    }

    protected final boolean doCleanup(Hashtable a_newEntries) {
        boolean bUpdated = super.doCleanup(a_newEntries);
        MixCascade preferredEntry = (MixCascade)this.getPreferredEntry();
        if (this.m_bDoMixInfoCleanup) {
            LogHolder.log(7, LogType.MISC, "Do MixInfo database cleanup.");
            Vector mixes = Database.getInstance(class$anon$infoservice$MixInfo == null ? (class$anon$infoservice$MixInfo = AbstractMixCascadeUpdater.class$("anon.infoservice.MixInfo")) : class$anon$infoservice$MixInfo).getEntryList();
            Vector cascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractMixCascadeUpdater.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
            if (preferredEntry != null) {
                cascades.addElement(preferredEntry);
            }
            block0: for (int i = 0; i < mixes.size(); ++i) {
                MixInfo currentMix = (MixInfo)mixes.elementAt(i);
                if (Database.getInstance(class$anon$infoservice$MixCascade == null ? AbstractMixCascadeUpdater.class$("anon.infoservice.MixCascade") : class$anon$infoservice$MixCascade).getEntryById(currentMix.getId()) != null || preferredEntry != null && preferredEntry.getMixId(0).equals(currentMix.getId())) continue;
                for (int j = 0; j < cascades.size(); ++j) {
                    Vector currentCascadeMixes = ((MixCascade)cascades.elementAt(j)).getMixIds();
                    for (int k = 1; k < currentCascadeMixes.size(); ++k) {
                        if (currentCascadeMixes.elementAt(k).equals(currentMix.getId())) continue block0;
                    }
                }
                Database.getInstance(class$anon$infoservice$MixInfo == null ? AbstractMixCascadeUpdater.class$("anon.infoservice.MixInfo") : class$anon$infoservice$MixInfo).remove(currentMix);
                LogHolder.log(5, LogType.MISC, "Cleaned MixInfo DB entry: " + currentMix.getId());
            }
        }
        return bUpdated;
    }

    protected final Hashtable getEntrySerials() {
        Hashtable result = InfoServiceHolder.getInstance().getMixCascadeSerials(TrustModel.getContext());
        if (this.getUpdateInterval() instanceof Updater.DynamicUpdateInterval) {
            if (result == null) {
                ((Updater.DynamicUpdateInterval)this.getUpdateInterval()).setUpdateInterval(300000L);
            } else {
                ((Updater.DynamicUpdateInterval)this.getUpdateInterval()).setUpdateInterval(600000L);
            }
        }
        return result;
    }

    protected Hashtable getUpdatedEntries(Hashtable a_entriesToUpdate) {
        MixCascade currentCascade;
        Hashtable cascadesInDB = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractMixCascadeUpdater.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryHash();
        Enumeration enumCascades = cascadesInDB.elements();
        Hashtable updatedCascades = new Hashtable();
        while (enumCascades.hasMoreElements()) {
            currentCascade = (MixCascade)enumCascades.nextElement();
            if (!this.fetchCurrentStatus(currentCascade)) continue;
            updatedCascades.put(currentCascade.getId(), currentCascade);
        }
        cascadesInDB = updatedCascades;
        updatedCascades = this.getUpdatedEntries_internal(a_entriesToUpdate);
        if (updatedCascades != null) {
            enumCascades = updatedCascades.elements();
            while (enumCascades.hasMoreElements()) {
                currentCascade = (MixCascade)enumCascades.nextElement();
                if (cascadesInDB.contains(currentCascade)) continue;
                this.fetchCurrentStatus(currentCascade);
            }
        }
        return updatedCascades;
    }

    private final boolean fetchCurrentStatus(MixCascade a_cascade) {
        StatusInfo info = null;
        if (!a_cascade.isUserDefined()) {
            info = a_cascade.fetchCurrentStatus(1800000L);
            return Database.getInstance(class$anon$infoservice$StatusInfo == null ? (class$anon$infoservice$StatusInfo = AbstractMixCascadeUpdater.class$("anon.infoservice.StatusInfo")) : class$anon$infoservice$StatusInfo).update(info);
        }
        return info != null;
    }

    protected final Hashtable getUpdatedEntries_internal(Hashtable a_entriesToUpdate) {
        MixCascade cascade;
        Hashtable result;
        if (a_entriesToUpdate == null) {
            result = InfoServiceHolder.getInstance().getMixCascades(TrustModel.getContext());
        } else if (a_entriesToUpdate.size() == 0) {
            result = new Hashtable();
        } else {
            Hashtable<String, MixCascade> returnedEntries = new Hashtable<String, MixCascade>(a_entriesToUpdate.size());
            Enumeration enumEntriesToUpdate = a_entriesToUpdate.keys();
            while (enumEntriesToUpdate.hasMoreElements()) {
                cascade = InfoServiceHolder.getInstance().getMixCascadeInfo((String)enumEntriesToUpdate.nextElement());
                if (cascade == null) continue;
                returnedEntries.put(cascade.getId(), cascade);
            }
            result = returnedEntries;
        }
        if (!TrustModel.isFreeAllowed()) {
            Hashtable<String, MixCascade> hashFiltered = new Hashtable<String, MixCascade>();
            Enumeration enumResult = result.elements();
            while (enumResult.hasMoreElements()) {
                cascade = (MixCascade)enumResult.nextElement();
                if (!cascade.isPayment()) continue;
                hashFiltered.put(cascade.getId(), cascade);
            }
            result = hashFiltered;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

