/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.MixCascade;
import anon.util.ClassUtil;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractCascadeIDEntry
extends AbstractDatabaseEntry
implements IXMLEncodable {
    private static final String XML_ID = "ID";
    private static final String XML_CASCADE_ID = "CascadeID";
    private static final String XML_ATTR_UPDATE_TIME = "updateTime";
    private static final String XML_ATTR_EXPIRE_TIME = "expireTime";
    private String m_ID;
    private long m_version;
    private String m_cascadeID;

    public AbstractCascadeIDEntry(MixCascade a_cascade, long a_expireTime) throws IllegalArgumentException {
        super(a_expireTime);
        if (a_cascade == null) {
            throw new IllegalArgumentException("Given cascade is null!");
        }
        this.m_ID = a_cascade.getMixIDsAsString();
        this.m_version = System.currentTimeMillis();
        this.m_cascadeID = a_cascade.getId();
    }

    public AbstractCascadeIDEntry(AbstractCascadeIDEntry a_entry, long a_expireTime) throws IllegalArgumentException {
        super(a_expireTime);
        if (a_entry == null) {
            throw new IllegalArgumentException("Given cascade is null!");
        }
        this.m_ID = a_entry.getId();
        this.m_version = System.currentTimeMillis();
        this.m_cascadeID = a_entry.getCascadeId();
    }

    public AbstractCascadeIDEntry(Element a_xmlElement) throws XMLParseException {
        super(XMLUtil.parseAttribute((Node)a_xmlElement, XML_ATTR_EXPIRE_TIME, 0L));
        if (a_xmlElement == null) {
            throw new XMLParseException("##__null__##");
        }
        if (!a_xmlElement.getNodeName().equals(ClassUtil.getShortClassName(this.getClass()))) {
            throw new XMLParseException("##__root__##");
        }
        this.m_version = XMLUtil.parseAttribute((Node)a_xmlElement, XML_ATTR_UPDATE_TIME, 0);
        this.m_ID = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_xmlElement, XML_ID), null);
        this.m_cascadeID = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_xmlElement, XML_CASCADE_ID), null);
        if (this.m_ID == null || this.m_cascadeID == null) {
            throw new XMLParseException("This is no valid " + ClassUtil.getShortClassName(this.getClass()) + " node!");
        }
    }

    public final String getCascadeId() {
        return this.m_cascadeID;
    }

    public boolean isReferencedCascade(MixCascade a_cascade) {
        return a_cascade != null && a_cascade.getMixIDsAsString() != null && a_cascade.getMixIDsAsString().equals(this.getId());
    }

    public final String getId() {
        return this.m_ID;
    }

    public long getLastUpdate() {
        return this.m_version;
    }

    public final long getVersionNumber() {
        return this.m_version;
    }

    protected void toXmlElementAppend(Element a_elem) {
    }

    public Element toXmlElement(Document a_doc) {
        Element element = a_doc.createElement(ClassUtil.getShortClassName(this.getClass()));
        Element temp = a_doc.createElement(XML_ID);
        XMLUtil.setAttribute(element, XML_ATTR_UPDATE_TIME, this.m_version);
        XMLUtil.setAttribute(element, XML_ATTR_EXPIRE_TIME, this.getExpireTime());
        XMLUtil.setValue((Node)temp, this.m_ID);
        element.appendChild(temp);
        temp = a_doc.createElement(XML_CASCADE_ID);
        XMLUtil.setValue((Node)temp, this.m_cascadeID);
        element.appendChild(temp);
        this.toXmlElementAppend(element);
        return element;
    }
}

