/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage;

import anon.anonudp.mixmessage.Padding;
import anon.anonudp.mixmessage.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Fragment {
    public static final int DATA_OVERHEAD = 0;
    private static final int INIT_OVERHEAD = 131;
    private static final int DUMMY_PAYLOAD_SIZE = 0;
    public static final int DATA_PAYLOAD_SIZE = 274;
    public static final int INIT_PAYLOAD_SIZE = 143;
    static final int ID_SIZE = 2;
    private static final int INDEX_SIZE = 1;
    private static final int HEADER_SIZE = 3;
    public static final int SIZE_DATA = 277;
    public static final int SIZE_INIT = 146;
    static final int SINGLE_FRAGMENT_MESSAGE_ID = 0;
    static final int SINGLE_FRAGMENT_FRAGMENT_NUMBER = 0;
    private static final int BIT_HAS_PADDING = 1;
    private static final int BIT_LAST_FRAGMENT = 2;
    private int m_iMessageID;
    private int m_iFragmentNumber;
    private final boolean m_bisLast;
    private byte[] payload;
    private boolean bytesCached;
    private byte[] byteArrayCache;
    private Padding padding;

    public Fragment() {
        this(0, 0, new byte[0], 0);
    }

    public Fragment(int message_id, int fragment_number, byte[] payload, int payload_limit) {
        if (payload_limit != 143 && payload_limit != 274 && payload_limit != 0) {
            throw new IllegalArgumentException("Payload limit is not an accepted value. Use Fragment.*_PAYLOAD_SIZE instead.");
        }
        this.bytesCached = false;
        this.byteArrayCache = new byte[3 + payload_limit];
        if (fragment_number == 0 && payload.length <= payload_limit + 1) {
            this.m_iMessageID = 0;
            ++payload_limit;
        } else {
            this.m_iMessageID = message_id;
        }
        this.m_bisLast = payload.length <= payload_limit;
        this.m_iFragmentNumber = fragment_number;
        this.padding = new Padding(payload_limit - payload.length);
        this.payload = payload.length > payload_limit ? Util.copyOf(payload, payload_limit) : payload;
    }

    public Fragment(byte[] fragment) throws IllegalArgumentException {
        this(fragment, 277);
    }

    public Fragment(byte[] fragment, int length) throws IllegalArgumentException {
        this.bytesCached = true;
        this.byteArrayCache = new byte[fragment.length];
        System.arraycopy(fragment, 0, this.byteArrayCache, 0, fragment.length);
        int current_offset = 0;
        this.m_iMessageID = fragment[current_offset];
        this.m_iMessageID <<= 8;
        this.m_iMessageID |= fragment[++current_offset] & 0xFF;
        this.m_iMessageID >>= 2;
        boolean bl = this.m_bisLast = (fragment[current_offset] & 2) > 0;
        if (this.m_iMessageID == 0 && !this.m_bisLast) {
            throw new IllegalArgumentException("Message should only contain one fragment, but the given fragment was not the last.");
        }
        boolean has_padding = (fragment[current_offset] & 1) > 0;
        ++current_offset;
        if (this.m_iMessageID == 0) {
            this.m_iFragmentNumber = 0;
        } else {
            this.m_iFragmentNumber = fragment[current_offset] & 0xFF;
            ++current_offset;
        }
        if (has_padding) {
            this.padding = new Padding(fragment, current_offset);
            current_offset += this.getPadding_bytes().length;
        } else {
            this.padding = new Padding(0);
        }
        int payload_length = length - current_offset - this.padding.getLength();
        this.payload = Util.copyOfRange(fragment, current_offset, current_offset + payload_length);
        if (this.payload == null) {
            throw new IllegalArgumentException("Something is wrong with this fragment (payload) [ID=" + this.m_iMessageID + "]: Current offset: " + current_offset + "payload len: " + payload_length);
        }
    }

    int getMessage_id() {
        return this.m_iMessageID;
    }

    int getFragment_number() {
        return this.m_iFragmentNumber;
    }

    boolean isLast() {
        return this.m_bisLast;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    int getPadding_length() {
        return this.padding.getLength();
    }

    byte[] getPadding_bytes() {
        return this.padding.getLengthAsBytes();
    }

    public byte[] toBytes() throws IOException {
        if (!this.bytesCached) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int message_id_and_flags = this.m_iMessageID;
            message_id_and_flags <<= 2;
            if (this.m_bisLast) {
                message_id_and_flags |= 2;
            }
            if (this.getPadding_length() > 0) {
                message_id_and_flags |= 1;
            }
            bos.write(message_id_and_flags >> 8 & 0xFF);
            bos.write(message_id_and_flags & 0xFF);
            if (this.m_iMessageID != 0) {
                bos.write(this.m_iFragmentNumber);
            }
            bos.write(this.getPadding_bytes());
            bos.write(this.payload);
            bos.write(this.padding.getPaddingBytes());
            if (bos.size() != this.byteArrayCache.length) {
                throw new IOException("Generated byte array was not the correct size of a fragment.");
            }
            this.byteArrayCache = bos.toByteArray();
            this.bytesCached = true;
        }
        return this.byteArrayCache;
    }
}

