/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ParseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

public class HttpClientURI {
    protected static BitSet alphanumChar;
    protected static BitSet markChar;
    protected static BitSet reservedChar;
    protected static BitSet unreservedChar;
    protected static BitSet uricChar;
    protected static BitSet pcharChar;
    protected static BitSet userinfoChar;
    protected static BitSet schemeChar;
    protected static BitSet reg_nameChar;
    protected boolean is_generic;
    protected String scheme;
    protected String opaque;
    protected String userinfo;
    protected String host;
    protected int port = -1;
    protected String path;
    protected String query;
    protected String fragment;
    protected URL url = null;
    private static final char[] hex;

    public HttpClientURI(String uri) throws ParseException {
        this((HttpClientURI)null, uri);
    }

    public HttpClientURI(HttpClientURI base, String rel_uri) throws ParseException {
        int idx;
        int pos;
        char[] uri = rel_uri.toCharArray();
        int len = uri.length;
        for (pos = 0; pos < len && Character.isWhitespace(uri[pos]); ++pos) {
        }
        while (len > 0 && Character.isWhitespace(uri[len - 1])) {
            --len;
        }
        if (!(pos >= len - 3 || uri[pos + 3] != ':' || uri[pos + 0] != 'u' && uri[pos + 0] != 'U' || uri[pos + 1] != 'r' && uri[pos + 1] != 'R' || uri[pos + 2] != 'i' && uri[pos + 2] != 'I' && uri[pos + 2] != 'l' && uri[pos + 2] != 'L')) {
            pos += 4;
        }
        for (idx = pos; idx < len && uri[idx] != ':' && uri[idx] != '/' && uri[idx] != '?' && uri[idx] != '#'; ++idx) {
        }
        if (idx < len && uri[idx] == ':') {
            this.scheme = rel_uri.substring(pos, idx).trim().toLowerCase();
            pos = idx + 1;
        }
        String final_scheme = this.scheme;
        if (this.scheme == null) {
            if (base == null) {
                throw new ParseException("No scheme found");
            }
            final_scheme = base.scheme;
        }
        this.is_generic = HttpClientURI.usesGenericSyntax(final_scheme);
        if (!this.is_generic) {
            if (base != null && this.scheme == null) {
                throw new ParseException("Can't resolve relative URI for scheme " + final_scheme);
            }
            this.opaque = rel_uri.substring(pos);
            return;
        }
        if (pos < len - 1 && uri[pos] == '/' && uri[pos + 1] == '/') {
            for (idx = pos += 2; idx < len && uri[idx] != '/' && uri[idx] != '?' && uri[idx] != '#'; ++idx) {
            }
            this.parse_authority(rel_uri.substring(pos, idx), final_scheme);
            pos = idx;
        }
        for (idx = pos; idx < len && uri[idx] != '?' && uri[idx] != '#'; ++idx) {
        }
        this.path = rel_uri.substring(pos, idx);
        pos = idx;
        if (pos < len && uri[pos] == '?') {
            for (idx = ++pos; idx < len && uri[idx] != '#'; ++idx) {
            }
            this.query = HttpClientURI.unescape(rel_uri.substring(pos, idx));
            pos = idx;
        }
        if (pos < len && uri[pos] == '#') {
            this.fragment = HttpClientURI.unescape(rel_uri.substring(pos + 1, len));
        }
        if (base != null) {
            if (this.scheme != null) {
                return;
            }
            this.scheme = base.scheme;
            if (this.host != null) {
                return;
            }
            this.userinfo = base.userinfo;
            this.host = base.host;
            this.port = base.port;
            if (this.path.length() == 0 && this.query == null) {
                this.path = base.path;
                this.query = base.query;
                return;
            }
            if (this.path.length() == 0 || this.path.charAt(0) != '/') {
                idx = base.path.lastIndexOf(47);
                if (idx == -1) {
                    return;
                }
                this.path = base.path.substring(0, idx + 1) + this.path;
                len = this.path.length();
                idx = this.path.indexOf("/.");
                if (idx == -1 || idx != len - 2 && this.path.charAt(idx + 2) != '/' && (this.path.charAt(idx + 2) != '.' || idx != len - 3 && this.path.charAt(idx + 3) != '/')) {
                    return;
                }
                char[] p = new char[this.path.length()];
                this.path.getChars(0, p.length, p, 0);
                for (idx = 1; idx < len; ++idx) {
                    int end;
                    if (p[idx] != '.' || p[idx - 1] != '/') continue;
                    if (idx == len - 1) {
                        end = idx++;
                    } else if (p[idx + 1] == '/') {
                        end = idx - 1;
                        ++idx;
                    } else {
                        if (p[idx + 1] != '.' || idx != len - 2 && p[idx + 2] != '/') continue;
                        for (end = idx - 2; end > 0 && p[end] != '/'; --end) {
                        }
                        if (p[end] != '/') continue;
                        if (idx == len - 2) {
                            ++end;
                        }
                        idx += 2;
                    }
                    System.arraycopy(p, idx, p, end, len - idx);
                    len -= idx - end;
                    idx = end;
                }
                this.path = new String(p, 0, len);
            }
        }
    }

    private void parse_authority(String authority, String scheme) throws ParseException {
        int idx;
        char[] uri = authority.toCharArray();
        int pos = 0;
        int len = uri.length;
        for (idx = pos; idx < len && uri[idx] != '@'; ++idx) {
        }
        if (idx < len && uri[idx] == '@') {
            this.userinfo = HttpClientURI.unescape(authority.substring(pos, idx));
            pos = idx + 1;
        }
        for (idx = pos; idx < len && uri[idx] != ':'; ++idx) {
        }
        this.host = authority.substring(pos, idx);
        pos = idx;
        if (pos < len - 1 && uri[pos] == ':') {
            int p;
            try {
                p = Integer.parseInt(authority.substring(pos + 1, len));
                if (p < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException(authority.substring(pos + 1, len) + " is an invalid port number");
            }
            this.port = p == HttpClientURI.defaultPort(scheme) ? -1 : p;
        }
    }

    public HttpClientURI(String scheme, String host, String path) throws ParseException {
        this(scheme, null, host, -1, path, null, null);
    }

    public HttpClientURI(String scheme, String host, int port, String path) throws ParseException {
        this(scheme, null, host, port, path, null, null);
    }

    public HttpClientURI(String scheme, String userinfo, String host, int port, String path, String query, String fragment) throws ParseException {
        if (scheme == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = scheme.trim();
        if (userinfo != null) {
            this.userinfo = HttpClientURI.unescape(userinfo.trim());
        }
        if (host != null) {
            this.host = host.trim();
        }
        if (port != HttpClientURI.defaultPort(scheme)) {
            this.port = port;
        }
        if (path != null) {
            this.path = path.trim();
        }
        if (query != null) {
            this.query = query.trim();
        }
        if (fragment != null) {
            this.fragment = fragment.trim();
        }
        this.is_generic = true;
    }

    public HttpClientURI(String scheme, String opaque) throws ParseException {
        if (scheme == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = scheme.trim().toLowerCase();
        this.opaque = opaque;
        this.is_generic = false;
    }

    public static boolean usesGenericSyntax(String scheme) {
        return (scheme = scheme.trim()).equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("shttp") || scheme.equalsIgnoreCase("coffee") || scheme.equalsIgnoreCase("ftp") || scheme.equalsIgnoreCase("file") || scheme.equalsIgnoreCase("gopher") || scheme.equalsIgnoreCase("nntp") || scheme.equalsIgnoreCase("telnet") || scheme.equalsIgnoreCase("imap") || scheme.equalsIgnoreCase("wais") || scheme.equalsIgnoreCase("nfs") || scheme.equalsIgnoreCase("ldap") || scheme.equalsIgnoreCase("prospero");
    }

    public static final int defaultPort(String protocol) {
        String prot = protocol.trim();
        if (prot.equalsIgnoreCase("http") || prot.equalsIgnoreCase("shttp") || prot.equalsIgnoreCase("http-ng") || prot.equalsIgnoreCase("coffee")) {
            return 80;
        }
        if (prot.equalsIgnoreCase("https")) {
            return 443;
        }
        if (prot.equalsIgnoreCase("ftp")) {
            return 21;
        }
        if (prot.equalsIgnoreCase("telnet")) {
            return 23;
        }
        if (prot.equalsIgnoreCase("nntp")) {
            return 119;
        }
        if (prot.equalsIgnoreCase("smtp")) {
            return 25;
        }
        if (prot.equalsIgnoreCase("gopher")) {
            return 70;
        }
        if (prot.equalsIgnoreCase("wais")) {
            return 210;
        }
        if (prot.equalsIgnoreCase("whois")) {
            return 43;
        }
        if (prot.equalsIgnoreCase("imap")) {
            return 143;
        }
        if (prot.equalsIgnoreCase("prospero")) {
            return 1525;
        }
        if (prot.equalsIgnoreCase("ldap")) {
            return 389;
        }
        if (prot.equalsIgnoreCase("nfs")) {
            return 2049;
        }
        return 0;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getPath() {
        if (this.query != null) {
            if (this.path != null) {
                return this.path + "?" + this.query;
            }
            return "?" + this.query;
        }
        return this.path;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isGenericURI() {
        return this.is_generic;
    }

    public URL toURL() throws MalformedURLException {
        if (this.url != null) {
            return this.url;
        }
        if (this.opaque != null) {
            this.url = new URL(this.scheme + ":" + this.opaque);
            return this.url;
        }
        StringBuffer file = new StringBuffer(100);
        if (this.path != null) {
            file.append(HttpClientURI.escape(this.path.toCharArray(), uricChar));
        }
        if (this.query != null) {
            file.append('?');
            file.append(HttpClientURI.escape(this.query.toCharArray(), uricChar));
        }
        if (this.fragment != null) {
            file.append('#');
            file.append(HttpClientURI.escape(this.fragment.toCharArray(), uricChar));
        }
        this.url = new URL(this.scheme, this.host, this.port, file.toString());
        return this.url;
    }

    public String toExternalForm() {
        StringBuffer uri = new StringBuffer(100);
        if (this.scheme != null) {
            uri.append(this.scheme);
            uri.append(':');
        }
        if (this.opaque != null) {
            uri.append(HttpClientURI.escape(this.opaque.toCharArray(), uricChar));
            return uri.toString();
        }
        if (this.userinfo != null || this.host != null || this.port != -1) {
            uri.append("//");
        }
        if (this.userinfo != null) {
            uri.append(HttpClientURI.escape(this.userinfo.toCharArray(), userinfoChar));
            uri.append('@');
        }
        if (this.host != null) {
            uri.append(this.host.toCharArray());
        }
        if (this.port != -1) {
            uri.append(':');
            uri.append(this.port);
        }
        if (this.path != null) {
            uri.append(this.path.toCharArray());
        }
        if (this.query != null) {
            uri.append('?');
            uri.append(HttpClientURI.escape(this.query.toCharArray(), uricChar));
        }
        if (this.fragment != null) {
            uri.append('#');
            uri.append(HttpClientURI.escape(this.fragment.toCharArray(), uricChar));
        }
        return uri.toString();
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object other) {
        if (other instanceof HttpClientURI) {
            HttpClientURI o = (HttpClientURI)other;
            return this.scheme.equalsIgnoreCase(o.scheme) && (!this.is_generic && (this.opaque == null && o.opaque == null || this.opaque != null && o.opaque != null && this.opaque.equals(o.opaque)) || this.is_generic && (this.userinfo == null && o.userinfo == null || this.userinfo != null && o.userinfo != null && this.userinfo.equals(o.userinfo)) && (this.host == null && o.host == null || this.host != null && o.host != null && this.host.equalsIgnoreCase(o.host)) && this.port == o.port && (this.path == null && o.path == null || this.path != null && o.path != null && HttpClientURI.unescapeNoPE(this.path).equals(HttpClientURI.unescapeNoPE(o.path))) && (this.query == null && o.query == null || this.query != null && o.query != null && HttpClientURI.unescapeNoPE(this.query).equals(HttpClientURI.unescapeNoPE(o.query))) && (this.fragment == null && o.fragment == null || this.fragment != null && o.fragment != null && HttpClientURI.unescapeNoPE(this.fragment).equals(HttpClientURI.unescapeNoPE(o.fragment))));
        }
        if (other instanceof URL) {
            URL o = (URL)other;
            String h = this.userinfo != null ? this.userinfo + "@" + this.host : this.host;
            String f = this.query != null ? this.path + "?" + this.query : this.path;
            return this.scheme.equalsIgnoreCase(o.getProtocol()) && (!this.is_generic && this.opaque.equals(o.getFile()) || this.is_generic && (h == null && o.getHost() == null || h != null && o.getHost() != null && h.equalsIgnoreCase(o.getHost())) && (this.port == o.getPort() || o.getPort() == HttpClientURI.defaultPort(this.scheme)) && (f == null && o.getFile() == null || f != null && o.getFile() != null && HttpClientURI.unescapeNoPE(f).equals(HttpClientURI.unescapeNoPE(o.getFile()))) && (this.fragment == null && o.getRef() == null || this.fragment != null && o.getRef() != null && HttpClientURI.unescapeNoPE(this.fragment).equals(HttpClientURI.unescapeNoPE(o.getRef()))));
        }
        return false;
    }

    private static char[] escape(char[] elem, BitSet allowed_char) {
        int cnt = 0;
        for (int idx = 0; idx < elem.length; ++idx) {
            if (allowed_char.get(elem[idx])) continue;
            ++cnt;
        }
        if (cnt == 0) {
            return elem;
        }
        char[] tmp = new char[elem.length + 2 * cnt];
        int idx = 0;
        int pos = 0;
        while (idx < elem.length) {
            if (allowed_char.get(elem[idx])) {
                tmp[pos] = elem[idx];
            } else {
                if (elem[idx] > '\u00ff') {
                    throw new RuntimeException("Can't handle non 8-bt chars");
                }
                tmp[pos++] = 37;
                tmp[pos++] = hex[elem[idx] >> 4 & 0xF];
                tmp[pos] = hex[elem[idx] & 0xF];
            }
            ++idx;
            ++pos;
        }
        return tmp;
    }

    static final String unescape(String str) throws ParseException {
        if (str == null || str.indexOf(37) == -1) {
            return str;
        }
        char[] buf = str.toCharArray();
        char[] res = new char[buf.length];
        int didx = 0;
        int sidx = 0;
        while (sidx < buf.length) {
            if (buf[sidx] == '%') {
                int ch;
                try {
                    ch = Integer.parseInt(str.substring(sidx + 1, sidx + 3), 16);
                    if (ch < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParseException(str.substring(sidx, sidx + 3) + " is an invalid code");
                }
                res[didx] = (char)ch;
                sidx += 2;
            } else {
                res[didx] = buf[sidx];
            }
            ++sidx;
            ++didx;
        }
        return new String(res, 0, didx);
    }

    private static final String unescapeNoPE(String str) {
        try {
            return HttpClientURI.unescape(str);
        }
        catch (ParseException pe) {
            return str;
        }
    }

    public static void main(String[] args) throws Exception {
        System.err.println();
        System.err.println("*** URI Tests ...");
        HttpClientURI base = new HttpClientURI("http://a/b/c/d;p?q");
        HttpClientURI.testParser(base, "g:h", "g:h");
        HttpClientURI.testParser(base, "g", "http://a/b/c/g");
        HttpClientURI.testParser(base, "./g", "http://a/b/c/g");
        HttpClientURI.testParser(base, "g/", "http://a/b/c/g/");
        HttpClientURI.testParser(base, "/g", "http://a/g");
        HttpClientURI.testParser(base, "//g", "http://g");
        HttpClientURI.testParser(base, "?y", "http://a/b/c/?y");
        HttpClientURI.testParser(base, "g?y", "http://a/b/c/g?y");
        HttpClientURI.testParser(base, "g?y", "http://a/b/c/g?y");
        HttpClientURI.testParser(base, "#s", "http://a/b/c/d;p?q#s");
        HttpClientURI.testParser(base, "g#s", "http://a/b/c/g#s");
        HttpClientURI.testParser(base, "g?y#s", "http://a/b/c/g?y#s");
        HttpClientURI.testParser(base, ";x", "http://a/b/c/;x");
        HttpClientURI.testParser(base, "g;x", "http://a/b/c/g;x");
        HttpClientURI.testParser(base, "g;x?y#s", "http://a/b/c/g;x?y#s");
        HttpClientURI.testParser(base, ".", "http://a/b/c/");
        HttpClientURI.testParser(base, "./", "http://a/b/c/");
        HttpClientURI.testParser(base, "..", "http://a/b/");
        HttpClientURI.testParser(base, "../", "http://a/b/");
        HttpClientURI.testParser(base, "../g", "http://a/b/g");
        HttpClientURI.testParser(base, "../..", "http://a/");
        HttpClientURI.testParser(base, "../../", "http://a/");
        HttpClientURI.testParser(base, "../../g", "http://a/g");
        HttpClientURI.testParser(base, "", "http://a/b/c/d;p?q");
        HttpClientURI.testParser(base, "/./g", "http://a/./g");
        HttpClientURI.testParser(base, "/../g", "http://a/../g");
        HttpClientURI.testParser(base, "g.", "http://a/b/c/g.");
        HttpClientURI.testParser(base, ".g", "http://a/b/c/.g");
        HttpClientURI.testParser(base, "g..", "http://a/b/c/g..");
        HttpClientURI.testParser(base, "..g", "http://a/b/c/..g");
        HttpClientURI.testParser(base, "./../g", "http://a/b/g");
        HttpClientURI.testParser(base, "./g/.", "http://a/b/c/g/");
        HttpClientURI.testParser(base, "g/./h", "http://a/b/c/g/h");
        HttpClientURI.testParser(base, "g/../h", "http://a/b/c/h");
        HttpClientURI.testParser(base, "g;x=1/./y", "http://a/b/c/g;x=1/y");
        HttpClientURI.testParser(base, "g;x=1/../y", "http://a/b/c/y");
        HttpClientURI.testParser(base, "g?y/./x", "http://a/b/c/g?y/./x");
        HttpClientURI.testParser(base, "g?y/../x", "http://a/b/c/g?y/../x");
        HttpClientURI.testParser(base, "g#s/./x", "http://a/b/c/g#s/./x");
        HttpClientURI.testParser(base, "g#s/../x", "http://a/b/c/g#s/../x");
        HttpClientURI.testParser(base, "http:g", "http:g");
        HttpClientURI.testNotEqual("http://a/", "nntp://a/");
        HttpClientURI.testNotEqual("http://a/", "https://a/");
        HttpClientURI.testNotEqual("http://a/", "shttp://a/");
        HttpClientURI.testEqual("http://a/", "Http://a/");
        HttpClientURI.testEqual("http://a/", "hTTP://a/");
        HttpClientURI.testEqual("url:http://a/", "hTTP://a/");
        HttpClientURI.testEqual("urI:http://a/", "hTTP://a/");
        HttpClientURI.testEqual("http://a/", "Http://A/");
        HttpClientURI.testEqual("http://a.b.c/", "Http://A.b.C/");
        HttpClientURI.testEqual("http:///", "Http:///");
        HttpClientURI.testNotEqual("http:///", "Http://a/");
        HttpClientURI.testEqual("http://a.b.c/", "Http://A.b.C:80/");
        HttpClientURI.testEqual("nntp://a", "nntp://a:119");
        HttpClientURI.testEqual("nntp://a/", "nntp://a:119/");
        HttpClientURI.testNotEqual("nntp://a", "nntp://a:118");
        HttpClientURI.testNotEqual("nntp://a", "nntp://a:0");
        HttpClientURI.testEqual("telnet://:23/", "telnet:///");
        HttpClientURI.testPE("ftp://:a/");
        HttpClientURI.testPE("ftp://:-1/");
        HttpClientURI.testPE("ftp://::1/");
        HttpClientURI.testNotEqual("ftp://me@a", "ftp://a");
        HttpClientURI.testNotEqual("ftp://me@a", "ftp://Me@a");
        HttpClientURI.testEqual("ftp://Me@a", "ftp://Me@a");
        HttpClientURI.testEqual("ftp://Me:My@a:21", "ftp://Me:My@a");
        HttpClientURI.testNotEqual("ftp://Me:My@a:21", "ftp://Me:my@a");
        HttpClientURI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        HttpClientURI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        HttpClientURI.testEqual("ftp://a/b%5E/", "ftp://a/b^/");
        HttpClientURI.testNotEqual("ftp://a/b%3f/", "ftp://a/b?/");
        System.err.println("*** Tests finished successfuly");
    }

    private static void testParser(HttpClientURI base, String relURI, String result) throws Exception {
        if (!new HttpClientURI(base, relURI).toString().equals(result)) {
            String nl = System.getProperty("line.separator");
            throw new Exception("Test failed: " + nl + "  base-URI = <" + base + ">" + nl + "  rel-URI  = <" + relURI + ">" + nl + "  expected   <" + result + ">" + nl + "  but got    <" + new HttpClientURI(base, relURI) + ">");
        }
    }

    private static void testEqual(String one, String two) throws Exception {
        if (!new HttpClientURI(one).equals(new HttpClientURI(two))) {
            String nl = System.getProperty("line.separator");
            throw new Exception("Test failed: " + nl + "  <" + one + "> != <" + two + ">");
        }
    }

    private static void testNotEqual(String one, String two) throws Exception {
        if (new HttpClientURI(one).equals(new HttpClientURI(two))) {
            String nl = System.getProperty("line.separator");
            throw new Exception("Test failed: " + nl + "  <" + one + "> == <" + two + ">");
        }
    }

    private static void testPE(String uri) throws Exception {
        boolean got_pe = false;
        try {
            new HttpClientURI(uri);
        }
        catch (ParseException pe) {
            got_pe = true;
        }
        if (!got_pe) {
            String nl = System.getProperty("line.separator");
            throw new Exception("Test failed: " + nl + "  <" + uri + "> should be invalid");
        }
    }

    static {
        int ch;
        alphanumChar = new BitSet(128);
        for (ch = 48; ch <= 57; ++ch) {
            alphanumChar.set(ch);
        }
        for (ch = 65; ch <= 90; ++ch) {
            alphanumChar.set(ch);
        }
        for (ch = 97; ch <= 122; ++ch) {
            alphanumChar.set(ch);
        }
        markChar = new BitSet(128);
        markChar.set(45);
        markChar.set(95);
        markChar.set(46);
        markChar.set(33);
        markChar.set(126);
        markChar.set(42);
        markChar.set(39);
        markChar.set(40);
        markChar.set(41);
        reservedChar = new BitSet(128);
        reservedChar.set(59);
        reservedChar.set(47);
        reservedChar.set(63);
        reservedChar.set(58);
        reservedChar.set(64);
        reservedChar.set(38);
        reservedChar.set(61);
        reservedChar.set(43);
        reservedChar.set(36);
        reservedChar.set(44);
        unreservedChar = new BitSet(128);
        unreservedChar.or(alphanumChar);
        unreservedChar.or(markChar);
        uricChar = new BitSet(128);
        uricChar.or(unreservedChar);
        uricChar.or(reservedChar);
        pcharChar = new BitSet(128);
        pcharChar.or(unreservedChar);
        pcharChar.set(58);
        pcharChar.set(64);
        pcharChar.set(38);
        pcharChar.set(61);
        pcharChar.set(43);
        pcharChar.set(36);
        pcharChar.set(44);
        userinfoChar = new BitSet(128);
        userinfoChar.or(unreservedChar);
        userinfoChar.set(59);
        userinfoChar.set(58);
        userinfoChar.set(38);
        userinfoChar.set(61);
        userinfoChar.set(43);
        userinfoChar.set(36);
        userinfoChar.set(44);
        schemeChar = new BitSet(128);
        schemeChar.or(alphanumChar);
        schemeChar.set(43);
        schemeChar.set(45);
        schemeChar.set(46);
        reg_nameChar = new BitSet(128);
        reg_nameChar.or(unreservedChar);
        reg_nameChar.set(36);
        reg_nameChar.set(44);
        reg_nameChar.set(59);
        reg_nameChar.set(58);
        reg_nameChar.set(64);
        reg_nameChar.set(38);
        reg_nameChar.set(61);
        reg_nameChar.set(43);
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

