/*
 * Decompiled with CFR 0.152.
 */
package logging;

import logging.ILog;
import logging.LogLevel;
import logging.LogType;

public abstract class AbstractLog
implements ILog {
    private int m_logLevel;
    private int m_logType;

    public AbstractLog() {
        this(7, LogType.ALL);
    }

    public AbstractLog(int a_logLevel, int a_logType) {
        this.m_logLevel = a_logLevel;
        this.m_logType = a_logType;
    }

    public boolean isLogged(int a_logLevel, int a_logType) {
        return AbstractLog.isLogged(this, a_logLevel, a_logType);
    }

    public static boolean isLogged(ILog a_logInstance, int a_logLevel, int a_logType) {
        return a_logLevel <= a_logInstance.getLogLevel() && (a_logType & a_logInstance.getLogType()) == a_logType;
    }

    public void setLogLevel(int a_logLevel) {
        if (a_logLevel >= 0 && a_logLevel < LogLevel.getLevelCount()) {
            this.m_logLevel = a_logLevel;
        }
    }

    public void setLogType(int a_logType) {
        this.m_logType = a_logType;
    }

    public int getLogType() {
        return this.m_logType;
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public abstract void log(int var1, int var2, String var3);
}

