/*
 * Decompiled with CFR 0.152.
 */
package infoservice.japforwarding;

import anon.crypto.MyAES;
import anon.crypto.MyRandom;
import anon.infoservice.AbstractDatabaseEntry;
import anon.util.Base64;
import anon.util.XMLUtil;
import captcha.CaptchaGeneratorFactory;
import captcha.ICaptchaGenerator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.SecureRandom;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForwarderDBEntry
extends AbstractDatabaseEntry {
    private static final int CAPTCHA_KEY_BITS = 48;
    private static final int EXTRA_KEY_BITS = 16;
    private InetAddress m_forwarderAddress;
    private int m_forwarderPort;
    private byte[] m_forwarderData;
    private String m_id;
    private long m_creationTimeStamp = System.currentTimeMillis();

    public ForwarderDBEntry(InetAddress a_forwarderAddress, int a_forwarderPort) throws Exception {
        super(System.currentTimeMillis() + 900000L);
        this.m_forwarderAddress = a_forwarderAddress;
        this.m_forwarderPort = a_forwarderPort;
        this.m_forwarderData = new byte[16];
        for (int i = 0; i < 10; ++i) {
            this.m_forwarderData[i] = 0;
        }
        System.arraycopy(this.m_forwarderAddress.getAddress(), 0, this.m_forwarderData, 10, 4);
        ByteArrayOutputStream transformerOut = new ByteArrayOutputStream(4);
        DataOutputStream transformer = new DataOutputStream(transformerOut);
        transformer.writeInt(a_forwarderPort);
        transformer.flush();
        transformerOut.flush();
        System.arraycopy(transformerOut.toByteArray(), 2, this.m_forwarderData, 14, 2);
        transformer.close();
        byte[] randomId = new byte[16];
        new SecureRandom().nextBytes(randomId);
        this.m_id = Base64.encode(randomId, false);
    }

    private ForwarderDBEntry(InetAddress a_forwarderAddress, int a_forwarderPort, byte[] a_forwarderData, String a_id) {
        super(System.currentTimeMillis() + 900000L);
        this.m_forwarderAddress = a_forwarderAddress;
        this.m_forwarderPort = a_forwarderPort;
        this.m_forwarderData = a_forwarderData;
        this.m_id = a_id;
    }

    public ForwarderDBEntry getUpdateClone() {
        return new ForwarderDBEntry(this.m_forwarderAddress, this.m_forwarderPort, this.m_forwarderData, this.m_id);
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public long getLastUpdate() {
        return this.m_creationTimeStamp;
    }

    @Override
    public long getVersionNumber() {
        return this.m_creationTimeStamp;
    }

    public Element createCaptchaNode() throws Exception {
        ICaptchaGenerator captchaGenerator = CaptchaGeneratorFactory.getInstance().getCaptchaGenerator();
        String captchaCharacters = captchaGenerator.getValidCharacters();
        float bitsPerCharacter = (float)(Math.log(captchaCharacters.length()) / Math.log(2.0));
        int neededCharacters = Math.min(Math.round(48.0f / bitsPerCharacter), captchaGenerator.getMaximumStringLength());
        String captchaString = "";
        BigInteger alphabetSize = new BigInteger(Integer.toString(captchaCharacters.length()));
        BigInteger optimalEncoding = new BigInteger("0");
        for (int i = 0; i < neededCharacters; ++i) {
            int characterPosition = new MyRandom().nextInt(captchaCharacters.length());
            captchaString = captchaString + captchaCharacters.substring(characterPosition, characterPosition + 1);
            BigInteger currentCharacter = new BigInteger(Integer.toString(characterPosition));
            optimalEncoding = optimalEncoding.multiply(alphabetSize).add(currentCharacter);
        }
        byte[] captchaKey = new byte[6];
        for (int i = 0; i < captchaKey.length; ++i) {
            captchaKey[i] = 0;
        }
        byte[] optimalData = optimalEncoding.toByteArray();
        int usedCaptchaKeyBits = Math.min(captchaKey.length, optimalData.length);
        System.arraycopy(optimalData, optimalData.length - usedCaptchaKeyBits, captchaKey, captchaKey.length - usedCaptchaKeyBits, usedCaptchaKeyBits);
        byte[] extraKey = null;
        extraKey = new byte[2];
        new SecureRandom().nextBytes(extraKey);
        byte[] finalKey = new byte[16];
        for (int i = 0; i < finalKey.length; ++i) {
            finalKey[i] = 0;
        }
        System.arraycopy(captchaKey, 0, finalKey, finalKey.length - captchaKey.length, captchaKey.length);
        System.arraycopy(extraKey, 0, finalKey, finalKey.length - captchaKey.length - extraKey.length, extraKey.length);
        MyAES aes = new MyAES();
        aes.init(true, finalKey);
        byte[] cipheredForwarderData = aes.processBlockECB(this.m_forwarderData);
        String cipheredForwarder = Base64.encode(cipheredForwarderData, false);
        String captchaData = captchaGenerator.createCaptcha(captchaString);
        Document doc = XMLUtil.createDocument();
        Element japForwarderNode = doc.createElement("JapForwarder");
        Element captchaEncodedNode = doc.createElement("CaptchaEncoded");
        Element captchaKeyBitsNode = doc.createElement("CaptchaKeyBits");
        captchaKeyBitsNode.appendChild(doc.createTextNode(Integer.toString(48)));
        captchaEncodedNode.appendChild(captchaKeyBitsNode);
        Element extraKeyBitsNode = doc.createElement("ExtraKeyBits");
        extraKeyBitsNode.appendChild(doc.createTextNode(Integer.toString(16)));
        captchaEncodedNode.appendChild(extraKeyBitsNode);
        Element captchaCharactersNode = doc.createElement("CaptchaCharacters");
        captchaCharactersNode.appendChild(doc.createTextNode(captchaCharacters));
        captchaEncodedNode.appendChild(captchaCharactersNode);
        Element captchaCharacterNumberNode = doc.createElement("CaptchaCharacterNumber");
        captchaCharacterNumberNode.appendChild(doc.createTextNode(Integer.toString(neededCharacters)));
        captchaEncodedNode.appendChild(captchaCharacterNumberNode);
        Element captchaDataFormatNode = doc.createElement("CaptchaDataFormat");
        captchaDataFormatNode.appendChild(doc.createTextNode(captchaGenerator.getCaptchaDataFormat()));
        captchaEncodedNode.appendChild(captchaDataFormatNode);
        Element captchaDataNode = doc.createElement("CaptchaData");
        captchaDataNode.appendChild(doc.createTextNode(captchaData));
        captchaEncodedNode.appendChild(captchaDataNode);
        Element forwarderCipherNode = doc.createElement("DataCipher");
        forwarderCipherNode.appendChild(doc.createTextNode(cipheredForwarder));
        captchaEncodedNode.appendChild(forwarderCipherNode);
        forwarderCipherNode = doc.createElement("ForwarderCipher");
        forwarderCipherNode.appendChild(doc.createTextNode(cipheredForwarder));
        captchaEncodedNode.appendChild(forwarderCipherNode);
        japForwarderNode.appendChild(captchaEncodedNode);
        return japForwarderNode;
    }
}

