/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import anon.infoservice.Database;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.HttpResponseStructure;
import anon.infoservice.IDistributable;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.ServiceSoftware;
import infoservice.Configuration;
import infoservice.InfoServiceDistributor;
import infoservice.agreement.IInfoServiceAgreementAdapter;
import infoservice.agreement.common.FifoQueue;
import infoservice.agreement.logging.AgreementFileLog;
import infoservice.agreement.multicast.AbstractEMCAdapter;
import infoservice.agreement.multicast.EchoMulticastAgreementHandlerImpl;
import infoservice.agreement.multicast.MessageHandlerThread;
import infoservice.agreement.multicast.interfaces.IAgreementMessage;
import infoservice.agreement.multicast.messages.RawMessage;
import infoservice.dynamic.DynamicCascadeConfigurator;
import infoservice.dynamic.VirtualCascade;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class InfoserviceEMCAdapter
extends AbstractEMCAdapter
implements IInfoServiceAgreementAdapter {
    private DynamicCascadeConfigurator m_dynamicMixConfigurator = new DynamicCascadeConfigurator();
    protected int m_numberOfAllActiveInfoservices = 0;
    Hashtable m_infoServiceSnapshot = new Hashtable();
    private FifoQueue m_queue = new FifoQueue();
    InfoServiceDBEntry m_self = this.generateInfoServiceSelf();
    protected Thread m_agreementStarter = null;
    private MessageHandlerThread m_messageHandler;

    InfoServiceDBEntry generateInfoServiceSelf() {
        Vector<ListenerInterface> virtualListeners = Configuration.getInstance().getVirtualListeners();
        return new InfoServiceDBEntry(Configuration.getInstance().getOwnName(), Configuration.getInstance().getID(), virtualListeners, Configuration.getInstance().holdForwarderList(), false, System.currentTimeMillis(), System.currentTimeMillis(), Configuration.getInstance().isPerfServerEnabled(), new ServiceSoftware("IS.09.010"));
    }

    public InfoserviceEMCAdapter() {
        super(new AgreementFileLog());
        this.setIAgreementHandler(new EchoMulticastAgreementHandlerImpl(this));
        new Thread("InfoServiceEMCAdapter"){

            @Override
            public void run() {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    InfoserviceEMCAdapter.this.error("Unable to sleep in thread");
                }
                InfoserviceEMCAdapter.this.evangelizeThisInfoservice();
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    InfoserviceEMCAdapter.this.error("Unable to sleep in thread");
                }
                InfoserviceEMCAdapter.this.startAdapter();
            }
        }.start();
    }

    protected void evangelizeThisInfoservice() {
        InfoServiceDBEntry generatedOwnEntry = this.generateInfoServiceSelf();
        Database.getInstance(InfoServiceDBEntry.class).update(generatedOwnEntry);
        InfoServiceDistributor.getInstance().addJobToInititalNeighboursQueue(generatedOwnEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponseStructure handleMessage(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        RawMessage msg = new RawMessage(a_postData);
        FifoQueue fifoQueue = this.m_queue;
        synchronized (fifoQueue) {
            this.m_queue.push(msg);
            this.m_queue.notify();
        }
        return httpResponse;
    }

    @Override
    protected void buildCascades(long l) {
        this.m_dynamicMixConfigurator.buildCascades(l);
    }

    @Override
    protected void prepareStart() {
        Enumeration en = Database.getInstance(InfoServiceDBEntry.class).getEntrySnapshotAsEnumeration();
        this.info("MY OWN ID is " + this.m_self.getId());
        while (en.hasMoreElements()) {
            InfoServiceDBEntry entry = (InfoServiceDBEntry)en.nextElement();
            if (!entry.checkId() && !this.m_self.equals(entry)) {
                this.info("Discarting " + entry.getId() + " because its a dummy");
                Database.getInstance(InfoServiceDBEntry.class).remove(entry);
                continue;
            }
            this.info("Using InfoService " + entry.getId());
        }
        Enumeration enInfoServices = Database.getInstance(InfoServiceDBEntry.class).getEntrySnapshotAsEnumeration();
        while (enInfoServices.hasMoreElements()) {
            InfoServiceDBEntry current = (InfoServiceDBEntry)enInfoServices.nextElement();
            this.m_infoServiceSnapshot.put(current.getId(), current);
        }
        this.m_numberOfAllActiveInfoservices = this.m_infoServiceSnapshot.size();
        if (this.m_messageHandler == null) {
            throw new NullPointerException(this.getClass().getName() + ": Message is null. Can't start agreement!");
        }
        this.m_messageHandler.start();
        Database.getInstance(VirtualCascade.class).removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startListening() {
        if (this.m_messageHandler != null) {
            FifoQueue fifoQueue = this.m_queue;
            synchronized (fifoQueue) {
                this.m_messageHandler.setRunning(false);
                this.m_queue.notify();
            }
        }
        this.m_messageHandler = new MessageHandlerThread(this, this.m_queue);
    }

    @Override
    public int getNumberOfAllInfoservices() {
        return this.m_numberOfAllActiveInfoservices;
    }

    @Override
    public String getIdentifier() {
        return this.m_self.getId();
    }

    @Override
    public void sendMessageTo(final String a_id, final IAgreementMessage a_message) {
        if (a_id.equals(this.m_self.getId())) {
            return;
        }
        new Thread("InfoServiceEMCAdapter - sendMessageTo()"){

            @Override
            public void run() {
                InfoserviceEMCAdapter.this.sendToInfoService((InfoServiceDBEntry)InfoserviceEMCAdapter.this.m_infoServiceSnapshot.get(a_id), a_message);
            }
        }.start();
    }

    @Override
    public void multicastMessage(final IAgreementMessage a_message) {
        Enumeration infoServices = this.m_infoServiceSnapshot.elements();
        while (infoServices.hasMoreElements()) {
            final InfoServiceDBEntry entry = (InfoServiceDBEntry)infoServices.nextElement();
            if (entry.getId().equals(this.m_self.getId())) continue;
            new Thread("InfoServiceEMCAdapter - multicastMessage"){

                @Override
                public void run() {
                    InfoserviceEMCAdapter.this.sendToInfoService(entry, a_message);
                }
            }.start();
        }
    }

    boolean sendToInfoService(InfoServiceDBEntry a_infoservice, IDistributable a_message) {
        boolean connected = false;
        if (a_infoservice == null) {
            return false;
        }
        Enumeration enumer = a_infoservice.getListenerInterfaces().elements();
        while (enumer.hasMoreElements() && !connected) {
            ListenerInterface currentInterface = (ListenerInterface)enumer.nextElement();
            if (!currentInterface.isValid()) continue;
            if (this.sendToInterface(currentInterface, a_message)) {
                connected = true;
                continue;
            }
            currentInterface.setUseInterface(false);
        }
        return connected;
    }

    private boolean sendToInterface(ListenerInterface a_listener, IDistributable a_message) {
        boolean connected = true;
        HTTPConnection connection = null;
        try {
            connection = HTTPConnectionFactory.getInstance().createHTTPConnection(a_listener, a_message.getPostEncoding(), false);
            HTTPResponse response = connection.Post(a_message.getPostFile(), a_message.getPostData());
            int statusCode = response.getStatusCode();
            connected = statusCode >= 200 && statusCode <= 299;
        }
        catch (Exception e) {
            LogHolder.log(0, LogType.NET, "ERROR WHILE SENDING TO " + connection.getHost() + ":" + connection.getPort() + ": " + e.toString());
            connected = false;
        }
        if (connection != null) {
            connection.stop();
        }
        return connected;
    }
}

