/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.crypto.JAPCertificate;
import anon.crypto.PKCS12;
import anon.crypto.SignatureCreator;
import anon.crypto.SignatureVerifier;
import anon.crypto.X509SubjectKeyIdentifier;
import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.JAPMinVersion;
import anon.infoservice.ListenerInterface;
import anon.util.XMLUtil;
import infoservice.CertificateManager;
import infoservice.InfoServiceLog;
import infoservice.UpdateInformationHandler;
import infoservice.dynamic.DynamicConfiguration;
import infoservice.tor.MixminionDirectoryAgent;
import infoservice.tor.TorDirectoryAgent;
import infoservice.tor.TorDirectoryServer;
import infoservice.tor.TorDirectoryServerUrl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;

public final class Configuration {
    private static Configuration configurationInstance = null;
    private Vector m_initialNeighbourInfoServices;
    private Vector<ListenerInterface> m_hardwareListenerList;
    private Vector<ListenerInterface> m_virtualListenerList;
    private Vector m_hostList;
    private String m_strOwnName;
    private String m_strID;
    private int m_iMaxPostContentLength;
    private boolean m_bStatusStatisticsEnabled;
    private long m_lStatusStatisticsInterval;
    private String m_strStatusStatisticsLogDir;
    private String m_strProxyAddresses;
    private static SimpleDateFormat ms_httpDateFormat;
    private boolean m_bRootOfUpdateInformation;
    private String m_strJapReleaseJnlpFile;
    private String m_strJapDevelopmentJnlpFile;
    private File m_strJavaLatestVersionFile;
    private File m_messageFile;
    private String m_strJapMinVersionFile;
    private JAPMinVersion m_japMinVersionOld;
    private double m_dJapUpdatePropability;
    private Date m_startupTime;
    private boolean m_holdForwarderList;
    private int m_NrOfThreads;
    private boolean m_bPerfEnabled;
    private boolean m_bPassive;
    private String m_lastPassword = "";
    private final Object[] m_aPerfMeterConf = new Object[7];
    private boolean m_bPerfServerEnabled;
    private File m_strPerfAccountDirectory = null;
    private String m_strPerfAccountPassword = null;
    private Vector m_perfBlackList = new Vector();
    private Vector m_perfWhiteList = new Vector();
    public static final String IS_PROP_NAME_PERFORMANCE_MONITORING = "perf";
    public static final String IS_PROP_NAME_PERFACCOUNT = "perf.account";
    public static final String IS_PROP_NAME_BLACKLIST = "perf.blackList";
    public static final String IS_PROP_NAME_WHITELIST = "perf.whiteList";
    public static final String PROP_MAX_TEST_TIME = "perf.maxTestTime";
    public static final String IS_PROP_NAME_PERFACCOUNT_DIRECTORY = "perf.account.directory";
    public static final String IS_PROP_VALUE_PERFACCOUNT_DIRECTORY = "accounts";
    public static final String IS_PROP_NAME_PERFACCOUNT_PASSWORD = "perf.account.passw";
    public static final String IS_PROP_VALUE_PERFACCOUNT_PASSWORD;
    public static final String IS_PROP_NAME_PERF_SERVER = "perf.server";
    public static final String IS_PROP_VALUE_PERF_SERVER = "true";
    public static final String IS_PROP_VALUE_TERMS_AND_CONDITIONS_DIR = "terms";

    public static Configuration getInstance() {
        return configurationInstance;
    }

    public Configuration(Properties a_properties, String strPasswd) throws Exception {
        Properties systemProperties = System.getProperties();
        systemProperties.put("java.awt.headless", IS_PROP_VALUE_PERF_SERVER);
        System.setProperties(systemProperties);
        configurationInstance = this;
        this.m_startupTime = new Date();
        try {
            boolean fetchTorNodesList;
            String b;
            LogHolder.setLogInstance(new InfoServiceLog(a_properties));
            LogHolder.setDetailLevel(Integer.parseInt(a_properties.getProperty("messageDetailLevel", "0").trim()));
            this.m_strOwnName = a_properties.getProperty("ownname").trim();
            this.m_iMaxPostContentLength = Integer.parseInt(a_properties.getProperty("maxPOSTContentLength").trim());
            String strHardwareListeners = a_properties.getProperty("HardwareListeners").trim();
            String strVirtualListeners = a_properties.getProperty("VirtualListeners");
            StringTokenizer stHardware = new StringTokenizer(strHardwareListeners, ",");
            this.m_hostList = new Vector();
            this.m_hardwareListenerList = new Vector();
            while (stHardware.hasMoreTokens()) {
                ListenerInterface iface = new ListenerInterface(stHardware.nextToken());
                this.m_hardwareListenerList.addElement(iface);
                if (iface == null || this.m_hostList.contains(iface.getHost())) continue;
                this.m_hostList.addElement(iface.getHost());
            }
            if (strVirtualListeners != null) {
                this.m_virtualListenerList = new Vector();
                StringTokenizer stVirtual = new StringTokenizer(strVirtualListeners.trim(), ",");
                while (stVirtual.hasMoreTokens()) {
                    ListenerInterface iface = new ListenerInterface(stVirtual.nextToken());
                    this.m_virtualListenerList.addElement(iface);
                    if (iface == null || this.m_hostList.contains(iface.getHost())) continue;
                    this.m_hostList.addElement(iface.getHost());
                }
            } else {
                this.m_virtualListenerList = (Vector)this.m_hardwareListenerList.clone();
            }
            this.m_strProxyAddresses = a_properties.getProperty("proxyAddresses").trim();
            String privatePkcs12KeyFile = a_properties.getProperty("privateKeyFile");
            PKCS12 infoServiceMessagesPrivateKey = null;
            if (privatePkcs12KeyFile != null && !privatePkcs12KeyFile.trim().equals("")) {
                privatePkcs12KeyFile = privatePkcs12KeyFile.trim();
                try {
                    do {
                        if ((infoServiceMessagesPrivateKey = this.loadPkcs12PrivateKey(privatePkcs12KeyFile, this.m_lastPassword)) != null) continue;
                        if (strPasswd == null) {
                            System.out.println("Cannot load private key! Enter password for private key from file: " + privatePkcs12KeyFile);
                            System.out.print("Password: ");
                            BufferedReader passwordReader = new BufferedReader(new InputStreamReader(System.in));
                            this.m_lastPassword = passwordReader.readLine();
                            continue;
                        }
                        this.m_lastPassword = strPasswd;
                        strPasswd = null;
                    } while (infoServiceMessagesPrivateKey == null);
                    SignatureCreator.getInstance().setSigningKey(2, infoServiceMessagesPrivateKey);
                    this.m_strID = new X509SubjectKeyIdentifier(infoServiceMessagesPrivateKey.getPublicKey()).getValueWithoutColon();
                }
                catch (FileNotFoundException e) {
                    System.out.println("Cannot find the private key file: " + privatePkcs12KeyFile);
                    System.out.println("Exiting...");
                    throw e;
                }
            } else {
                LogHolder.log(4, LogType.MISC, "No private key for signing the own infoservice entry specified. Unsigned messages will be sent.");
            }
            SignatureVerifier.getInstance().setCheckSignatures(true);
            String checkSignatures = a_properties.getProperty("checkSignatures");
            if (checkSignatures != null && checkSignatures.equalsIgnoreCase("false")) {
                SignatureVerifier.getInstance().setCheckSignatures(false);
                LogHolder.log(4, LogType.MISC, "Disabling signature verification for all documents.");
            }
            LogHolder.log(7, LogType.MISC, "Loading certificates...");
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedRootCertificateFiles", 1, "mix root", true);
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedInfoServiceRootCertificateFiles", 5, "infoservice root", true);
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedInfoServiceCertificateFiles", 3, "infoservice", false);
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedMixCertificateFiles", 2, "mix", false);
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedUpdateCertificateFiles", 4, "update", true);
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedTermsCertificateFiles", 9, "terms and conditions", true);
            Configuration.loadTrustedCertificateFiles(a_properties, "trustedPICertificateFiles", 7, "PI", true);
            SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(infoServiceMessagesPrivateKey.getX509Certificate(), 3, true, true);
            try {
                b = a_properties.getProperty("checkInfoServiceSignatures").trim();
                if (b.equalsIgnoreCase("false")) {
                    SignatureVerifier.getInstance().setCheckSignatures(2, false);
                }
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Could not read 'checkInfoServiceSignatures' setting - default to: " + SignatureVerifier.getInstance().isCheckSignatures(2));
            }
            try {
                b = a_properties.getProperty("checkMixSignatures").trim();
                if (b.equalsIgnoreCase("false")) {
                    SignatureVerifier.getInstance().setCheckSignatures(1, false);
                }
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Could not read 'checkMixSignatures' setting - default to: " + SignatureVerifier.getInstance().isCheckSignatures(1));
            }
            try {
                b = a_properties.getProperty("checkUpdateSignatures").trim();
                if (b.equalsIgnoreCase("false")) {
                    SignatureVerifier.getInstance().setCheckSignatures(3, false);
                }
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Could not read 'checkUpdateSignatures' setting - default to: " + SignatureVerifier.getInstance().isCheckSignatures(3));
            }
            new CertificateManager();
            this.m_bRootOfUpdateInformation = a_properties.getProperty("rootOfUpdateInformation").trim().equalsIgnoreCase(IS_PROP_VALUE_PERF_SERVER);
            if (this.m_bRootOfUpdateInformation) {
                this.m_strJapReleaseJnlpFile = a_properties.getProperty("japReleaseFileName");
                if (this.m_strJapReleaseJnlpFile != null) {
                    this.m_strJapReleaseJnlpFile.trim();
                }
                this.m_strJapDevelopmentJnlpFile = a_properties.getProperty("japDevelopmentFileName");
                if (this.m_strJapDevelopmentJnlpFile != null) {
                    this.m_strJapDevelopmentJnlpFile.trim();
                }
                this.m_strJapMinVersionFile = a_properties.getProperty("japMinVersionFileName");
                if (this.m_strJapMinVersionFile != null) {
                    this.m_strJapMinVersionFile.trim();
                }
                try {
                    this.m_dJapUpdatePropability = Math.min(1.0, Double.parseDouble(a_properties.getProperty("japUpdatePropability").trim()));
                    this.m_dJapUpdatePropability = Math.max(0.0, this.m_dJapUpdatePropability);
                }
                catch (Throwable t) {
                    this.m_dJapUpdatePropability = 1.0;
                }
                try {
                    this.m_strJavaLatestVersionFile = new File(a_properties.getProperty("jreVersionsFileName").trim());
                }
                catch (Exception a_e) {
                    LogHolder.log(4, LogType.MISC, "Could not load Java version information!");
                }
                try {
                    this.m_messageFile = new File(a_properties.getProperty("messageFileName").trim());
                }
                catch (Exception a_e) {
                    LogHolder.log(4, LogType.MISC, "Could not load message information!");
                }
                String updatePkcs12KeyFile = a_properties.getProperty("updateInformationPrivateKey");
                if (updatePkcs12KeyFile != null && !updatePkcs12KeyFile.trim().equals("")) {
                    updatePkcs12KeyFile = updatePkcs12KeyFile.trim();
                    PKCS12 updateMessagesPrivateKey = null;
                    try {
                        String lastPassword = "";
                        do {
                            if ((updateMessagesPrivateKey = this.loadPkcs12PrivateKey(updatePkcs12KeyFile, lastPassword)) != null) continue;
                            System.out.println("Cannot load private key! Enter password for private key from file: " + updatePkcs12KeyFile);
                            System.out.print("Password: ");
                            BufferedReader passwordReader = new BufferedReader(new InputStreamReader(System.in));
                            lastPassword = passwordReader.readLine();
                        } while (updateMessagesPrivateKey == null);
                        SignatureCreator.getInstance().setSigningKey(3, updateMessagesPrivateKey);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Cannot find the private key file: " + updatePkcs12KeyFile);
                        System.out.println("Exiting...");
                        throw e;
                    }
                } else {
                    LogHolder.log(4, LogType.MISC, "No private key for signing the update messages specified. Unsigned messages will be sent.");
                }
                String strJapMinVersionOldFile = a_properties.getProperty("japMinVersionFileNameOld");
                if (strJapMinVersionOldFile != null) {
                    try {
                        File fileJapMinVersionOld = new File(strJapMinVersionOldFile.trim());
                        Document docMinVersion = XMLUtil.readXMLDocument(fileJapMinVersionOld);
                        SignatureCreator.getInstance().signXml(3, docMinVersion);
                        this.m_japMinVersionOld = new JAPMinVersion(docMinVersion.getDocumentElement());
                    }
                    catch (Throwable t) {
                        this.m_japMinVersionOld = null;
                    }
                }
            } else {
                this.m_strJapReleaseJnlpFile = null;
                this.m_strJapDevelopmentJnlpFile = null;
                this.m_strJapMinVersionFile = null;
            }
            StringTokenizer stNeighbours = new StringTokenizer(a_properties.getProperty("neighbours", "").trim(), ",");
            this.m_initialNeighbourInfoServices = new Vector();
            while (stNeighbours.hasMoreTokens()) {
                try {
                    StringTokenizer stCurrentInterface = new StringTokenizer(stNeighbours.nextToken(), ":");
                    String inetHost = stCurrentInterface.nextToken();
                    int inetPort = Integer.parseInt(stCurrentInterface.nextToken());
                    this.m_initialNeighbourInfoServices.addElement(new ListenerInterface(inetHost, inetPort));
                }
                catch (Exception stCurrentInterface) {}
            }
            for (int i = 0; i < this.m_initialNeighbourInfoServices.size(); ++i) {
                InfoServiceDBEntry entry = new InfoServiceDBEntry(null, null, ((ListenerInterface)this.m_initialNeighbourInfoServices.elementAt(i)).toVector(), false, false, System.currentTimeMillis(), 0L, false, null);
                entry.markAsBootstrap();
                try {
                    InfoServiceDBEntry.class.getMethod("setNeighbour", Boolean.TYPE).invoke((Object)entry, new Boolean(true));
                }
                catch (Throwable a_e) {
                    LogHolder.log(2, LogType.MISC, a_e);
                }
                Database.getInstance(InfoServiceDBEntry.class).update(entry, false);
                LogHolder.log(7, LogType.MISC, "Added intial neighbour IS: " + entry.getId());
            }
            UpdateInformationHandler.getInstance();
            this.m_bStatusStatisticsEnabled = a_properties.getProperty("statusStatistics").trim().equalsIgnoreCase("enabled");
            this.m_lStatusStatisticsInterval = 3600000L;
            this.m_strStatusStatisticsLogDir = "";
            if (this.m_bStatusStatisticsEnabled) {
                long tempInterval = Long.parseLong(a_properties.getProperty("statusStatisticsInterval").trim()) * 60L * 1000L;
                if (tempInterval > 0L) {
                    this.m_lStatusStatisticsInterval = tempInterval;
                }
                this.m_strStatusStatisticsLogDir = a_properties.getProperty("statusStatisticsLogDir").trim();
            }
            if (fetchTorNodesList = a_properties.getProperty("fetchTorNodesList").trim().equalsIgnoreCase("enabled")) {
                long fetchTorNodesListInterval = 600000L;
                long tempInterval = Long.parseLong(a_properties.getProperty("fetchTorNodesListInterval").trim()) * 1000L;
                if (tempInterval > 0L) {
                    fetchTorNodesListInterval = tempInterval;
                }
                String torDirectoryServers = a_properties.getProperty("torDirectoryServers").trim();
                StringTokenizer stTorDirectoryServers = new StringTokenizer(torDirectoryServers, ",");
                while (stTorDirectoryServers.hasMoreTokens()) {
                    try {
                        URL torDirectoryServer = new URL(stTorDirectoryServers.nextToken().trim());
                        int torServerPort = torDirectoryServer.getPort();
                        if (torServerPort == -1) {
                            torServerPort = torDirectoryServer.getPort();
                        }
                        TorDirectoryAgent.getInstance().addTorDirectoryServer(new TorDirectoryServer(new TorDirectoryServerUrl(torDirectoryServer.getHost(), torServerPort, torDirectoryServer.getFile()), 31536000000000L, true));
                    }
                    catch (Exception torDirectoryServer) {}
                }
                TorDirectoryAgent.getInstance().startUpdateThread(fetchTorNodesListInterval);
            }
            String str = a_properties.getProperty("fetchMixminionNodesList");
            boolean fetchMixminionNodesList = false;
            if (str != null && str.trim().equalsIgnoreCase("enabled")) {
                fetchMixminionNodesList = true;
            }
            if (fetchMixminionNodesList) {
                long fetchMixminionNodesListInterval = 600000L;
                long tempInterval = Long.parseLong(a_properties.getProperty("fetchMixminionNodesListInterval").trim()) * 1000L;
                if (tempInterval > 0L) {
                    fetchMixminionNodesListInterval = tempInterval;
                }
                String mixminionDirectoryServers = a_properties.getProperty("mixminionDirectoryServers").trim();
                StringTokenizer stMixminionDirectoryServers = new StringTokenizer(mixminionDirectoryServers, ",");
                while (stMixminionDirectoryServers.hasMoreTokens()) {
                    try {
                        URL mixminionDirectoryServer = new URL(stMixminionDirectoryServers.nextToken().trim());
                        MixminionDirectoryAgent.getInstance().addDirectoryServer(mixminionDirectoryServer);
                    }
                    catch (Exception exception) {}
                }
                MixminionDirectoryAgent.getInstance().startUpdateThread(fetchMixminionNodesListInterval);
            }
            this.m_holdForwarderList = false;
            try {
                this.m_holdForwarderList = a_properties.getProperty("primaryForwarderList").trim().equalsIgnoreCase("enabled");
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Could not read 'primaryForwarderList' setting - default to: " + this.m_holdForwarderList);
            }
            ms_httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            ms_httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.m_NrOfThreads = 50;
            try {
                String b2 = a_properties.getProperty("maxNrOfConcurrentConnections").trim();
                this.m_NrOfThreads = Integer.parseInt(b2);
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Could not read 'maxNrOfConcurrentConnections' setting - default to: " + this.m_NrOfThreads);
            }
            if (Boolean.valueOf(a_properties.getProperty("enableDynamicConfiguration", "false")).booleanValue()) {
                try {
                    DynamicConfiguration.getInstance().readConfiguration(a_properties);
                }
                catch (Exception e2) {
                    System.err.println("Error reading the configuration information related to Dynamic Cascades");
                    System.err.println("Exception: " + e2.toString());
                }
            }
            this.m_bPassive = Boolean.valueOf(a_properties.getProperty("modePassive", "false"));
            this.m_bPerfEnabled = Boolean.valueOf(a_properties.getProperty(IS_PROP_NAME_PERFORMANCE_MONITORING, IS_PROP_VALUE_PERF_SERVER));
            if (this.m_bPerfEnabled) {
                String value = a_properties.getProperty("perf.proxyHost", "localhost");
                if (value != null) {
                    this.m_aPerfMeterConf[0] = value;
                }
                if ((value = a_properties.getProperty("perf.proxyPort", "4001")) != null) {
                    this.m_aPerfMeterConf[1] = Integer.valueOf(value);
                }
                if ((value = a_properties.getProperty("perf.dataSize", "200000")) != null) {
                    this.m_aPerfMeterConf[2] = new Integer(Math.min(0x100000, Integer.parseInt(value)));
                }
                if ((value = a_properties.getProperty("perf.majorInterval", "240000")) != null) {
                    this.m_aPerfMeterConf[3] = new Integer(Math.max(60000, Integer.parseInt(value)));
                }
                if ((value = a_properties.getProperty("perf.requestsPerInterval", "1")) != null) {
                    this.m_aPerfMeterConf[4] = Integer.valueOf(value);
                }
                if ((value = a_properties.getProperty("perf.maxWaitForSingleTest", "50000")) != null) {
                    this.m_aPerfMeterConf[5] = new Integer(Math.max(5000, Integer.parseInt(value)));
                }
                if ((value = a_properties.getProperty("perf.maxConnectionErrorsPerRequest", "4")) != null) {
                    this.m_aPerfMeterConf[6] = Integer.valueOf(value);
                }
                this.m_strPerfAccountDirectory = new File(a_properties.getProperty(IS_PROP_NAME_PERFACCOUNT_DIRECTORY, IS_PROP_VALUE_PERFACCOUNT_DIRECTORY));
                this.m_strPerfAccountPassword = a_properties.getProperty(IS_PROP_NAME_PERFACCOUNT_PASSWORD, IS_PROP_VALUE_PERFACCOUNT_PASSWORD);
                String strPerfBlackList = a_properties.getProperty(IS_PROP_NAME_BLACKLIST, "").trim();
                String strPerfWhiteList = a_properties.getProperty(IS_PROP_NAME_WHITELIST, "").trim();
                StringTokenizer stBlack = new StringTokenizer(strPerfBlackList, ",");
                StringTokenizer stWhite = new StringTokenizer(strPerfWhiteList, ",");
                while (stBlack.hasMoreTokens()) {
                    this.m_perfBlackList.addElement(stBlack.nextToken());
                }
                while (stWhite.hasMoreTokens()) {
                    this.m_perfWhiteList.addElement(stWhite.nextToken());
                }
                this.m_bPerfServerEnabled = Boolean.valueOf(a_properties.getProperty(IS_PROP_NAME_PERF_SERVER, IS_PROP_VALUE_PERF_SERVER));
            }
        }
        catch (Exception e) {
            System.err.println("Error reading configuration!");
            System.err.println("Exception: " + e.toString());
            throw e;
        }
    }

    public Vector getInitialNeighbourInfoServices() {
        return this.m_initialNeighbourInfoServices;
    }

    public Vector<ListenerInterface> getHardwareListeners() {
        return this.m_hardwareListenerList;
    }

    public int getNrOfConcurrentConnections() {
        return this.m_NrOfThreads;
    }

    public Vector<ListenerInterface> getVirtualListeners() {
        return this.m_virtualListenerList;
    }

    public String getID() {
        return this.m_strID;
    }

    public String getOwnName() {
        return this.m_strOwnName;
    }

    public int getMaxPostContentLength() {
        return this.m_iMaxPostContentLength;
    }

    public boolean isStatusStatisticsEnabled() {
        return this.m_bStatusStatisticsEnabled;
    }

    public long getStatusStatisticsInterval() {
        return this.m_lStatusStatisticsInterval;
    }

    public String getStatusStatisticsLogDir() {
        return this.m_strStatusStatisticsLogDir;
    }

    public String getProxyAddresses() {
        return this.m_strProxyAddresses;
    }

    public static SimpleDateFormat getHttpDateFormat() {
        return ms_httpDateFormat;
    }

    public boolean isRootOfUpdateInformation() {
        return this.m_bRootOfUpdateInformation;
    }

    public String getJapReleaseJnlpFile() {
        return this.m_strJapReleaseJnlpFile;
    }

    public String getJapDevelopmentJnlpFile() {
        return this.m_strJapDevelopmentJnlpFile;
    }

    public File getJavaLatestVersionFile() {
        return this.m_strJavaLatestVersionFile;
    }

    public File getMessageFile() {
        return this.m_messageFile;
    }

    public String getJapMinVersionFile() {
        return this.m_strJapMinVersionFile;
    }

    public JAPMinVersion getJapMinVersionOld() {
        return this.m_japMinVersionOld;
    }

    public double getJapUpdatePropability() {
        return this.m_dJapUpdatePropability;
    }

    public Date getStartupTime() {
        return this.m_startupTime;
    }

    public boolean holdForwarderList() {
        return this.m_holdForwarderList;
    }

    public static void loadTrustedCertificateFiles(Properties a_properties, String a_strProperty, int a_certificateType, String a_strName, boolean bWarnIfNotAvailable) {
        String trustedCertFiles = a_properties.getProperty(a_strProperty);
        if (trustedCertFiles != null && !trustedCertFiles.trim().equals("")) {
            StringTokenizer stTrustedCertificates = new StringTokenizer(trustedCertFiles.trim(), ",");
            while (stTrustedCertificates.hasMoreTokens()) {
                String currentCertificateFile = stTrustedCertificates.nextToken().trim();
                JAPCertificate currentCertificate = Configuration.loadX509Certificate(currentCertificateFile);
                if (currentCertificate != null) {
                    SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(currentCertificate, a_certificateType, true, true);
                    LogHolder.log(7, LogType.MISC, "Added the following file to the store of trusted " + a_strName + " certificates: " + currentCertificateFile);
                    continue;
                }
                LogHolder.log(3, LogType.MISC, "Error loading trusted " + a_strName + " certificate: " + currentCertificateFile);
            }
        } else if (bWarnIfNotAvailable) {
            LogHolder.log(4, LogType.MISC, "No trusted " + a_strName + " certificates specified.");
        }
    }

    private PKCS12 loadPkcs12PrivateKey(String a_pkcs12FileName, String a_password) throws FileNotFoundException {
        PKCS12 loadedCertificate = null;
        if (a_password == null) {
            a_password = "";
        }
        try {
            loadedCertificate = PKCS12.getInstance((InputStream)new FileInputStream(a_pkcs12FileName), a_password.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadedCertificate;
    }

    public static JAPCertificate loadX509Certificate(String a_x509FileName) {
        return JAPCertificate.getInstance(new File(a_x509FileName));
    }

    public boolean isPassive() {
        return this.m_bPassive;
    }

    public Object[] getPerformanceMeterConfig() {
        return this.m_aPerfMeterConf;
    }

    public boolean isPerfEnabled() {
        return this.m_bPerfEnabled;
    }

    public boolean isPerfServerEnabled() {
        return this.m_bPerfServerEnabled;
    }

    public File getPerfAccountDirectory() {
        return this.m_strPerfAccountDirectory;
    }

    public String getPerfAccountPassword() {
        return this.m_strPerfAccountPassword;
    }

    public Vector getPerfBlackList() {
        return this.m_perfBlackList;
    }

    public Vector getPerfWhiteList() {
        return this.m_perfWhiteList;
    }

    public Vector getHostList() {
        return this.m_hostList;
    }

    public File getTermsAndConditionsDir() {
        return new File(IS_PROP_VALUE_TERMS_AND_CONDITIONS_DIR);
    }

    static {
        IS_PROP_VALUE_PERFACCOUNT_PASSWORD = null;
    }
}

