/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.mmrdescription;

import anon.crypto.MyRandom;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.mixminion.mmrdescription.MMRListFetcher;
import anon.mixminion.mmrdescription.ServerStats;
import anon.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class MMRList {
    private Vector m_mixminionrouters = new Vector();
    private Vector m_exitnodes;
    private Vector m_fragexitnodes = new Vector();
    private Hashtable m_mixminionroutersWithNames;
    private MyRandom m_rand;
    private MMRListFetcher m_mmrlistFetcher;

    public MMRList(MMRListFetcher fetcher) {
        this.m_exitnodes = new Vector();
        this.m_mixminionroutersWithNames = new Hashtable();
        this.m_mmrlistFetcher = fetcher;
        this.m_rand = new MyRandom();
    }

    public synchronized int size() {
        return this.m_mixminionrouters.size();
    }

    public synchronized void setFetcher(MMRListFetcher fetcher) {
        this.m_mmrlistFetcher = fetcher;
    }

    public synchronized boolean updateList() {
        try {
            byte[] doc = this.m_mmrlistFetcher.getMMRList();
            if (doc == null) {
                return false;
            }
            return this.parseDocument(doc);
        }
        catch (Throwable t) {
            LogHolder.log(7, LogType.MISC, "There was a problem with fetching the available MMRouters: " + t.getMessage());
            return false;
        }
    }

    public Vector getList() {
        return this.m_mixminionrouters;
    }

    public synchronized MMRDescription getByName(String name) {
        return (MMRDescription)this.m_mixminionroutersWithNames.get(name);
    }

    public synchronized void remove(String name) {
        MMRDescription mmrd = this.getByName(name);
        this.m_mixminionrouters.removeElement(mmrd);
        this.m_exitnodes.removeElement(mmrd);
        this.m_mixminionroutersWithNames.remove(name);
    }

    public synchronized MMRDescription getByRandom(Vector allowedNames) {
        return (MMRDescription)allowedNames.elementAt(this.m_rand.nextInt(allowedNames.size()));
    }

    public synchronized MMRDescription getByRandom() {
        return (MMRDescription)this.m_mixminionrouters.elementAt(this.m_rand.nextInt(this.m_mixminionrouters.size()));
    }

    public synchronized Vector getByRandomWithExit(int hops) {
        Vector<MMRDescription> routers = new Vector<MMRDescription>();
        MMRDescription x = null;
        boolean contains = true;
        for (int i = 0; i < hops - 1; ++i) {
            contains = true;
            for (int abbruch = 0; contains && abbruch != 10; ++abbruch) {
                x = this.getByRandom();
                contains = routers.contains(x);
            }
            routers.addElement(x);
        }
        contains = true;
        for (int abbruch = 0; contains && abbruch != 10; ++abbruch) {
            x = this.getByRandom(this.m_exitnodes);
            contains = routers.contains(x);
        }
        routers.addElement(x);
        return routers;
    }

    public synchronized Vector getByRandomWithFrag(int hops, int frags) {
        Vector routes = new Vector();
        Vector<MMRDescription> route = null;
        MMRDescription temp = null;
        MMRDescription exit = null;
        boolean contains = true;
        exit = this.getByRandom(this.m_fragexitnodes);
        for (int i = 0; i < frags; ++i) {
            route = new Vector<MMRDescription>();
            for (int j = 0; j < hops - 1; ++j) {
                contains = true;
                while (contains) {
                    temp = this.getByRandom();
                    contains = route.contains(temp);
                }
                route.addElement(temp);
            }
            route.addElement(exit);
            routes.addElement(route);
        }
        return routes;
    }

    public synchronized MMRDescription getMMRDescription(String name) {
        if (this.m_mixminionroutersWithNames.containsKey(name)) {
            return (MMRDescription)this.m_mixminionroutersWithNames.get(name);
        }
        return null;
    }

    private boolean parseDocument(byte[] document) throws Exception {
        Vector<MMRDescription> mmrs = new Vector<MMRDescription>();
        Vector<MMRDescription> enodes = new Vector<MMRDescription>();
        Vector<MMRDescription> fnodes = new Vector<MMRDescription>();
        Hashtable<String, MMRDescription> mmrswn = new Hashtable<String, MMRDescription>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(document)));
        String aktLine = reader.readLine();
        ServerStats servSt = new ServerStats();
        Vector downServers = servSt.getWhoIsDown();
        if (aktLine == null) {
            return false;
        }
        while ((aktLine = reader.readLine()) != null) {
            if (!aktLine.startsWith("[Server]")) continue;
            MMRDescription mmrd = MMRDescription.parse(reader);
            if (mmrd != null && !downServers.contains(mmrd.getName())) {
                boolean addme = true;
                if (mmrswn.containsKey(mmrd.getName())) {
                    addme = false;
                }
                if (addme) {
                    if (mmrd.isExitNode()) {
                        if (mmrd.allowsFragmented()) {
                            fnodes.addElement(mmrd);
                        } else {
                            enodes.addElement(mmrd);
                        }
                    }
                    mmrs.addElement(mmrd);
                    mmrswn.put(mmrd.getName(), mmrd);
                }
            }
            LogHolder.log(7, LogType.MISC, "Added: " + mmrd);
        }
        this.m_exitnodes = enodes;
        this.m_fragexitnodes = fnodes;
        LogHolder.log(7, LogType.MISC, "ExitNodes : " + enodes.size() + "Frag-Exit-Nodes:" + fnodes.size());
        this.m_mixminionrouters = mmrs;
        this.m_mixminionroutersWithNames = mmrswn;
        if (mmrswn.isEmpty()) {
            System.out.println("Infoservice geht nicht!");
            return false;
        }
        return true;
    }

    public void vectortostring(Vector v) {
        String huhu = "";
        for (int i = 0; i < v.size(); ++i) {
            huhu = huhu + ((MMRDescription)v.elementAt(i)).getName() + ",";
        }
        System.out.println(huhu);
    }

    public Vector mytesting() {
        MMRDescription mym = new MMRDescription("localhost", "rinos", 48099, Base64.decode("nLrOnRowaQV/U/1XCUlXicIAIKc="), Base64.decode("MK2+xQEe59Zfwd+7nQ17PCgVBlg="), true, true, "egal", null);
        mym.setIdentityKey(Base64.decode("MIIBCgKCAQEAs6lIEY4Vz2skNL8SHJKkO5hvfernaBkhO/RnowiyFD/TaHQ1kdxYryaIu3dQ3M03eh+k5VoPiU/sX9+OfmHu0hB4vIqm5c5UtOkigSZOhEBDnZ31OgmfrK0+TaQHqNoF9lgT95QC6KXUgdpbhz2Qklg6qNxPWAbKLlewr6g0RBO51pFM/KK4IF9DMu8jQ8dssmWddPWZcdmQuY77njVr83OcPkpP/T8K+heVdkw7/jmlPAJ+wC2iCgkOtM5NJhk6+8NqOA57P5xXkrcEJkA6qRG9pvYYKsN4lor3asETT+X8mMOEuAkkwBTkRkhovqhQ1WPR0MAHTXUKP1wYAjkB4QIDAQAB"));
        mym.setPacketKey(Base64.decode("MIIBCgKCAQEA0SiCjybZ/+YsuHG9pgAIFNN0j+xF5ZPu3YI1F9MtgGkYQ7xfSrUJksbXprfo+QjJS5izTLkXQfFlUzViy0DMC7JHufofCh1o3lqryGnmE0S0XVD5Cvvz2OLMyRhINLmytp+CXx3E355EVmDebJNtqVRoZaPdZRnvQ2wkB5I6dhiAmhhzIAQVho4DQFf7+2Riv++1VP097TxAww/2gzdq7Pmv3PDd+TI2djAOMDMZO9ZjeZrCX+B7WGZxIBX/hISi9ck1AYq9ss1F4mAOHStgUFoD/iwcONh9OiLyGUhWdmZDrH4HwTutm8thTgt7l3w6LEnvi3Fg8YqeyAp2ocCMOwIDAQAB"));
        Vector<MMRDescription> retn = new Vector<MMRDescription>();
        retn.addElement(mym);
        retn.addElement(mym);
        return retn;
    }
}

