/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MixCascadeExitAddresses
extends AbstractDatabaseEntry
implements IXMLEncodable {
    public static final long EXIT_ADDRESS_TTL = 604800000L;
    public static final long EXIT_ADDRESS_TTL_INFOSERVICE = 86400000L;
    public static final String XML_ELEMENT_CONTAINER_NAME = "ExitAddressesList";
    public static final String XML_ELEMENT_NAME = "ExitAddresses";
    public static final String XML_ELEMENT_ADDRESS_NAME = "ExitAddress";
    private static final String XML_ATTR_LAST_UPDATE = "lastUpdate";
    public static final String XML_ATTR_DISTRIBUTION = "distribution";
    private static final String XML_ATTR_INFO_SERVICE = "infoservice";
    public static final String XML_ATTR_PAYMENT = "payment";
    private long m_lastUpdate;
    private String m_strCascadeId = null;
    private Hashtable m_tblAddresses = new Hashtable();
    private int m_distribution = 0;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$infoservice$MixCascadeExitAddresses;
    static /* synthetic */ Class class$java$net$InetAddress;

    private MixCascadeExitAddresses(String a_cascadeID, long a_lastUpdate) {
        super(a_lastUpdate + 604800000L);
        this.m_strCascadeId = a_cascadeID;
        this.m_lastUpdate = a_lastUpdate;
    }

    public MixCascadeExitAddresses(Element a_xmlElement) throws XMLParseException {
        super(System.currentTimeMillis() + 604800000L);
        XMLUtil.assertNodeName(a_xmlElement, XML_ELEMENT_NAME);
        XMLUtil.assertNotNull(a_xmlElement, "id");
        this.m_strCascadeId = XMLUtil.parseAttribute((Node)a_xmlElement, "id", null);
        this.m_distribution = XMLUtil.parseAttribute((Node)a_xmlElement, XML_ATTR_DISTRIBUTION, 6);
        MixCascade cascade = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = MixCascadeExitAddresses.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_strCascadeId);
        if (cascade != null) {
            this.m_distribution = cascade.getDistribution();
        }
        this.m_lastUpdate = System.currentTimeMillis();
        NodeList lstAddresses = a_xmlElement.getElementsByTagName(XML_ELEMENT_ADDRESS_NAME);
        for (int i = 0; i < lstAddresses.getLength(); ++i) {
            InetAddress address;
            long lTime = XMLUtil.parseAttribute(lstAddresses.item(i), XML_ATTR_LAST_UPDATE, System.currentTimeMillis());
            XMLUtil.assertNotNull(lstAddresses.item(i));
            try {
                address = InetAddress.getByName(XMLUtil.parseValue(lstAddresses.item(i), null));
            }
            catch (UnknownHostException e) {
                LogHolder.log(4, LogType.NET, e);
                continue;
            }
            this.addInetAddress(address, this.m_distribution, lTime, null);
        }
    }

    public String getId() {
        return this.m_strCascadeId;
    }

    public int getDistribution() {
        return this.m_distribution;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.m_lastUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createExitAddressAsString() {
        Hashtable hashtable = this.m_tblAddresses;
        synchronized (hashtable) {
            Enumeration<Object> enumer = this.m_tblAddresses.keys();
            if (this.m_tblAddresses.size() == 1) {
                InetAddress addr = (InetAddress)enumer.nextElement();
                Hashtable hashID = (Hashtable)this.m_tblAddresses.get(addr);
                enumer = hashID.elements();
                while (enumer.hasMoreElements()) {
                    if (((InfoServiceID)enumer.nextElement()).getLastUpdate() < System.currentTimeMillis() - 604800000L) continue;
                    return addr.getHostAddress();
                }
                return null;
            }
            if (this.m_tblAddresses.size() > 1) {
                boolean bIPv6 = false;
                String strNextIP = null;
                Vector<InetAddress> vecSuitableAddresses = new Vector<InetAddress>();
                while (enumer.hasMoreElements()) {
                    InetAddress addr = (InetAddress)enumer.nextElement();
                    Hashtable hashID = (Hashtable)this.m_tblAddresses.get(addr);
                    Enumeration enumerIDs = hashID.elements();
                    int iCounter = 0;
                    while (enumerIDs.hasMoreElements()) {
                        InfoServiceID id = (InfoServiceID)enumerIDs.nextElement();
                        if (id.getLastUpdate() < System.currentTimeMillis() - 604800000L) continue;
                        ++iCounter;
                        if (id.getID() != "OWN_ID") continue;
                        iCounter = Integer.MAX_VALUE;
                        break;
                    }
                    if (iCounter <= true) continue;
                    vecSuitableAddresses.addElement(addr);
                }
                if (vecSuitableAddresses.size() == 0) {
                    return null;
                }
                String strCurrentIP = ((InetAddress)vecSuitableAddresses.elementAt(0)).getHostAddress();
                if (vecSuitableAddresses.size() == 1) {
                    return strCurrentIP;
                }
                for (int i = 1; i < vecSuitableAddresses.size(); ++i) {
                    strNextIP = ((InetAddress)vecSuitableAddresses.elementAt(i)).getHostAddress();
                    int index = strNextIP.lastIndexOf(".");
                    if (index < 0) {
                        index = strNextIP.lastIndexOf(":");
                        bIPv6 = true;
                    }
                    if (strCurrentIP.startsWith(strNextIP = strNextIP.substring(0, index))) continue;
                    return null;
                }
                return strNextIP + (bIPv6 ? ":" : ".") + "*";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixCascadeExitAddresses addInetAddress(String a_cascadeID, InetAddress a_IPAddress, int a_cascadeDistribution, String a_strInfoServiceID) {
        Database database = Database.getInstance(class$anon$infoservice$MixCascadeExitAddresses == null ? (class$anon$infoservice$MixCascadeExitAddresses = MixCascadeExitAddresses.class$("anon.infoservice.MixCascadeExitAddresses")) : class$anon$infoservice$MixCascadeExitAddresses);
        synchronized (database) {
            MixCascadeExitAddresses exit = null;
            MixCascadeExitAddresses exitNew = null;
            long lastUpdate = System.currentTimeMillis();
            if (a_cascadeID != null && a_cascadeID.trim().length() > 0 && a_IPAddress != null) {
                exit = (MixCascadeExitAddresses)Database.getInstance(class$anon$infoservice$MixCascadeExitAddresses == null ? (class$anon$infoservice$MixCascadeExitAddresses = MixCascadeExitAddresses.class$("anon.infoservice.MixCascadeExitAddresses")) : class$anon$infoservice$MixCascadeExitAddresses).getEntryById(a_cascadeID);
                if (exit != null) {
                    lastUpdate = exit.getLastUpdate() + 1L;
                }
                exitNew = new MixCascadeExitAddresses(a_cascadeID, lastUpdate);
                if (exit != null) {
                    Hashtable hashtable = exit.m_tblAddresses;
                    synchronized (hashtable) {
                        Enumeration enumer = exit.m_tblAddresses.keys();
                        while (enumer.hasMoreElements()) {
                            InetAddress addr = (InetAddress)enumer.nextElement();
                            Hashtable hashID = (Hashtable)exit.m_tblAddresses.get(addr);
                            Enumeration enumID = hashID.elements();
                            while (enumID.hasMoreElements()) {
                                InfoServiceID id = (InfoServiceID)enumID.nextElement();
                                exitNew.addInetAddress(addr, a_cascadeDistribution, id.getLastUpdate(), id.getID());
                            }
                        }
                    }
                }
                if (exitNew.addInetAddress(a_IPAddress, a_cascadeDistribution, a_strInfoServiceID) && Database.getInstance(class$anon$infoservice$MixCascadeExitAddresses == null ? (class$anon$infoservice$MixCascadeExitAddresses = MixCascadeExitAddresses.class$("anon.infoservice.MixCascadeExitAddresses")) : class$anon$infoservice$MixCascadeExitAddresses).update(exitNew)) {
                    return exitNew;
                }
            }
            return exit;
        }
    }

    public static boolean isValidAddress(InetAddress a_address) {
        return MixCascadeExitAddresses.isValidAddress(a_address, "isAnyLocalAddress") || MixCascadeExitAddresses.isValidAddress(a_address, "isLoopbackAddress") || MixCascadeExitAddresses.isValidAddress(a_address, "isLinkLocalAddress") || MixCascadeExitAddresses.isValidAddress(a_address, "isMulticastAddress") || MixCascadeExitAddresses.isValidAddress(a_address, "isSiteLocalAddress");
    }

    private static boolean isValidAddress(InetAddress a_address, String a_methodName) {
        try {
            return (Boolean)(class$java$net$InetAddress == null ? (class$java$net$InetAddress = MixCascadeExitAddresses.class$("java.net.InetAddress")) : class$java$net$InetAddress).getMethod(a_methodName, null).invoke((Object)a_address, (Object[])null) == false;
        }
        catch (Exception a_e) {
            return true;
        }
    }

    private boolean addInetAddress(InetAddress a_addr, int a_cascadeDistribution, String a_strInfoServiceID) {
        return this.addInetAddress(a_addr, a_cascadeDistribution, System.currentTimeMillis(), a_strInfoServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInetAddress(InetAddress a_addr, int a_cascadeDistribution, long a_timestamp, String a_strInfoServiceID) {
        boolean bChanged = false;
        if (a_strInfoServiceID == null) {
            a_strInfoServiceID = "OWN_ID";
        }
        Hashtable hashtable = this.m_tblAddresses;
        synchronized (hashtable) {
            InfoServiceID id;
            Hashtable hashID;
            Enumeration e = this.m_tblAddresses.keys();
            Vector<InfoServiceID> vecIDsToRemove = new Vector<InfoServiceID>();
            while (e.hasMoreElements()) {
                InetAddress addr = (InetAddress)e.nextElement();
                hashID = (Hashtable)this.m_tblAddresses.get(addr);
                Enumeration enumIDs = hashID.elements();
                while (enumIDs.hasMoreElements()) {
                    id = (InfoServiceID)enumIDs.nextElement();
                    if (id.getLastUpdate() >= System.currentTimeMillis() - 604800000L) continue;
                    LogHolder.log(4, LogType.DB, "Exit address expired: " + id);
                    vecIDsToRemove.addElement(id);
                    bChanged = true;
                }
            }
            for (int i = 0; i < vecIDsToRemove.size(); ++i) {
                id = (InfoServiceID)vecIDsToRemove.elementAt(i);
                hashID = (Hashtable)this.m_tblAddresses.get(id.getInetAddress());
                hashID.remove(id.getID());
                if (hashID.size() != 0) continue;
                this.m_tblAddresses.remove(id.getInetAddress());
            }
            if (this.m_distribution != a_cascadeDistribution) {
                this.m_distribution = a_cascadeDistribution;
                bChanged = true;
            }
            if (a_timestamp < System.currentTimeMillis() - 604800000L) {
                return false;
            }
            boolean bAdded = false;
            if (!this.m_tblAddresses.containsKey(a_addr)) {
                hashID = new Hashtable();
                hashID.put(a_strInfoServiceID, new InfoServiceID(a_addr, a_strInfoServiceID, a_timestamp));
                bChanged = true;
                bAdded = true;
            } else {
                hashID = (Hashtable)this.m_tblAddresses.get(a_addr);
                if (!hashID.contains(a_strInfoServiceID) || ((InfoServiceID)hashID.get(a_strInfoServiceID)).getLastUpdate() < a_timestamp) {
                    hashID.put(a_strInfoServiceID, new InfoServiceID(a_addr, a_strInfoServiceID, a_timestamp));
                    bChanged = true;
                    bAdded = true;
                }
            }
            this.m_tblAddresses.put(a_addr, hashID);
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Element elem = a_doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(elem, "id", this.getId());
        XMLUtil.setAttribute(elem, XML_ATTR_DISTRIBUTION, this.getDistribution());
        Hashtable hashtable = this.m_tblAddresses;
        synchronized (hashtable) {
            Enumeration e = this.m_tblAddresses.keys();
            Vector<InetAddress> vecAddrToDelete = new Vector<InetAddress>();
            while (e.hasMoreElements()) {
                InfoServiceID id;
                InetAddress addr = (InetAddress)e.nextElement();
                Hashtable hashID = (Hashtable)this.m_tblAddresses.get(addr);
                if (!hashID.containsKey("OWN_ID") && hashID.size() <= 1) continue;
                String strID = null;
                long timestamp = 0L;
                if (hashID.size() > 1) {
                    hashID.remove("OWN_ID");
                    if (hashID.size() > 1) {
                        timestamp = 0L;
                        Enumeration enumIDs = hashID.elements();
                        while (enumIDs.hasMoreElements()) {
                            id = (InfoServiceID)enumIDs.nextElement();
                            if (id.getLastUpdate() <= timestamp) continue;
                            timestamp = id.getLastUpdate();
                            strID = id.getID();
                        }
                    }
                } else if (hashID.containsKey("OWN_ID")) {
                    id = (InfoServiceID)hashID.get("OWN_ID");
                    timestamp = id.getLastUpdate();
                    strID = "OWN_ID";
                }
                if (timestamp >= System.currentTimeMillis() - 604800000L) {
                    Element el = a_doc.createElement(XML_ELEMENT_ADDRESS_NAME);
                    XMLUtil.setAttribute(el, XML_ATTR_LAST_UPDATE, timestamp);
                    if (strID != null && !strID.equals("OWN_ID")) {
                        XMLUtil.setAttribute(el, XML_ATTR_INFO_SERVICE, strID);
                    }
                    XMLUtil.setValue((Node)el, addr.getHostAddress());
                    elem.appendChild(el);
                    continue;
                }
                vecAddrToDelete.addElement(addr);
            }
            for (int i = 0; i < vecAddrToDelete.size(); ++i) {
                this.m_tblAddresses.remove(vecAddrToDelete.elementAt(i));
            }
        }
        return elem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class InfoServiceID {
        private static final String OWN_ID = "OWN_ID";
        private String m_ID;
        private long m_lLastUpdate;
        private InetAddress m_addInet;

        private InfoServiceID(InetAddress a_addInet, String a_ID, long a_lLastUpdate) {
            this.m_ID = a_ID;
            this.m_addInet = a_addInet;
            this.m_lLastUpdate = a_lLastUpdate;
        }

        public boolean equals(Object a_object) {
            if (a_object == null) {
                return false;
            }
            if (!(a_object instanceof InfoServiceID)) {
                return false;
            }
            return ((InfoServiceID)a_object).getID().equals(this.getID());
        }

        public int hashCode() {
            return this.m_ID.hashCode();
        }

        public InetAddress getInetAddress() {
            return this.m_addInet;
        }

        public String getID() {
            return this.m_ID;
        }

        public long getLastUpdate() {
            return this.m_lLastUpdate;
        }

        public String toString() {
            return this.m_ID + " / " + this.m_addInet;
        }
    }
}

