/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls;

import anon.crypto.tinytls.AbstractTLSRecord;

public final class TLSHandshakeRecord
extends AbstractTLSRecord {
    public static final int HEADER_LENGTH = 4;
    static final int TYPE_CLIENT_HELLO = 1;
    static final int TYPE_SERVER_HELLO = 2;
    static final int TYPE_CERTIFICATE = 11;
    static final int TYPE_SERVER_KEY_EXCHANGE = 12;
    static final int TYPE_CERTIFICATE_REQUEST = 13;
    static final int TYPE_SERVER_HELLO_DONE = 14;
    static final int TYPE_CERTIFICATE_VERIFY = 15;
    static final int TYPE_CLIENT_KEY_EXCHANGE = 16;
    static final int TYPE_FINISHED = 20;

    public TLSHandshakeRecord(byte[] data, int off) {
        this.m_Header = new byte[4];
        System.arraycopy(data, off, this.m_Header, 0, 4);
        this.m_Type = this.m_Header[0];
        this.m_dataLen = (this.m_Header[1] & 0xFF) << 16 | (this.m_Header[2] & 0xFF) << 8 | this.m_Header[3] & 0xFF;
        this.m_Data = new byte[this.m_dataLen];
        System.arraycopy(data, off + 4, this.m_Data, 0, this.m_dataLen);
    }

    public int getHeaderLength() {
        return 4;
    }
}

