/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPath;
import anon.crypto.CertificateInfoStructure;
import anon.crypto.CertificateStore;
import anon.crypto.XMLSignature;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureVerifier
implements IXMLEncodable {
    public static final int DOCUMENT_CLASS_NONE = 0;
    public static final int DOCUMENT_CLASS_MIX = 1;
    public static final int DOCUMENT_CLASS_INFOSERVICE = 2;
    public static final int DOCUMENT_CLASS_UPDATE = 3;
    public static final int DOCUMENT_CLASS_PAYMENT = 4;
    public static final int DOCUMENT_CLASS_TERMS = 5;
    public static final String XML_ELEMENT_NAME = "SignatureVerification";
    private static final String XML_ATTR_CHECK = "check";
    private static final String XML_DOCUMENT_CLASS = "DocumentClass";
    private static final String XML_ATTR_CLASS = "class";
    private static SignatureVerifier ms_svInstance;
    private Hashtable m_hashSignatureChecks;
    private CertificateStore m_trustedCertificates = new CertificateStore();
    private boolean m_checkSignatures = true;
    static /* synthetic */ Class class$anon$crypto$SignatureVerifier;

    private SignatureVerifier() {
        this.m_hashSignatureChecks = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignatureVerifier getInstance() {
        Class clazz = class$anon$crypto$SignatureVerifier == null ? (class$anon$crypto$SignatureVerifier = SignatureVerifier.class$("anon.crypto.SignatureVerifier")) : class$anon$crypto$SignatureVerifier;
        synchronized (clazz) {
            if (ms_svInstance == null) {
                ms_svInstance = new SignatureVerifier();
            }
        }
        return ms_svInstance;
    }

    public static String getXmlSettingsRootNodeName() {
        return XML_ELEMENT_NAME;
    }

    public synchronized void setCheckSignatures(boolean a_checkSignaturesEnabled) {
        if (this.m_checkSignatures != a_checkSignaturesEnabled) {
            this.m_checkSignatures = a_checkSignaturesEnabled;
            this.m_trustedCertificates.reset();
        }
    }

    public void setCheckSignatures(int a_documentClass, boolean a_bCheckignatures) {
        this.m_hashSignatureChecks.put(new Integer(a_documentClass), new Boolean(a_bCheckignatures));
    }

    public boolean isCheckSignatures(int a_documentClass) {
        if (!this.isCheckSignatures()) {
            return false;
        }
        Boolean bCheckSignatures = (Boolean)this.m_hashSignatureChecks.get(new Integer(a_documentClass));
        if (bCheckSignatures == null) {
            return true;
        }
        return bCheckSignatures;
    }

    public boolean isCheckSignatures() {
        return this.m_checkSignatures;
    }

    public CertificateStore getVerificationCertificateStore() {
        return this.m_trustedCertificates;
    }

    public boolean verifyXml(Document a_rootNode, int a_documentClass) {
        if (!this.isCheckSignatures(a_documentClass)) {
            return true;
        }
        if (a_rootNode == null) {
            return false;
        }
        return this.verifyXml(a_rootNode.getDocumentElement(), a_documentClass);
    }

    public boolean verifyXml(Element a_rootNode, int a_documentClass) {
        if (!this.isCheckSignatures(a_documentClass)) {
            return true;
        }
        if (a_rootNode == null) {
            return false;
        }
        XMLSignature signature = this.getVerifiedXml(a_rootNode, a_documentClass);
        if (signature != null) {
            return signature.isVerified();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLSignature getVerifiedXml(Element a_rootNode, int a_documentClass) {
        XMLSignature signature = null;
        CertificateStore certificateStore = this.m_trustedCertificates;
        synchronized (certificateStore) {
            Vector additionalCertificateInfoStructures = new Vector();
            switch (a_documentClass) {
                case 1: {
                    additionalCertificateInfoStructures = this.m_trustedCertificates.getAvailableCertificatesByType(2);
                    break;
                }
                case 2: {
                    additionalCertificateInfoStructures = this.m_trustedCertificates.getAvailableCertificatesByType(3);
                    break;
                }
                case 3: {
                    additionalCertificateInfoStructures = this.m_trustedCertificates.getAvailableCertificatesByType(4);
                    break;
                }
                case 4: {
                    additionalCertificateInfoStructures = this.m_trustedCertificates.getAvailableCertificatesByType(7);
                    break;
                }
                case 5: {
                    additionalCertificateInfoStructures = this.m_trustedCertificates.getAvailableCertificatesByType(9);
                }
            }
            Vector<CertPath> additionalCertPaths = new Vector<CertPath>();
            Enumeration additionalCertificatesEnumerator = additionalCertificateInfoStructures.elements();
            while (additionalCertificatesEnumerator.hasMoreElements()) {
                CertificateInfoStructure certStructure = (CertificateInfoStructure)additionalCertificatesEnumerator.nextElement();
                if (!certStructure.isAvailable()) continue;
                additionalCertPaths.addElement(certStructure.getCertPath());
            }
            try {
                signature = XMLSignature.getVerified(a_rootNode, a_documentClass, additionalCertPaths);
            }
            catch (Exception e) {
                LogHolder.log(7, LogType.CRYPTO, "getVerifiedXml() exception", e);
            }
        }
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Element signatureVerificationNode = a_doc.createElement(XML_ELEMENT_NAME);
        CertificateStore certificateStore = this.m_trustedCertificates;
        synchronized (certificateStore) {
            Element checkSignaturesNode = a_doc.createElement("CheckSignatures");
            XMLUtil.setAttribute(checkSignaturesNode, XML_ATTR_CHECK, this.m_checkSignatures);
            Hashtable hashtable = this.m_hashSignatureChecks;
            synchronized (hashtable) {
                Enumeration enumChecks = this.m_hashSignatureChecks.keys();
                while (enumChecks.hasMoreElements()) {
                    Integer documentClass = (Integer)enumChecks.nextElement();
                    boolean check = (Boolean)this.m_hashSignatureChecks.get(documentClass);
                    Element elemTemp = a_doc.createElement(XML_DOCUMENT_CLASS);
                    XMLUtil.setAttribute(elemTemp, XML_ATTR_CLASS, documentClass);
                    XMLUtil.setAttribute(elemTemp, XML_ATTR_CHECK, check);
                    checkSignaturesNode.appendChild(elemTemp);
                }
            }
            Element trustedCertificatesNode = this.m_trustedCertificates.toXmlElement(a_doc);
            signatureVerificationNode.appendChild(checkSignaturesNode);
            signatureVerificationNode.appendChild(trustedCertificatesNode);
        }
        return signatureVerificationNode;
    }

    public void loadSettingsFromXml(Element a_signatureVerificationNode) throws Exception {
        this.loadSettingsFromXml(a_signatureVerificationNode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettingsFromXml(Element a_signatureVerificationNode, Hashtable a_ignoredDocClasses) throws Exception {
        CertificateStore certificateStore = this.m_trustedCertificates;
        synchronized (certificateStore) {
            Element checkSignaturesNode = (Element)XMLUtil.getFirstChildByName(a_signatureVerificationNode, "CheckSignatures");
            if (checkSignaturesNode == null) {
                throw new Exception("No CheckSignatures node found.");
            }
            this.m_checkSignatures = XMLUtil.parseAttribute((Node)checkSignaturesNode, XML_ATTR_CHECK, true);
            NodeList listCheckSignatures = checkSignaturesNode.getElementsByTagName(XML_DOCUMENT_CLASS);
            for (int i = 0; i < listCheckSignatures.getLength(); ++i) {
                int documentClass = XMLUtil.parseAttribute(listCheckSignatures.item(i), XML_ATTR_CLASS, -1);
                if (documentClass < 0 || a_ignoredDocClasses != null && a_ignoredDocClasses.containsKey(new Integer(documentClass))) continue;
                this.m_hashSignatureChecks.put(new Integer(documentClass), new Boolean(XMLUtil.parseAttribute(listCheckSignatures.item(i), XML_ATTR_CHECK, true)));
            }
            Element trustedCertificatesNode = (Element)XMLUtil.getFirstChildByName(a_signatureVerificationNode, CertificateStore.getXmlSettingsRootNodeName());
            if (trustedCertificatesNode == null) {
                throw new Exception("No TrustedCertificates node found.");
            }
            this.m_trustedCertificates.loadSettingsFromXml(trustedCertificatesNode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

